/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class StartEndTimeSelector
extends Composite
implements HasValue<StartEndTime> {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private UniTimeWidget<HorizontalPanel> iPanel;
    private TimeSelector iStart;
    private TimeSelector iEnd;

    public StartEndTimeSelector() {
        HorizontalPanel panel = new HorizontalPanel();
        panel.setSpacing(2);
        panel.setStyleName("unitime-TimeSelectorPanel");
        Label labelFrom = new Label(MESSAGES.propFrom());
        panel.add((Widget)labelFrom);
        panel.setCellVerticalAlignment((Widget)labelFrom, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iStart = new TimeSelector(null);
        panel.add((Widget)this.iStart);
        Label labelTo = new Label(MESSAGES.propTo());
        labelTo.getElement().getStyle().setPaddingLeft(5.0, Style.Unit.PX);
        panel.add((Widget)labelTo);
        panel.setCellVerticalAlignment((Widget)labelTo, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iEnd = new TimeSelector(this.iStart);
        panel.add((Widget)this.iEnd);
        this.iPanel = new UniTimeWidget<HorizontalPanel>(panel);
        this.initWidget((Widget)this.iPanel);
        this.iStart.addValueChangeHandler(new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                ValueChangeEvent.fire((HasValueChangeHandlers)StartEndTimeSelector.this, (Object)StartEndTimeSelector.this.getValue());
            }
        });
        this.iEnd.addValueChangeHandler(new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                ValueChangeEvent.fire((HasValueChangeHandlers)StartEndTimeSelector.this, (Object)StartEndTimeSelector.this.getValue());
            }
        });
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<StartEndTime> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public StartEndTime getValue() {
        return new StartEndTime(this.iStart.getValue(), this.iEnd.getValue());
    }

    public void setValue(StartEndTime value) {
        this.setValue(value, false);
    }

    public void setValue(StartEndTime value, boolean fireEvents) {
        this.iStart.setValue(value == null ? null : value.getStart(), fireEvents);
        this.iEnd.setValue(value == null ? null : value.getEnd(), fireEvents);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public void setDiff(Integer diff) {
        this.iEnd.setDiff(diff);
    }

    public static class StartEndTime
    implements IsSerializable {
        private Integer iStart;
        private Integer iEnd;

        public StartEndTime() {
        }

        public StartEndTime(Integer start, Integer end) {
            this.iStart = start;
            this.iEnd = end;
        }

        public boolean hasStart() {
            return this.iStart != null;
        }

        public Integer getStart() {
            return this.iStart;
        }

        public boolean hasEnd() {
            return this.iEnd != null;
        }

        public Integer getEnd() {
            return this.iEnd;
        }
    }
}

