/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.events;

import org.unitime.timetable.gwt.shared.EventInterface;

public class EventComparator {
    protected static int compareByName(EventInterface e1, EventInterface e2) {
        return EventComparator.compare(e1.getName(), e2.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static int compareBySection(EventInterface e1, EventInterface e2) {
        if (e1.hasExternalIds()) {
            if (!e2.hasExternalIds()) return -1;
            int cmp = e1.getExternalIds().get(0).compareTo(e2.getExternalIds().get(0));
            if (cmp == 0) return EventComparator.compare(e1.getSectionNumber(), e2.getSectionNumber());
            return cmp;
        }
        if (!e2.hasExternalIds()) return EventComparator.compare(e1.getSectionNumber(), e2.getSectionNumber());
        return 1;
    }

    protected static int compareByType(EventInterface e1, EventInterface e2) {
        int cmp;
        int n = e1.getType() == null ? (e2.getType() == null ? 0 : -1) : (cmp = e2.getType() == null ? 1 : e1.getType().compareTo(e2.getType()));
        if (cmp != 0) {
            return cmp;
        }
        return EventComparator.compare(e1.getInstructionType(), e2.getInstructionType());
    }

    protected static int compareBySponsor(EventInterface e1, EventInterface e2) {
        int cmp = EventComparator.compare(e1.getInstructorNames("|", null), e2.getInstructorNames("|", null));
        if (cmp != 0) {
            return cmp;
        }
        return EventComparator.compare(e1.hasSponsor() ? e1.getSponsor().getName() : null, e2.hasSponsor() ? e2.getSponsor().getName() : null);
    }

    protected static int compareByServices(EventInterface e1, EventInterface e2) {
        return EventComparator.compare(e1.getRequestedServices("|"), e2.getRequestedServices("|"));
    }

    protected static int compareByMainContact(EventInterface e1, EventInterface e2) {
        return EventComparator.compare(e1.hasContact() ? e1.getContact().toString() : null, e2.hasContact() ? e2.getContact().toString() : null);
    }

    protected static int compareByLimit(EventInterface e1, EventInterface e2) {
        return -(e1.hasMaxCapacity() ? e1.getMaxCapacity() : Integer.valueOf(0)).compareTo(e2.hasMaxCapacity() ? e2.getMaxCapacity() : Integer.valueOf(0));
    }

    protected static int compareByEnrollment(EventInterface e1, EventInterface e2) {
        return -(e1.hasEnrollment() ? e1.getEnrollment() : Integer.valueOf(0)).compareTo(e2.hasEnrollment() ? e2.getEnrollment() : Integer.valueOf(0));
    }

    public static int compareFallback(EventInterface e1, EventInterface e2) {
        int cmp = EventComparator.compareByName(e1, e2);
        if (cmp != 0) {
            return cmp;
        }
        cmp = EventComparator.compareBySection(e1, e2);
        if (cmp != 0) {
            return cmp;
        }
        cmp = EventComparator.compareByType(e1, e2);
        if (cmp != 0) {
            return cmp;
        }
        return e1.compareTo(e2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static int compareByTitle(EventInterface e1, EventInterface e2) {
        if (e1.hasCourseTitles()) {
            if (!e2.hasCourseTitles()) return -1;
            int cmp = e1.getCourseTitles().get(0).compareTo(e2.getCourseTitles().get(0));
            if (cmp == 0) return EventComparator.compareByName(e1, e2);
            return cmp;
        }
        if (!e2.hasCourseTitles()) return EventComparator.compareByName(e1, e2);
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static int compareByNote(EventInterface e1, EventInterface e2) {
        if (e1.hasNotes()) {
            if (!e2.hasNotes()) return -1;
            int cmp = e1.getNotes().first().getNote().compareTo(e2.getNotes().first().getNote());
            if (cmp == 0) return EventComparator.compareByName(e1, e2);
            return cmp;
        }
        if (!e2.hasNotes()) return EventComparator.compareByName(e1, e2);
        return 1;
    }

    protected static int compareByLastChange(EventInterface e1, EventInterface e2) {
        int cmp;
        EventInterface.NoteInterface n1 = e1.getLastNote();
        EventInterface.NoteInterface n2 = e2.getLastNote();
        int n = n1 == null ? (n2 == null ? 0 : 1) : (cmp = n2 == null ? -1 : n1.compareTo(n2));
        if (cmp != 0) {
            return cmp;
        }
        return EventComparator.compareByName(e1, e2);
    }

    public static int compareEvents(EventInterface e1, EventInterface e2, EventMeetingSortBy sortBy) {
        switch (sortBy) {
            case NAME: {
                return EventComparator.compareByName(e1, e2);
            }
            case SECTION: {
                return EventComparator.compareBySection(e1, e2);
            }
            case TYPE: {
                return EventComparator.compareByType(e1, e2);
            }
            case TITLE: {
                return EventComparator.compareByTitle(e1, e2);
            }
            case SPONSOR: {
                return EventComparator.compareBySponsor(e1, e2);
            }
            case MAIN_CONTACT: {
                return EventComparator.compareByMainContact(e1, e2);
            }
            case LIMIT: {
                return EventComparator.compareByLimit(e1, e2);
            }
            case ENROLLMENT: {
                return EventComparator.compareByEnrollment(e1, e2);
            }
            case NOTE: {
                return EventComparator.compareByNote(e1, e2);
            }
            case LAST_CHANGE: {
                return EventComparator.compareByLastChange(e1, e2);
            }
            case SERVICES: {
                return EventComparator.compareByServices(e1, e2);
            }
        }
        return 0;
    }

    protected static int compateByApproval(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
        if (m1.getId() == null && m2.getId() != null) {
            return -1;
        }
        if (m1.getId() != null && m2.getId() == null) {
            return 1;
        }
        if (m1.getApprovalDate() == null) {
            return m2.getApprovalDate() == null ? 0 : -1;
        }
        return m2.getApprovalDate() == null ? 1 : m1.getApprovalDate().compareTo(m2.getApprovalDate());
    }

    protected static int compareByName(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
        return EventComparator.compare(m1 instanceof EventInterface.MeetingConflictInterface ? ((EventInterface.MeetingConflictInterface)m1).getName() : null, m2 instanceof EventInterface.MeetingConflictInterface ? ((EventInterface.MeetingConflictInterface)m2).getName() : null);
    }

    protected static int compareByType(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
        EventInterface.EventType t2;
        EventInterface.EventType t1 = m1 instanceof EventInterface.MeetingConflictInterface ? ((EventInterface.MeetingConflictInterface)m1).getType() : null;
        EventInterface.EventType eventType = t2 = m2 instanceof EventInterface.MeetingConflictInterface ? ((EventInterface.MeetingConflictInterface)m2).getType() : null;
        return t1 == null ? (t2 == null ? 0 : -1) : (t2 == null ? 1 : t1.compareTo(t2));
    }

    protected static int compareByDate(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
        int cmp;
        if (m1 instanceof EventInterface.MeetingConflictInterface && m2 instanceof EventInterface.MeetingConflictInterface && (cmp = ((EventInterface.MeetingConflictInterface)m1).getName().compareTo(((EventInterface.MeetingConflictInterface)m2).getName())) != 0) {
            return cmp;
        }
        return m1.getMeetingDate() == null ? (m2.getMeetingDate() == null ? 0 : 1) : (m2.getMeetingDate() == null ? -1 : m1.getMeetingDate().compareTo(m2.getMeetingDate()));
    }

    protected static int compareByAllocatedTime(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
        int cmp = Integer.valueOf(m1.getStartSlot()).compareTo(m2.getStartSlot());
        if (cmp != 0) {
            return cmp;
        }
        return Integer.valueOf(m1.getEndSlot()).compareTo(m2.getEndSlot());
    }

    protected static int compareByPublishedTime(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
        int cmp = Integer.valueOf(5 * m1.getStartSlot() + m1.getStartOffset()).compareTo(5 * m2.getStartSlot() + m2.getStartOffset());
        if (cmp != 0) {
            return cmp;
        }
        return Integer.valueOf(5 * m1.getEndSlot() + m2.getEndOffset()).compareTo(5 * m2.getEndSlot() + m2.getEndOffset());
    }

    protected static int compareBySetupTime(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
        return Integer.valueOf(m1.getStartOffset()).compareTo(m2.getStartOffset());
    }

    protected static int compareByTeardownTime(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
        return Integer.valueOf(m2.getEndOffset()).compareTo(m1.getEndOffset());
    }

    protected static int compareByLocation(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
        return m1.getLocationName().compareTo(m2.getLocationName());
    }

    protected static int compareByCapacity(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
        return (m1.getLocation() == null ? Integer.valueOf(-1) : m1.getLocation().getSize()).compareTo(m2.getLocation() == null ? Integer.valueOf(-1) : m2.getLocation().getSize());
    }

    protected static int compareByMeetingContact(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
        return m1.getMeetingContacts(";", null).compareTo(m2.getMeetingContacts(";", null));
    }

    public static int compareFallback(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2) {
        int cmp = EventComparator.compareByDate(m1, m2);
        if (cmp != 0) {
            return cmp;
        }
        cmp = EventComparator.compareByPublishedTime(m1, m2);
        if (cmp != 0) {
            return cmp;
        }
        cmp = EventComparator.compareByLocation(m1, m2);
        if (cmp != 0) {
            return cmp;
        }
        return m1.compareTo(m2);
    }

    public static int compareMeetings(EventInterface.MeetingInterface m1, EventInterface.MeetingInterface m2, EventMeetingSortBy sortBy) {
        switch (sortBy) {
            case NAME: {
                return EventComparator.compareByName(m1, m2);
            }
            case TYPE: {
                return EventComparator.compareByType(m1, m2);
            }
            case APPROVAL: {
                return EventComparator.compateByApproval(m1, m2);
            }
            case DATE: {
                return EventComparator.compareByDate(m1, m2);
            }
            case SETUP_TIME: {
                return EventComparator.compareBySetupTime(m1, m2);
            }
            case TEARDOWN_TIME: {
                return EventComparator.compareByTeardownTime(m1, m2);
            }
            case PUBLISHED_TIME: {
                return EventComparator.compareByPublishedTime(m1, m2);
            }
            case ALLOCATED_TIME: {
                return EventComparator.compareByAllocatedTime(m1, m2);
            }
            case LOCATION: {
                return EventComparator.compareByLocation(m1, m2);
            }
            case CAPACITY: {
                return EventComparator.compareByCapacity(m1, m2);
            }
            case MEETING_CONTACTS: {
                return EventComparator.compareByMeetingContact(m1, m2);
            }
        }
        return 0;
    }

    protected static int compare(String s1, String s2) {
        if (s1 == null || s1.isEmpty()) {
            return s2 == null || s2.isEmpty() ? 0 : 1;
        }
        return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
    }

    protected static int compare(Number n1, Number n2) {
        return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? -1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
    }

    public static enum EventMeetingSortBy {
        NAME,
        SECTION,
        TYPE,
        DATE,
        PUBLISHED_TIME,
        ALLOCATED_TIME,
        SETUP_TIME,
        TEARDOWN_TIME,
        LOCATION,
        CAPACITY,
        SPONSOR,
        MAIN_CONTACT,
        APPROVAL,
        LIMIT,
        ENROLLMENT,
        TITLE,
        NOTE,
        LAST_CHANGE,
        MEETING_CONTACTS,
        SERVICES;

    }
}

