/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.User;
import org.unitime.timetable.spring.security.MD5PasswordEncoder;

public class UserEditForm
implements UniTimeForm {
    private static final long serialVersionUID = 8703608968811726905L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String iOp = null;
    private String iExternalId = null;
    private String iName = null;
    private String iPassword = null;
    private String iToken = null;

    public UserEditForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.iExternalId == null || this.iExternalId.trim().isEmpty()) {
            action.addFieldError("form.externalId", MSG.errorRequiredField(MSG.columnExternalId()));
        } else if (!MSG.actionUpdateUser().equals(this.getOp()) && User.findByExternalId(this.getExternalId()) != null) {
            action.addFieldError("form.externalId", MSG.errorAlreadyExists(this.iExternalId));
        }
        if (this.iName == null || this.iName.trim().isEmpty()) {
            action.addFieldError("form.name", MSG.errorRequiredField(MSG.columnUserName()));
        } else {
            try {
                User user = User.findByUserName(this.iName);
                if (user != null && !user.getExternalUniqueId().equals(this.iExternalId)) {
                    action.addFieldError("form.name", MSG.errorAlreadyExists(this.iName));
                }
            }
            catch (Exception e) {
                action.addFieldError("form.name", e.getMessage());
            }
        }
        if (MSG.actionSaveUser().equals(this.getOp()) && (this.iPassword == null || this.iPassword.trim().length() == 0)) {
            action.addFieldError("form.password", MSG.errorRequiredField(MSG.columnUserPassword()));
        }
    }

    @Override
    public void reset() {
        this.iOp = "List";
        this.iExternalId = null;
        this.iName = null;
        this.iPassword = null;
        this.iToken = null;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(String externalId) {
        this.iExternalId = externalId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getPassword() {
        return this.iPassword;
    }

    public void setPassword(String password) {
        this.iPassword = password;
    }

    public String getToken() {
        return this.iToken;
    }

    public void setToken(String token) {
        this.iToken = token;
    }

    public void load(User user) {
        if (user == null) {
            this.setOp(MSG.actionSaveUser());
        } else {
            this.setOp(MSG.actionUpdateUser());
            this.setExternalId(user.getExternalUniqueId());
            this.setName(user.getUsername());
            this.setPassword(user.getPassword());
        }
    }

    public static String encodePassword(String clearTextPassword) {
        return MD5PasswordEncoder.getEncodedPassword(clearTextPassword);
    }

    public void saveOrUpdate(Session hibSession) throws Exception {
        if (MSG.actionUpdateUser().equals(this.getOp())) {
            User u = User.findByExternalId(this.getExternalId());
            if (u.getUsername().equals(this.getName())) {
                if (this.getPassword() != null && !this.getPassword().equals(u.getPassword()) && !this.getPassword().isEmpty()) {
                    u.setPassword(UserEditForm.encodePassword(this.getPassword()));
                }
                hibSession.merge((Object)u);
            } else {
                User w = new User();
                w.setExternalUniqueId(u.getExternalUniqueId());
                w.setUsername(this.getName());
                if (this.getPassword() == null || this.getPassword().equals(u.getPassword()) || this.getPassword().isEmpty()) {
                    w.setPassword(u.getPassword());
                } else {
                    w.setPassword(UserEditForm.encodePassword(this.getPassword()));
                }
                hibSession.remove((Object)u);
                hibSession.persist((Object)w);
            }
        } else {
            User u = new User();
            u.setExternalUniqueId(this.getExternalId());
            u.setUsername(this.getName());
            u.setPassword(UserEditForm.encodePassword(this.getPassword()));
            hibSession.persist((Object)u);
        }
    }

    public void delete(Session hibSession) {
        User u = User.findByExternalId(this.getExternalId());
        if (u != null) {
            hibSession.remove((Object)u);
        }
    }
}

