/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;

public class ExamPeriodEditForm
implements UniTimeForm {
    private static final long serialVersionUID = -8152697759737310033L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    protected static GwtConstants CONS = Localization.create(GwtConstants.class);
    private Long iUniqueId;
    private String iOp;
    private String iDate;
    private Integer iStart;
    private Integer iLength;
    private Integer iStartOffset;
    private Integer iStopOffset;
    private Integer iStart2;
    private Integer iLength2;
    private Integer iStartOffset2;
    private Integer iStopOffset2;
    private Integer iStart3;
    private Integer iLength3;
    private Integer iStartOffset3;
    private Integer iStopOffset3;
    private Integer iStart4;
    private Integer iLength4;
    private Integer iStartOffset4;
    private Integer iStopOffset4;
    private Integer iStart5;
    private Integer iLength5;
    private Integer iStartOffset5;
    private Integer iStopOffset5;
    private Long iType;
    private Long iPrefLevel;
    private boolean iAutoSetup;
    private Session iSession;
    private Boolean iEditable;
    TreeSet<Integer> iDays = null;

    public ExamPeriodEditForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (!this.iAutoSetup) {
            Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
            Date date = null;
            try {
                date = df.parse(this.iDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (date == null) {
                action.addFieldError("form.date", MSG.errorExamDateIsNotValid());
            }
        }
        if (this.iType == null || this.iType < 0L) {
            action.addFieldError("form.examType", MSG.errorExamTypeIsRequired());
        }
        if (this.iStart == null || this.iStart <= 0) {
            if (!this.iAutoSetup) {
                action.addFieldError("form.start", MSG.errorStartTimeIsRequired());
            }
        } else {
            int hour = this.iStart / 100;
            int min = this.iStart % 100;
            if (hour >= 24) {
                action.addFieldError("form.start", MSG.errorInvalidStartTimeHour(hour));
            }
            if (min >= 60) {
                action.addFieldError("form.start", MSG.errorInvalidStartTimeMin(min));
            }
            if (min % Constants.SLOT_LENGTH_MIN != 0) {
                action.addFieldError("form.start", MSG.errorInvalidStartTimeMin5(min));
            }
            if (this.iLength == null || this.iLength <= 0) {
                action.addFieldError("form.length", MSG.errorLengthIsRequired());
            } else if (this.iLength % Constants.SLOT_LENGTH_MIN != 0) {
                action.addFieldError("form.length", MSG.errorInvalidLength5(this.iLength));
            }
            if (this.iStartOffset != null) {
                if (this.iStartOffset < 0) {
                    action.addFieldError("form.start offset", MSG.errorInvalidStartOffsetNegative(this.iStartOffset));
                }
                if (this.iStartOffset % Constants.SLOT_LENGTH_MIN != 0) {
                    action.addFieldError("form.start offset", MSG.errorInvalidStartOffset5(this.iStartOffset));
                }
            }
            if (this.iStopOffset != null) {
                if (this.iStopOffset < 0) {
                    action.addFieldError("form.stop offset", MSG.errorInvalidStopOffsetNegative(this.iStopOffset));
                }
                if (this.iStopOffset % Constants.SLOT_LENGTH_MIN != 0) {
                    action.addFieldError("form.stop offset", MSG.errorInvalidStopOffset5(this.iStopOffset));
                }
            }
        }
        if (this.iAutoSetup) {
            if (this.iStart2 != null && this.iStart2 > 0) {
                int hour = this.iStart2 / 100;
                int min = this.iStart2 % 100;
                if (hour >= 24) {
                    action.addFieldError("form.start2", MSG.errorInvalidStartTimeHour(hour));
                }
                if (min >= 60) {
                    action.addFieldError("form.start2", MSG.errorInvalidStartTimeMin(min));
                }
                if (min % Constants.SLOT_LENGTH_MIN != 0) {
                    action.addFieldError("form.start2", MSG.errorInvalidStartTimeMin5(min));
                }
                if (this.iLength2 == null || this.iLength2 <= 0) {
                    action.addFieldError("form.length2", MSG.errorLengthIsRequired());
                } else if (this.iLength2 % Constants.SLOT_LENGTH_MIN != 0) {
                    action.addFieldError("form.length2", MSG.errorInvalidLength5(this.iLength2));
                }
                if (this.iStartOffset2 != null) {
                    if (this.iStartOffset2 < 0) {
                        action.addFieldError("form.startOffset2", MSG.errorInvalidStartOffsetNegative(this.iStartOffset2));
                    }
                    if (this.iStartOffset2 % Constants.SLOT_LENGTH_MIN != 0) {
                        action.addFieldError("form.startOffset2", MSG.errorInvalidStartOffset5(this.iStartOffset2));
                    }
                }
                if (this.iStopOffset2 != null) {
                    if (this.iStopOffset2 < 0) {
                        action.addFieldError("form.stopOffset2", MSG.errorInvalidStopOffsetNegative(this.iStopOffset2));
                    }
                    if (this.iStopOffset2 % Constants.SLOT_LENGTH_MIN != 0) {
                        action.addFieldError("form.stopOffset2", MSG.errorInvalidStopOffset5(this.iStopOffset2));
                    }
                }
            }
            if (this.iStart3 != null && this.iStart3 > 0) {
                int hour = this.iStart3 / 100;
                int min = this.iStart3 % 100;
                if (hour >= 24) {
                    action.addFieldError("form.start3", MSG.errorInvalidStartTimeHour(hour));
                }
                if (min >= 60) {
                    action.addFieldError("form.start3", MSG.errorInvalidStartTimeMin(min));
                }
                if (min % Constants.SLOT_LENGTH_MIN != 0) {
                    action.addFieldError("form.start3", MSG.errorInvalidStartTimeMin5(min));
                }
                if (this.iLength3 == null || this.iLength3 <= 0) {
                    action.addFieldError("form.length3", MSG.errorLengthIsRequired());
                } else if (this.iLength3 % Constants.SLOT_LENGTH_MIN != 0) {
                    action.addFieldError("form.length3", MSG.errorInvalidLength5(this.iLength3));
                }
                if (this.iStartOffset3 != null) {
                    if (this.iStartOffset3 < 0) {
                        action.addFieldError("form.startOffset3", MSG.errorInvalidStartOffsetNegative(this.iStartOffset3));
                    }
                    if (this.iStartOffset3 % Constants.SLOT_LENGTH_MIN != 0) {
                        action.addFieldError("form.startOffset3", MSG.errorInvalidStartOffset5(this.iStartOffset3));
                    }
                }
                if (this.iStopOffset3 != null) {
                    if (this.iStopOffset3 < 0) {
                        action.addFieldError("form.stopOffset3", MSG.errorInvalidStopOffsetNegative(this.iStopOffset3));
                    }
                    if (this.iStopOffset3 % Constants.SLOT_LENGTH_MIN != 0) {
                        action.addFieldError("form.stopOffset3", MSG.errorInvalidStopOffset5(this.iStopOffset3));
                    }
                }
            }
            if (this.iStart4 != null && this.iStart4 > 0) {
                int hour = this.iStart4 / 100;
                int min = this.iStart4 % 100;
                if (hour >= 24) {
                    action.addFieldError("form.start4", MSG.errorInvalidStartTimeHour(hour));
                }
                if (min >= 60) {
                    action.addFieldError("form.start4", MSG.errorInvalidStartTimeMin(min));
                }
                if (min % Constants.SLOT_LENGTH_MIN != 0) {
                    action.addFieldError("form.start4", MSG.errorInvalidStartTimeMin5(min));
                }
                if (this.iLength4 == null || this.iLength4 <= 0) {
                    action.addFieldError("form.length4", MSG.errorLengthIsRequired());
                } else if (this.iLength4 % Constants.SLOT_LENGTH_MIN != 0) {
                    action.addFieldError("form.length4", MSG.errorInvalidLength5(this.iLength4));
                }
                if (this.iStartOffset4 != null) {
                    if (this.iStartOffset4 < 0) {
                        action.addFieldError("form.startOffset4", MSG.errorInvalidStartOffsetNegative(this.iStartOffset4));
                    }
                    if (this.iStartOffset4 % Constants.SLOT_LENGTH_MIN != 0) {
                        action.addFieldError("form.startOffset4", MSG.errorInvalidStartOffset5(this.iStartOffset4));
                    }
                }
                if (this.iStopOffset4 != null) {
                    if (this.iStopOffset4 < 0) {
                        action.addFieldError("form.stopOffset4", MSG.errorInvalidStopOffsetNegative(this.iStopOffset4));
                    }
                    if (this.iStopOffset4 % Constants.SLOT_LENGTH_MIN != 0) {
                        action.addFieldError("form.stopOffset4", MSG.errorInvalidStopOffset5(this.iStopOffset4));
                    }
                }
            }
            if (this.iStart5 != null && this.iStart5 > 0) {
                int hour = this.iStart5 / 100;
                int min = this.iStart5 % 100;
                if (hour >= 24) {
                    action.addFieldError("form.start5", MSG.errorInvalidStartTimeHour(hour));
                }
                if (min >= 60) {
                    action.addFieldError("form.start5", MSG.errorInvalidStartTimeMin(min));
                }
                if (min % Constants.SLOT_LENGTH_MIN != 0) {
                    action.addFieldError("form.start5", MSG.errorInvalidStartTimeMin5(min));
                }
                if (this.iLength5 == null || this.iLength5 <= 0) {
                    action.addFieldError("form.length5", MSG.errorLengthIsRequired());
                } else if (this.iLength5 % Constants.SLOT_LENGTH_MIN != 0) {
                    action.addFieldError("form.length5", MSG.errorInvalidLength5(this.iLength5));
                }
                if (this.iStartOffset5 != null) {
                    if (this.iStartOffset5 < 0) {
                        action.addFieldError("form.startOffset5", MSG.errorInvalidStartOffsetNegative(this.iStartOffset5));
                    }
                    if (this.iStartOffset5 % Constants.SLOT_LENGTH_MIN != 0) {
                        action.addFieldError("form.startOffset5", MSG.errorInvalidStartOffset5(this.iStartOffset5));
                    }
                }
                if (this.iStopOffset5 != null) {
                    if (this.iStopOffset5 < 0) {
                        action.addFieldError("form.stopOffset5", MSG.errorInvalidStopOffsetNegative(this.iStopOffset5));
                    }
                    if (this.iStopOffset5 % Constants.SLOT_LENGTH_MIN != 0) {
                        action.addFieldError("form.stopOffset5", MSG.errorInvalidStopOffset5(this.iStopOffset5));
                    }
                }
            }
        }
        try {
            if (!action.hasFieldErrors()) {
                Session session = (Session)SessionDAO.getInstance().get(action.getSessionContext().getUser().getCurrentAcademicSessionId());
                Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
                Date startDate = df.parse(this.iDate);
                long diff = startDate.getTime() - session.getExamBeginDate().getTime();
                int dateOffset = (int)Math.round((double)diff / 8.64E7);
                int hour = this.iStart / 100;
                int min = this.iStart % 100;
                int slot = (hour * 60 + min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                ExamPeriod period = ExamPeriod.findByDateStart(session.getUniqueId(), dateOffset, slot, this.iType);
                if (period != null && !period.getUniqueId().equals(this.getUniqueId())) {
                    action.addFieldError("form.date", MSG.errorDuplicateExaminationPeriod());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void reset() {
        this.iOp = null;
        this.iUniqueId = -1L;
        this.iDate = null;
        this.iStart = null;
        this.iLength = null;
        this.iStartOffset = null;
        this.iStopOffset = null;
        this.iStart2 = null;
        this.iLength2 = null;
        this.iStartOffset2 = null;
        this.iStopOffset2 = null;
        this.iStart3 = null;
        this.iLength3 = null;
        this.iStartOffset3 = null;
        this.iStopOffset3 = null;
        this.iStart4 = null;
        this.iLength4 = null;
        this.iStartOffset4 = null;
        this.iStopOffset4 = null;
        this.iStart5 = null;
        this.iLength5 = null;
        this.iStartOffset5 = null;
        this.iStopOffset5 = null;
        this.iPrefLevel = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral).getUniqueId();
        this.iType = null;
        this.iAutoSetup = false;
        this.iEditable = false;
    }

    public void load(ExamPeriod ep, SessionContext context) throws Exception {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
        if (ep == null) {
            this.reset();
            Session session = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
            this.iDate = df.format(session.getExamBeginDate());
            this.iLength = 120;
            this.iType = (Long)context.getAttribute(SessionAttribute.ExamType);
            TreeSet<ExamPeriod> periods = ExamPeriod.findAll(context.getUser().getCurrentAcademicSessionId(), this.iType);
            if (!periods.isEmpty()) {
                this.iType = periods.last().getExamType().getUniqueId();
                HashMap<Integer, Integer> times = new HashMap<Integer, Integer>();
                HashSet<Date> dates = new HashSet<Date>();
                for (ExamPeriod p : periods) {
                    if (!p.getExamType().getUniqueId().equals(this.iType)) continue;
                    times.put(p.getStartSlot(), p.getLength());
                    dates.add(p.getStartDate());
                }
                this.iLength = null;
                Iterator<ExamPeriod> i = new TreeSet(times.keySet()).iterator();
                while (i.hasNext()) {
                    Integer start = (Integer)((Object)i.next());
                    if (this.iLength == null) {
                        if (dates.size() > 1) {
                            int time = Constants.SLOT_LENGTH_MIN * start + Constants.FIRST_SLOT_TIME_MIN;
                            this.iStart = 100 * (time / 60) + time % 60;
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(periods.last().getStartDate());
                            cal.add(6, 1);
                            this.iDate = df.format(cal.getTime());
                        } else {
                            this.iDate = df.format(periods.last().getStartDate());
                        }
                        this.iLength = Constants.SLOT_LENGTH_MIN * (Integer)times.get(start);
                    }
                    if (!start.equals(periods.last().getStartSlot()) || !i.hasNext()) continue;
                    int slot = (Integer)((Object)i.next());
                    int time = Constants.SLOT_LENGTH_MIN * slot + Constants.FIRST_SLOT_TIME_MIN;
                    this.iStart = 100 * (time / 60) + time % 60;
                    this.iLength = Constants.SLOT_LENGTH_MIN * (Integer)times.get(slot);
                    this.iDate = df.format(periods.last().getStartDate());
                    break;
                }
                this.iStartOffset = this.getDefaultStartOffset(this.iType);
                this.iStopOffset = this.getDefaultStopOffset(this.iType);
            }
            this.iPrefLevel = PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral).getUniqueId();
            this.iOp = MSG.actionSaveExaminationPeriod();
            this.iEditable = true;
        } else {
            this.iUniqueId = ep.getUniqueId();
            this.iDate = df.format(ep.getStartDate());
            this.iStart = ep.getStartHour() * 100 + ep.getStartMinute();
            this.iLength = ep.getLength() * Constants.SLOT_LENGTH_MIN;
            this.iStartOffset = ep.getEventStartOffset() * Constants.SLOT_LENGTH_MIN;
            this.iStopOffset = ep.getEventStopOffset() * Constants.SLOT_LENGTH_MIN;
            this.iPrefLevel = ep.getPrefLevel().getUniqueId();
            this.iType = ep.getExamType().getUniqueId();
            context.setAttribute(SessionAttribute.ExamType, (Object)this.iType);
            this.iOp = MSG.actionUpdateExaminationPeriod();
            this.iEditable = !ep.isUsed();
        }
    }

    public void update(ExamPeriod ep, SessionContext context, org.hibernate.Session hibSession) throws Exception {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
        ep.setStartDate(df.parse(this.iDate));
        int hour = this.iStart / 100;
        int min = this.iStart % 100;
        int slot = (hour * 60 + min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
        ep.setStartSlot(slot);
        ep.setLength(this.iLength / Constants.SLOT_LENGTH_MIN);
        ep.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(this.iPrefLevel));
        ep.setExamType((ExamType)ExamTypeDAO.getInstance().get(this.iType));
        ep.setEventStartOffset(this.iStartOffset == null ? Integer.valueOf(0) : Integer.valueOf(this.iStartOffset / Constants.SLOT_LENGTH_MIN));
        ep.setEventStopOffset(this.iStopOffset == null ? Integer.valueOf(0) : Integer.valueOf(this.iStopOffset / Constants.SLOT_LENGTH_MIN));
        hibSession.merge((Object)ep);
    }

    public ExamPeriod create(SessionContext context, org.hibernate.Session hibSession) throws Exception {
        ExamPeriod ep = new ExamPeriod();
        Session session = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
        ep.setSession(session);
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
        ep.setStartDate(df.parse(this.iDate));
        int hour = this.iStart / 100;
        int min = this.iStart % 100;
        int slot = (hour * 60 + min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
        ep.setStartSlot(slot);
        ep.setLength(this.iLength / Constants.SLOT_LENGTH_MIN);
        ep.setPrefLevel((PreferenceLevel)PreferenceLevelDAO.getInstance().get(this.iPrefLevel));
        ep.setExamType((ExamType)ExamTypeDAO.getInstance().get(this.iType));
        ep.setEventStartOffset(this.iStartOffset == null ? Integer.valueOf(0) : Integer.valueOf(this.iStartOffset / Constants.SLOT_LENGTH_MIN));
        ep.setEventStopOffset(this.iStopOffset == null ? Integer.valueOf(0) : Integer.valueOf(this.iStopOffset / Constants.SLOT_LENGTH_MIN));
        hibSession.persist((Object)ep);
        this.setUniqueId(ep.getUniqueId());
        return ep;
    }

    public ExamPeriod saveOrUpdate(HttpServletRequest request, SessionContext context, org.hibernate.Session hibSession) throws Exception {
        if (this.getAutoSetup()) {
            int slot;
            this.setDays(request);
            TreeSet<ExamPeriod> periods = ExamPeriod.findAll(context.getUser().getCurrentAcademicSessionId(), this.iType);
            TreeSet<Integer> slots = new TreeSet<Integer>();
            TreeSet<Integer> oldDays = new TreeSet<Integer>();
            Iterator<ExamPeriod> i = periods.iterator();
            while (i.hasNext()) {
                ExamPeriod period = i.next();
                slots.add(period.getStartSlot());
                if (!this.iDays.contains(period.getDateOffset())) {
                    for (Exam exam : hibSession.createQuery("select x from Exam x where x.assignedPeriod.uniqueId=:periodId", Exam.class).setParameter("periodId", (Object)period.getUniqueId()).list()) {
                        exam.unassign(context.getUser().getExternalUserId(), hibSession);
                    }
                    hibSession.remove((Object)period);
                    i.remove();
                    continue;
                }
                oldDays.add(period.getDateOffset());
            }
            Hashtable<Integer, Integer> length = new Hashtable<Integer, Integer>();
            Hashtable<Integer, Integer> translate = new Hashtable<Integer, Integer>();
            Hashtable<Integer, Integer> eventStartOffsets = new Hashtable<Integer, Integer>();
            Hashtable<Integer, Integer> eventStopOffsets = new Hashtable<Integer, Integer>();
            TreeSet<Integer> newStarts = new TreeSet<Integer>();
            Iterator it = slots.iterator();
            if (this.iStart != null && this.iStart > 0) {
                slot = (this.iStart / 100 * 60 + this.iStart % 100 - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                length.put(slot, this.iLength);
                eventStartOffsets.put(slot, this.iStartOffset);
                eventStopOffsets.put(slot, this.iStopOffset);
                if (it.hasNext()) {
                    translate.put((Integer)it.next(), slot);
                } else {
                    newStarts.add(slot);
                }
            } else if (it.hasNext()) {
                it.next();
            }
            if (this.iStart2 != null && this.iStart2 > 0) {
                slot = (this.iStart2 / 100 * 60 + this.iStart2 % 100 - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                length.put(slot, this.iLength2);
                eventStartOffsets.put(slot, this.iStartOffset2);
                eventStopOffsets.put(slot, this.iStopOffset2);
                if (it.hasNext()) {
                    translate.put((Integer)it.next(), slot);
                } else {
                    newStarts.add(slot);
                }
            } else if (it.hasNext()) {
                it.next();
            }
            if (this.iStart3 != null && this.iStart3 > 0) {
                slot = (this.iStart3 / 100 * 60 + this.iStart3 % 100 - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                length.put(slot, this.iLength3);
                eventStartOffsets.put(slot, this.iStartOffset3);
                eventStopOffsets.put(slot, this.iStopOffset3);
                if (it.hasNext()) {
                    translate.put((Integer)it.next(), slot);
                } else {
                    newStarts.add(slot);
                }
            } else if (it.hasNext()) {
                it.next();
            }
            if (this.iStart4 != null && this.iStart4 > 0) {
                slot = (this.iStart4 / 100 * 60 + this.iStart4 % 100 - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                length.put(slot, this.iLength4);
                eventStartOffsets.put(slot, this.iStartOffset4);
                eventStopOffsets.put(slot, this.iStopOffset4);
                if (it.hasNext()) {
                    translate.put((Integer)it.next(), slot);
                } else {
                    newStarts.add(slot);
                }
            } else if (it.hasNext()) {
                it.next();
            }
            if (this.iStart5 != null && this.iStart5 > 0) {
                slot = (this.iStart5 / 100 * 60 + this.iStart5 % 100 - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
                length.put(slot, this.iLength5);
                eventStartOffsets.put(slot, this.iStartOffset5);
                eventStopOffsets.put(slot, this.iStopOffset5);
                if (it.hasNext()) {
                    translate.put((Integer)it.next(), slot);
                } else {
                    newStarts.add(slot);
                }
            } else if (it.hasNext()) {
                it.next();
            }
            Iterator<Comparable<ExamPeriod>> i2 = periods.iterator();
            while (i2.hasNext()) {
                ExamPeriod period = i2.next();
                Integer start = (Integer)translate.get(period.getStartSlot());
                if (start == null) {
                    for (Exam exam : hibSession.createQuery("select x from Exam x where x.assignedPeriod.uniqueId=:periodId", Exam.class).setParameter("periodId", (Object)period.getUniqueId()).list()) {
                        exam.unassign(context.getUser().getExternalUserId(), hibSession);
                    }
                    hibSession.remove((Object)period);
                    i2.remove();
                    continue;
                }
                period.setStartSlot(start);
                period.setLength((Integer)length.get(start) / Constants.SLOT_LENGTH_MIN);
                period.setEventStartOffset(eventStartOffsets.get(start) == null ? Integer.valueOf(null) : Integer.valueOf((Integer)eventStartOffsets.get(start) / Constants.SLOT_LENGTH_MIN));
                period.setEventStopOffset(eventStopOffsets.get(start) == null ? Integer.valueOf(null) : Integer.valueOf((Integer)eventStopOffsets.get(start) / Constants.SLOT_LENGTH_MIN));
                hibSession.merge((Object)period);
            }
            for (Integer day : this.iDays) {
                Iterator iterator = new TreeSet(length.keySet()).iterator();
                while (iterator.hasNext()) {
                    int start = (Integer)iterator.next();
                    if (oldDays.contains(day) && !newStarts.contains(start)) continue;
                    ExamPeriod ep = new ExamPeriod();
                    ep.setSession(this.iSession);
                    ep.setDateOffset(day);
                    ep.setStartSlot(start);
                    ep.setLength((Integer)length.get(start) / Constants.SLOT_LENGTH_MIN);
                    ep.setEventStartOffset(eventStartOffsets.get(start) == null ? Integer.valueOf(null) : Integer.valueOf((Integer)eventStartOffsets.get(start) / Constants.SLOT_LENGTH_MIN));
                    ep.setEventStopOffset(eventStopOffsets.get(start) == null ? Integer.valueOf(null) : Integer.valueOf((Integer)eventStopOffsets.get(start) / Constants.SLOT_LENGTH_MIN));
                    ep.setExamType((ExamType)ExamTypeDAO.getInstance().get(this.iType));
                    ep.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    hibSession.persist((Object)ep);
                }
            }
            return null;
        }
        ExamPeriod ep = null;
        if (this.getUniqueId() >= 0L) {
            ep = (ExamPeriod)ExamPeriodDAO.getInstance().get(this.getUniqueId());
        }
        if (ep == null) {
            ep = this.create(context, hibSession);
        } else {
            this.update(ep, context, hibSession);
        }
        return ep;
    }

    public void delete(SessionContext context, org.hibernate.Session hibSession) throws Exception {
        if (this.getUniqueId() < 0L) {
            return;
        }
        ExamPeriod ep = (ExamPeriod)ExamPeriodDAO.getInstance().get(this.getUniqueId(), hibSession);
        for (Exam exam : hibSession.createQuery("select x from Exam x where x.assignedPeriod.uniqueId=:periodId", Exam.class).setParameter("periodId", (Object)ep.getUniqueId()).list()) {
            exam.unassign(context.getUser().getExternalUserId(), hibSession);
        }
        hibSession.remove((Object)ep);
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getDate() {
        return this.iDate;
    }

    public void setDate(String date) {
        this.iDate = date;
    }

    public Integer getStart() {
        return this.iStart;
    }

    public void setStart(Integer start) {
        this.iStart = start;
    }

    public Integer getLength() {
        return this.iLength;
    }

    public void setLength(Integer length) {
        this.iLength = length;
    }

    public Integer getStart2() {
        return this.iStart2;
    }

    public void setStart2(Integer start2) {
        this.iStart2 = start2;
    }

    public Integer getLength2() {
        return this.iLength2;
    }

    public void setLength2(Integer length2) {
        this.iLength2 = length2;
    }

    public Integer getStart3() {
        return this.iStart3;
    }

    public void setStart3(Integer start3) {
        this.iStart3 = start3;
    }

    public Integer getLength3() {
        return this.iLength3;
    }

    public void setLength3(Integer length3) {
        this.iLength3 = length3;
    }

    public Integer getStart4() {
        return this.iStart4;
    }

    public void setStart4(Integer start4) {
        this.iStart4 = start4;
    }

    public Integer getLength4() {
        return this.iLength4;
    }

    public void setLength4(Integer length4) {
        this.iLength4 = length4;
    }

    public Integer getStart5() {
        return this.iStart5;
    }

    public void setStart5(Integer start5) {
        this.iStart5 = start5;
    }

    public Integer getLength5() {
        return this.iLength5;
    }

    public void setLength5(Integer length5) {
        this.iLength5 = length5;
    }

    public Long getPrefLevel() {
        return this.iPrefLevel;
    }

    public void setPrefLevel(Long prefLevel) {
        this.iPrefLevel = prefLevel;
    }

    public Integer getStartOffset() {
        return this.iStartOffset;
    }

    public void setStartOffset(Integer startOffset) {
        this.iStartOffset = startOffset;
    }

    public Integer getStopOffset() {
        return this.iStopOffset;
    }

    public void setStopOffset(Integer stopOffset) {
        this.iStopOffset = stopOffset;
    }

    public Integer getStartOffset2() {
        return this.iStartOffset2;
    }

    public void setStartOffset2(Integer startOffset2) {
        this.iStartOffset2 = startOffset2;
    }

    public Integer getStopOffset2() {
        return this.iStopOffset2;
    }

    public void setStopOffset2(Integer stopOffset2) {
        this.iStopOffset2 = stopOffset2;
    }

    public Integer getStartOffset3() {
        return this.iStartOffset3;
    }

    public void setStartOffset3(Integer startOffset3) {
        this.iStartOffset3 = startOffset3;
    }

    public Integer getStopOffset3() {
        return this.iStopOffset3;
    }

    public void setStopOffset3(Integer stopOffset3) {
        this.iStopOffset3 = stopOffset3;
    }

    public Integer getStartOffset4() {
        return this.iStartOffset4;
    }

    public void setStartOffset4(Integer startOffset4) {
        this.iStartOffset4 = startOffset4;
    }

    public Integer getStopOffset4() {
        return this.iStopOffset4;
    }

    public void setStopOffset4(Integer stopOffset4) {
        this.iStopOffset4 = stopOffset4;
    }

    public Integer getStartOffset5() {
        return this.iStartOffset5;
    }

    public void setStartOffset5(Integer startOffset5) {
        this.iStartOffset5 = startOffset5;
    }

    public Integer getStopOffset5() {
        return this.iStopOffset5;
    }

    public void setStopOffset5(Integer stopOffset5) {
        this.iStopOffset5 = stopOffset5;
    }

    public Vector getPrefLevels() {
        Vector<PreferenceLevel> ret = new Vector<PreferenceLevel>();
        for (PreferenceLevel level : PreferenceLevel.getPreferenceLevelList()) {
            if (PreferenceLevel.sRequired.equals(level.getPrefProlog())) continue;
            ret.addElement(level);
        }
        return ret;
    }

    public Long getExamType() {
        return this.iType;
    }

    public void setExamType(Long type) {
        this.iType = type;
    }

    public boolean getAutoSetup() {
        return this.iAutoSetup;
    }

    public void setAutoSetup(boolean autoSetup) {
        this.iAutoSetup = autoSetup;
    }

    public boolean getEditable() {
        return this.iEditable;
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    public String getBorder(int day, int month) {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.iSession.getSessionBeginDateTime());
        if (day == cal.get(5) && month == cal.get(2)) {
            return "'blue 2px solid'";
        }
        cal.setTime(this.iSession.getSessionEndDateTime());
        if (day == cal.get(5) && month == cal.get(2)) {
            return "'blue 2px solid'";
        }
        cal.setTime(this.iSession.getExamBeginDate());
        if (day == cal.get(5) && month == cal.get(2)) {
            return "'green 2px solid'";
        }
        int holiday = this.iSession.getHoliday(day, month);
        if (holiday != 0) {
            return "'" + Session.sHolidayTypeColors[holiday] + " 2px solid'";
        }
        return "null";
    }

    public boolean getCanAutoSetup(String examType) {
        return this.getCanAutoSetup(Long.valueOf(examType));
    }

    public boolean getCanAutoSetup(Long examType) {
        Iterator it;
        this.iDays = new TreeSet();
        TreeSet<Integer> times = new TreeSet<Integer>();
        Hashtable<Integer, Integer> lengths = new Hashtable<Integer, Integer>();
        Hashtable<Integer, Integer> eventStartOffsets = new Hashtable<Integer, Integer>();
        Hashtable<Integer, Integer> eventStopOffsets = new Hashtable<Integer, Integer>();
        TreeSet<ExamPeriod> periods = ExamPeriod.findAll(this.iSession.getUniqueId(), examType);
        this.iType = examType;
        for (ExamPeriod period : periods) {
            if (period.isUsed()) {
                return false;
            }
            this.iDays.add(period.getDateOffset());
            times.add(period.getStartSlot());
            Integer length = (Integer)lengths.get(period.getStartSlot());
            if (length == null) {
                lengths.put(period.getStartSlot(), period.getLength());
            } else if (!length.equals(period.getLength())) {
                return false;
            }
            Integer eventStartOffset = (Integer)eventStartOffsets.get(period.getStartSlot());
            if (eventStartOffset == null) {
                eventStartOffsets.put(period.getStartSlot(), period.getEventStartOffset());
            } else if (!eventStartOffset.equals(period.getEventStartOffset())) {
                return false;
            }
            Integer eventStopOffset = (Integer)eventStopOffsets.get(period.getStartSlot());
            if (eventStopOffset == null) {
                eventStopOffsets.put(period.getStartSlot(), period.getEventStopOffset());
                continue;
            }
            if (eventStopOffset.equals(period.getEventStopOffset())) continue;
            return false;
        }
        if (periods.size() != this.iDays.size() * times.size() || times.size() > 5) {
            return false;
        }
        if (times.isEmpty()) {
            this.iStart = 1830;
            this.iLength = 60;
            this.iStartOffset = this.getDefaultStartOffset(examType);
            this.iStopOffset = this.getDefaultStopOffset(examType);
            this.iStart2 = 2000;
            this.iLength2 = 120;
            this.iStartOffset2 = this.getDefaultStartOffset(examType);
            this.iStopOffset2 = this.getDefaultStopOffset(examType);
            this.iStart3 = null;
            this.iLength3 = null;
            this.iStartOffset3 = this.getDefaultStartOffset(examType);
            this.iStopOffset3 = this.getDefaultStopOffset(examType);
            this.iStart4 = null;
            this.iLength4 = null;
            this.iStartOffset4 = this.getDefaultStartOffset(examType);
            this.iStopOffset4 = this.getDefaultStopOffset(examType);
            this.iStart5 = null;
            this.iLength5 = null;
            this.iStartOffset5 = this.getDefaultStartOffset(examType);
            this.iStopOffset5 = this.getDefaultStopOffset(examType);
        }
        if ((it = times.iterator()).hasNext()) {
            int slot = (Integer)it.next();
            int min = Constants.SLOT_LENGTH_MIN * (Integer)times.first() + Constants.FIRST_SLOT_TIME_MIN;
            this.iStart = 100 * (min / 60) + min % 60;
            this.iLength = Constants.SLOT_LENGTH_MIN * (Integer)lengths.get(slot);
            this.iStartOffset = Constants.SLOT_LENGTH_MIN * (Integer)eventStartOffsets.get(slot);
            this.iStopOffset = Constants.SLOT_LENGTH_MIN * (Integer)eventStopOffsets.get(slot);
        } else {
            this.iStart = null;
            this.iLength = null;
        }
        if (it.hasNext()) {
            int slot = (Integer)it.next();
            int min = Constants.SLOT_LENGTH_MIN * slot + Constants.FIRST_SLOT_TIME_MIN;
            this.iStart2 = 100 * (min / 60) + min % 60;
            this.iLength2 = Constants.SLOT_LENGTH_MIN * (Integer)lengths.get(slot);
            this.iStartOffset2 = Constants.SLOT_LENGTH_MIN * (Integer)eventStartOffsets.get(slot);
            this.iStopOffset2 = Constants.SLOT_LENGTH_MIN * (Integer)eventStopOffsets.get(slot);
        } else {
            this.iStart2 = null;
            this.iLength2 = null;
        }
        if (it.hasNext()) {
            int slot = (Integer)it.next();
            int min = Constants.SLOT_LENGTH_MIN * slot + Constants.FIRST_SLOT_TIME_MIN;
            this.iStart3 = 100 * (min / 60) + min % 60;
            this.iLength3 = Constants.SLOT_LENGTH_MIN * (Integer)lengths.get(slot);
            this.iStartOffset3 = Constants.SLOT_LENGTH_MIN * (Integer)eventStartOffsets.get(slot);
            this.iStopOffset3 = Constants.SLOT_LENGTH_MIN * (Integer)eventStopOffsets.get(slot);
        } else {
            this.iStart3 = null;
            this.iLength3 = null;
        }
        if (it.hasNext()) {
            int slot = (Integer)it.next();
            int min = Constants.SLOT_LENGTH_MIN * slot + Constants.FIRST_SLOT_TIME_MIN;
            this.iStart4 = 100 * (min / 60) + min % 60;
            this.iLength4 = Constants.SLOT_LENGTH_MIN * (Integer)lengths.get(slot);
            this.iStartOffset4 = Constants.SLOT_LENGTH_MIN * (Integer)eventStartOffsets.get(slot);
            this.iStopOffset4 = Constants.SLOT_LENGTH_MIN * (Integer)eventStopOffsets.get(slot);
        } else {
            this.iStart4 = null;
            this.iLength4 = null;
        }
        if (it.hasNext()) {
            int slot = (Integer)it.next();
            int min = Constants.SLOT_LENGTH_MIN * slot + Constants.FIRST_SLOT_TIME_MIN;
            this.iStart5 = 100 * (min / 60) + min % 60;
            this.iLength5 = Constants.SLOT_LENGTH_MIN * (Integer)lengths.get(slot);
            this.iStartOffset5 = Constants.SLOT_LENGTH_MIN * (Integer)eventStartOffsets.get(slot);
            this.iStopOffset5 = Constants.SLOT_LENGTH_MIN * (Integer)eventStopOffsets.get(slot);
        } else {
            this.iStart5 = null;
            this.iLength5 = null;
        }
        return true;
    }

    public int getExamOffset() {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.iSession.getExamBeginDate());
        return DateUtils.getDayOfYear(cal.get(5), DateUtils.getStartMonth(this.iSession.getExamBeginDate(), this.iSession.getSessionStartYear(), 0), this.iSession.getSessionStartYear()) + 1;
    }

    public boolean hasExam(int day, int month) {
        return this.iDays.contains(1 + this.iSession.getDayOfYear(day, month) - this.getExamOffset());
    }

    public String getPatternHtml() {
        try {
            int i;
            int startMonth = this.iSession.getStartMonth();
            int endMonth = this.iSession.getEndMonth();
            StringBuffer border = new StringBuffer("[");
            StringBuffer pattern = new StringBuffer("[");
            for (int m = startMonth; m <= endMonth; ++m) {
                if (m != startMonth) {
                    border.append(",");
                    pattern.append(",");
                }
                border.append("[");
                pattern.append("[");
                int daysOfMonth = DateUtils.getNrDaysOfMonth(m, this.iSession.getSessionStartYear());
                for (int d = 1; d <= daysOfMonth; ++d) {
                    if (d > 1) {
                        border.append(",");
                        pattern.append(",");
                    }
                    border.append(this.getBorder(d, m));
                    pattern.append(this.hasExam(d, m) ? "'1'" : "'0'");
                }
                border.append("]");
                pattern.append("]");
            }
            border.append("]");
            pattern.append("]");
            StringBuffer sb = new StringBuffer();
            sb.append("<script language='JavaScript' type='text/javascript' src='scripts/datepatt.js'></script>\n");
            sb.append("<script language='JavaScript'>\n");
            sb.append("var CAL_WEEKDAYS = [");
            for (i = 0; i < 7; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("\"" + CONS.days()[(i + 6) % 7] + "\"");
            }
            sb.append("];\n");
            sb.append("var CAL_MONTHS = [");
            for (i = 0; i < 12; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("\"" + Month.of(1 + i).getDisplayName(TextStyle.FULL_STANDALONE, Localization.getJavaLocale()) + "\"");
            }
            sb.append("];\n");
            sb.append("calGenerate(" + this.iSession.getSessionStartYear() + ",\n\t" + this.iSession.getStartMonth() + ",\n\t" + this.iSession.getEndMonth() + ",\n\t" + String.valueOf(pattern) + ",\n\t['1','0'],\n\t['" + MSG.legentExaminationsOffered() + "','" + MSG.legentExaminationsNotOffered() + "'],\n\t['rgb(240,240,50)','rgb(240,240,240)'],\n\t'1',\n\t" + String.valueOf(border) + ",true,true);\n");
            sb.append("</script>\n");
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setDays(HttpServletRequest request) {
        int startMonth = this.iSession.getStartMonth();
        int endMonth = this.iSession.getEndMonth();
        this.iDays = new TreeSet();
        for (int m = startMonth; m <= endMonth; ++m) {
            int yr = DateUtils.calculateActualYear(m, this.iSession.getSessionStartYear());
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, this.iSession.getSessionStartYear());
            for (int d = 1; d <= daysOfMonth; ++d) {
                String exam = request.getParameter("cal_val_" + yr + "_" + (12 + m) % 12 + "_" + d);
                if (!"1".equals(exam)) continue;
                this.iDays.add(1 + this.iSession.getDayOfYear(d, m) - this.getExamOffset());
            }
        }
    }

    public Integer getDefaultStartOffset(Long type) {
        return Constants.getDefaultExamStartOffset((ExamType)ExamTypeDAO.getInstance().get(type));
    }

    public Integer getDefaultStopOffset(Long type) {
        return Constants.getDefaultExamStopOffset((ExamType)ExamTypeDAO.getInstance().get(type));
    }

    public void setSession(Session session) {
        this.iSession = session;
    }
}

