/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.util.ComboBoxLookup;

public class ExamCbsForm
implements UniTimeForm {
    private static final long serialVersionUID = -8811101882445836746L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    public static double sDefaultLimit = 25.0;
    public static Type sDefaultType = Type.VariableOriented;
    private String iOp = null;
    private String iType = null;
    private double iLimit = sDefaultLimit;

    public ExamCbsForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
    }

    @Override
    public void reset() {
        this.iOp = null;
        this.iLimit = sDefaultLimit;
        this.iType = sDefaultType.name();
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getType() {
        return this.iType;
    }

    public void setType(String type) {
        this.iType = type;
    }

    public int getTypeInt() {
        for (Type t : Type.values()) {
            if (!t.name().equals(this.iType)) continue;
            return t.ordinal();
        }
        return 0;
    }

    public void setTypeInt(int type) {
        this.iType = Type.values()[type].name();
    }

    public double getLimit() {
        return this.iLimit;
    }

    public void setLimit(double limit) {
        this.iLimit = limit;
    }

    public List<ComboBoxLookup> getTypes() {
        ArrayList<ComboBoxLookup> ret = new ArrayList<ComboBoxLookup>();
        for (Type t : Type.values()) {
            ret.add(new ComboBoxLookup(ExamCbsForm.getTypeLabel(t), t.name()));
        }
        return ret;
    }

    public static String getTypeLabel(Type t) {
        switch (t) {
            case VariableOriented: {
                return MSG.cbsVariableOriented();
            }
            case ConstraintOriented: {
                return MSG.cbsConstraintOriented();
            }
        }
        return t.name();
    }

    public static enum Type {
        VariableOriented,
        ConstraintOriented;

    }
}

