/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Vector;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.DepartmentStatusTypeDAO;
import org.unitime.timetable.util.IdValue;

public class DeptStatusTypeEditForm
implements UniTimeForm {
    private static final long serialVersionUID = -684686223274367430L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String iOp;
    private Long iUniqueId;
    private String iReference;
    private String iLabel;
    private int iApply = 0;
    private int iOrder = -1;
    private boolean iCanManagerView = false;
    private boolean iCanManagerEdit = false;
    private boolean iCanManagerLimitedEdit = false;
    private boolean iCanOwnerView = false;
    private boolean iCanOwnerEdit = false;
    private boolean iCanOwnerLimitedEdit = false;
    private boolean iCanAudit = false;
    private boolean iCanTimetable = false;
    private boolean iCanCommit = false;
    private boolean iCanExamView = false;
    private boolean iCanExamEdit = false;
    private boolean iCanExamTimetable = false;
    private boolean iCanNoRoleReportExamFin = false;
    private boolean iCanNoRoleReportExamMid = false;
    private boolean iCanNoRoleReportClass = false;
    private boolean iCanSectioningStudents = false;
    private boolean iCanPreRegisterStudents = false;
    private boolean iCanOnlineSectionStudents = false;
    private boolean iTestSession = false;
    private boolean iAllowNoRole = false;
    private boolean iAllowRollForward = false;
    private boolean iEventManagement = false;
    private boolean iInstructorSurvey = false;

    public DeptStatusTypeEditForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.iReference == null || this.iReference.trim().length() == 0) {
            action.addFieldError("form.reference", MSG.errorRequiredField(MSG.fieldReference()));
        } else {
            try {
                DepartmentStatusType ds = DepartmentStatusType.findByRef(this.iReference);
                if (ds != null && !ds.getUniqueId().equals(this.iUniqueId)) {
                    action.addFieldError("form.reference", MSG.errorAlreadyExists(this.iReference));
                }
            }
            catch (Exception e) {
                action.addFieldError("form.reference", e.getMessage());
            }
        }
        if (this.iLabel == null || this.iLabel.trim().length() == 0) {
            action.addFieldError("form.label", MSG.errorRequiredField(MSG.fieldLabel()));
        }
        if (this.iApply < 0) {
            action.addFieldError("form.label", MSG.errorRequiredField(MSG.fieldApply()));
        }
    }

    @Override
    public void reset() {
        this.iOp = "List";
        this.iUniqueId = -1L;
        this.iReference = null;
        this.iLabel = null;
        this.iApply = 0;
        this.iOrder = DepartmentStatusType.findAll().size();
        this.iCanManagerView = false;
        this.iCanManagerEdit = false;
        this.iCanManagerLimitedEdit = false;
        this.iCanOwnerView = false;
        this.iCanOwnerEdit = false;
        this.iCanOwnerLimitedEdit = false;
        this.iCanAudit = false;
        this.iCanTimetable = false;
        this.iCanCommit = false;
        this.iCanExamView = false;
        this.iCanExamEdit = false;
        this.iCanExamTimetable = false;
        this.iCanNoRoleReportExamFin = false;
        this.iCanNoRoleReportExamMid = false;
        this.iCanNoRoleReportClass = false;
        this.iCanSectioningStudents = false;
        this.iCanPreRegisterStudents = false;
        this.iCanOnlineSectionStudents = false;
        this.iTestSession = false;
        this.iAllowNoRole = false;
        this.iAllowRollForward = false;
        this.iEventManagement = false;
        this.iInstructorSurvey = false;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setReference(String reference) {
        this.iReference = reference;
    }

    public String getReference() {
        return this.iReference;
    }

    public void setLabel(String label) {
        this.iLabel = label;
    }

    public String getLabel() {
        return this.iLabel;
    }

    public void setOrder(int order) {
        this.iOrder = order;
    }

    public int getOrder() {
        return this.iOrder;
    }

    public int getApply() {
        return this.iApply;
    }

    public void setApply(int apply) {
        this.iApply = apply;
    }

    public void setApply(Long apply) {
        this.iApply = apply == null ? -1 : (int)apply.longValue();
    }

    public Vector getApplyOptions() {
        Vector<IdValue> options = new Vector<IdValue>();
        options.add(new IdValue(Long.valueOf(DepartmentStatusType.Apply.Session.toInt()), MSG.applyToSession()));
        options.add(new IdValue(Long.valueOf(DepartmentStatusType.Apply.Department.toInt()), MSG.applyToDepartment()));
        options.add(new IdValue(Long.valueOf(DepartmentStatusType.Apply.ExamStatus.toInt()), MSG.applyToExaminations()));
        options.add(new IdValue(Long.valueOf(DepartmentStatusType.Apply.Session.toInt() | DepartmentStatusType.Apply.Department.toInt()), MSG.applyToSessionAndDepartment()));
        options.add(new IdValue(Long.valueOf(DepartmentStatusType.Apply.Session.toInt() | DepartmentStatusType.Apply.Department.toInt() | DepartmentStatusType.Apply.ExamStatus.toInt()), MSG.applyToAll()));
        return options;
    }

    public void setCanManagerView(boolean canManagerView) {
        this.iCanManagerView = canManagerView;
    }

    public boolean getCanManagerView() {
        return this.iCanManagerView;
    }

    public void setCanManagerEdit(boolean canManagerEdit) {
        this.iCanManagerEdit = canManagerEdit;
    }

    public boolean getCanManagerEdit() {
        return this.iCanManagerEdit;
    }

    public void setCanManagerLimitedEdit(boolean canManagerLimitedEdit) {
        this.iCanManagerLimitedEdit = canManagerLimitedEdit;
    }

    public boolean getCanManagerLimitedEdit() {
        return this.iCanManagerLimitedEdit;
    }

    public void setCanOwnerView(boolean canOwnerView) {
        this.iCanOwnerView = canOwnerView;
    }

    public boolean getCanOwnerView() {
        return this.iCanOwnerView;
    }

    public void setCanOwnerEdit(boolean canOwnerEdit) {
        this.iCanOwnerEdit = canOwnerEdit;
    }

    public boolean getCanOwnerEdit() {
        return this.iCanOwnerEdit;
    }

    public void setCanOwnerLimitedEdit(boolean canOwnerLimitedEdit) {
        this.iCanOwnerLimitedEdit = canOwnerLimitedEdit;
    }

    public boolean getCanOwnerLimitedEdit() {
        return this.iCanOwnerLimitedEdit;
    }

    public void setCanAudit(boolean canAudit) {
        this.iCanAudit = canAudit;
    }

    public boolean getCanAudit() {
        return this.iCanAudit;
    }

    public void setCanTimetable(boolean canTimetable) {
        this.iCanTimetable = canTimetable;
    }

    public boolean getCanTimetable() {
        return this.iCanTimetable;
    }

    public void setCanCommit(boolean canCommit) {
        this.iCanCommit = canCommit;
    }

    public boolean getCanCommit() {
        return this.iCanCommit;
    }

    public boolean getCanExamView() {
        return this.iCanExamView;
    }

    public void setCanExamView(boolean canExamView) {
        this.iCanExamView = canExamView;
    }

    public boolean getCanExamEdit() {
        return this.iCanExamEdit;
    }

    public void setCanExamEdit(boolean canExamEdit) {
        this.iCanExamEdit = canExamEdit;
    }

    public boolean getCanExamTimetable() {
        return this.iCanExamTimetable;
    }

    public void setCanExamTimetable(boolean canExamTimetable) {
        this.iCanExamTimetable = canExamTimetable;
    }

    public void setCanNoRoleReportExamFin(boolean canNoRoleReportExamFin) {
        this.iCanNoRoleReportExamFin = canNoRoleReportExamFin;
    }

    public boolean getCanNoRoleReportExamFin() {
        return this.iCanNoRoleReportExamFin;
    }

    public void setCanNoRoleReportExamMid(boolean canNoRoleReportExamMid) {
        this.iCanNoRoleReportExamMid = canNoRoleReportExamMid;
    }

    public boolean getCanNoRoleReportExamMid() {
        return this.iCanNoRoleReportExamMid;
    }

    public void setCanNoRoleReportClass(boolean canNoRoleReportClass) {
        this.iCanNoRoleReportClass = canNoRoleReportClass;
    }

    public boolean getCanNoRoleReportClass() {
        return this.iCanNoRoleReportClass;
    }

    public void setCanSectioningStudents(boolean canSectioningStudents) {
        this.iCanSectioningStudents = canSectioningStudents;
    }

    public boolean getCanSectioningStudents() {
        return this.iCanSectioningStudents;
    }

    public void setCanPreRegisterStudents(boolean canPreRegisterStudents) {
        this.iCanPreRegisterStudents = canPreRegisterStudents;
    }

    public boolean getCanPreRegisterStudents() {
        return this.iCanPreRegisterStudents;
    }

    public void setCanOnlineSectionStudents(boolean canOnlineSectionStudents) {
        this.iCanOnlineSectionStudents = canOnlineSectionStudents;
    }

    public boolean getCanOnlineSectionStudents() {
        return this.iCanOnlineSectionStudents;
    }

    public void setTestSession(boolean testSession) {
        this.iTestSession = testSession;
    }

    public boolean getTestSession() {
        return this.iTestSession;
    }

    public void setAllowNoRole(boolean allowNoRole) {
        this.iAllowNoRole = allowNoRole;
    }

    public boolean getAllowNoRole() {
        return this.iAllowNoRole;
    }

    public void setAllowRollForward(boolean allowRollForward) {
        this.iAllowRollForward = allowRollForward;
    }

    public boolean getAllowRollForward() {
        return this.iAllowRollForward;
    }

    public void setEventManagement(boolean eventManagement) {
        this.iEventManagement = eventManagement;
    }

    public boolean getEventManagement() {
        return this.iEventManagement;
    }

    public void setInstructorSurvey(boolean instructorSurvey) {
        this.iInstructorSurvey = instructorSurvey;
    }

    public boolean getInstructorSurvey() {
        return this.iInstructorSurvey;
    }

    public int getRights() {
        int rights = 0;
        if (this.getCanManagerView()) {
            rights += DepartmentStatusType.Status.ManagerView.toInt();
        }
        if (this.getCanManagerEdit()) {
            rights += DepartmentStatusType.Status.ManagerEdit.toInt();
        }
        if (this.getCanManagerLimitedEdit()) {
            rights += DepartmentStatusType.Status.ManagerLimitedEdit.toInt();
        }
        if (this.getCanOwnerView()) {
            rights += DepartmentStatusType.Status.OwnerView.toInt();
        }
        if (this.getCanOwnerEdit()) {
            rights += DepartmentStatusType.Status.OwnerEdit.toInt();
        }
        if (this.getCanOwnerLimitedEdit()) {
            rights += DepartmentStatusType.Status.OwnerLimitedEdit.toInt();
        }
        if (this.getCanAudit()) {
            rights += DepartmentStatusType.Status.Audit.toInt();
        }
        if (this.getCanTimetable()) {
            rights += DepartmentStatusType.Status.Timetable.toInt();
        }
        if (this.getCanCommit()) {
            rights += DepartmentStatusType.Status.Commit.toInt();
        }
        if (this.getCanExamView()) {
            rights += DepartmentStatusType.Status.ExamView.toInt();
        }
        if (this.getCanExamEdit()) {
            rights += DepartmentStatusType.Status.ExamEdit.toInt();
        }
        if (this.getCanExamTimetable()) {
            rights += DepartmentStatusType.Status.ExamTimetable.toInt();
        }
        if (this.getCanNoRoleReportExamFin()) {
            rights += DepartmentStatusType.Status.ReportExamsFinal.toInt();
        }
        if (this.getCanNoRoleReportExamMid()) {
            rights += DepartmentStatusType.Status.ReportExamsMidterm.toInt();
        }
        if (this.getCanNoRoleReportClass()) {
            rights += DepartmentStatusType.Status.ReportClasses.toInt();
        }
        if (this.getCanSectioningStudents()) {
            rights += DepartmentStatusType.Status.StudentsAssistant.toInt();
        }
        if (this.getCanPreRegisterStudents()) {
            rights += DepartmentStatusType.Status.StudentsPreRegister.toInt();
        }
        if (this.getCanOnlineSectionStudents()) {
            rights += DepartmentStatusType.Status.StudentsOnline.toInt();
        }
        if (this.getTestSession()) {
            rights += DepartmentStatusType.Status.TestSession.toInt();
        }
        if (this.getAllowNoRole()) {
            rights += DepartmentStatusType.Status.AllowNoRole.toInt();
        }
        if (this.getAllowRollForward()) {
            rights += DepartmentStatusType.Status.AllowRollForward.toInt();
        }
        if (this.getEventManagement()) {
            rights += DepartmentStatusType.Status.EventManagement.toInt();
        }
        if (this.getInstructorSurvey()) {
            rights += DepartmentStatusType.Status.InstructorSurvey.toInt();
        }
        return rights;
    }

    public void setRights(int rights) {
        this.setCanManagerView(DepartmentStatusType.Status.ManagerView.has(rights));
        this.setCanManagerEdit(DepartmentStatusType.Status.ManagerEdit.has(rights));
        this.setCanManagerLimitedEdit(DepartmentStatusType.Status.ManagerLimitedEdit.has(rights));
        this.setCanOwnerView(DepartmentStatusType.Status.OwnerView.has(rights));
        this.setCanOwnerEdit(DepartmentStatusType.Status.OwnerEdit.has(rights));
        this.setCanOwnerLimitedEdit(DepartmentStatusType.Status.OwnerLimitedEdit.has(rights));
        this.setCanAudit(DepartmentStatusType.Status.Audit.has(rights));
        this.setCanTimetable(DepartmentStatusType.Status.Timetable.has(rights));
        this.setCanCommit(DepartmentStatusType.Status.Commit.has(rights));
        this.setCanExamView(DepartmentStatusType.Status.ExamView.has(rights));
        this.setCanExamEdit(DepartmentStatusType.Status.ExamEdit.has(rights));
        this.setCanExamTimetable(DepartmentStatusType.Status.ExamTimetable.has(rights));
        this.setCanNoRoleReportExamFin(DepartmentStatusType.Status.ReportExamsFinal.has(rights));
        this.setCanNoRoleReportExamMid(DepartmentStatusType.Status.ReportExamsMidterm.has(rights));
        this.setCanNoRoleReportClass(DepartmentStatusType.Status.ReportClasses.has(rights));
        this.setCanSectioningStudents(DepartmentStatusType.Status.StudentsAssistant.has(rights));
        this.setCanPreRegisterStudents(DepartmentStatusType.Status.StudentsPreRegister.has(rights));
        this.setCanOnlineSectionStudents(DepartmentStatusType.Status.StudentsOnline.has(rights));
        this.setTestSession(DepartmentStatusType.Status.TestSession.has(rights));
        this.setAllowNoRole(DepartmentStatusType.Status.AllowNoRole.has(rights));
        this.setAllowRollForward(DepartmentStatusType.Status.AllowRollForward.has(rights));
        this.setEventManagement(DepartmentStatusType.Status.EventManagement.has(rights));
        this.setInstructorSurvey(DepartmentStatusType.Status.InstructorSurvey.has(rights));
    }

    public void load(DepartmentStatusType s) {
        if (s == null) {
            this.reset();
            this.setOp(MSG.actionSaveStatusType());
        } else {
            this.setUniqueId(s.getUniqueId());
            this.setReference(s.getReference());
            this.setLabel(s.getLabel());
            this.setApply(s.getApply());
            this.setRights(s.getStatus());
            this.setOrder(s.getOrd());
            this.setOp(MSG.actionUpdateStatusType());
        }
    }

    public DepartmentStatusType saveOrUpdate(org.hibernate.Session hibSession) throws Exception {
        DepartmentStatusType s = null;
        if (this.getUniqueId().intValue() >= 0) {
            s = (DepartmentStatusType)DepartmentStatusTypeDAO.getInstance().get(this.getUniqueId());
        }
        if (s == null) {
            s = new DepartmentStatusType();
        }
        s.setReference(this.getReference());
        s.setLabel(this.getLabel());
        s.setApply(this.getApply());
        if (s.getOrd() == null) {
            s.setOrd(DepartmentStatusType.findAll().size());
        }
        s.setStatus(this.getRights());
        if (s.getUniqueId() != null) {
            hibSession.persist((Object)s);
        } else {
            hibSession.merge((Object)s);
        }
        this.setUniqueId(s.getUniqueId());
        return s;
    }

    public void delete(org.hibernate.Session hibSession) throws Exception {
        if (this.getUniqueId().intValue() < 0) {
            return;
        }
        DepartmentStatusType s = (DepartmentStatusType)DepartmentStatusTypeDAO.getInstance().get(this.getUniqueId());
        for (Session session : hibSession.createQuery("select s from Session s where s.statusType.uniqueId=:id", Session.class).setParameter("id", (Object)s.getUniqueId()).list()) {
            DepartmentStatusType other = null;
            for (DepartmentStatusType x : DepartmentStatusType.findAll()) {
                if (x.getUniqueId().equals(s.getUniqueId()) || !x.applySession()) continue;
                other = x;
                break;
            }
            if (other == null) {
                throw new RuntimeException("Unable to delete session status " + this.getReference() + ", no other session status available.");
            }
            session.setStatusType(other);
            hibSession.merge((Object)session);
        }
        for (Department dept : hibSession.createQuery("select d from Department d where d.statusType.uniqueId=:id", Department.class).setParameter("id", (Object)s.getUniqueId()).list()) {
            dept.setStatusType(null);
            hibSession.merge((Object)dept);
        }
        for (DepartmentStatusType x : DepartmentStatusType.findAll()) {
            if (x.getOrd() <= s.getOrd()) continue;
            x.setOrd(x.getOrd() - 1);
            hibSession.merge((Object)x);
        }
        if (s != null) {
            hibSession.remove((Object)s);
        }
    }
}

