/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.unitime.commons.Debug;
import org.unitime.timetable.filter.RequestXSSFilter;

public class XSSFilter
implements Filter {
    private FilterConfig filterConfig;
    private String replaceStr = "_";
    private String addlChars = "";
    private String charsAllowed = "A-Za-z0-9@. _+&%/\\-";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String replaceStrParam = this.filterConfig.getInitParameter("replace_string");
        String addlCharsParam = this.filterConfig.getInitParameter("additional_chars");
        if (replaceStrParam != null) {
            this.replaceStr = replaceStrParam;
        }
        if (addlCharsParam != null) {
            this.addlChars = addlCharsParam;
        }
        String charPattern = "([^" + this.charsAllowed + this.addlChars + "]+)(%0A)";
        RequestXSSFilter rxs = new RequestXSSFilter((HttpServletRequest)request, this.replaceStr, charPattern);
        chain.doFilter((ServletRequest)rxs, response);
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public static void main(String[] args) {
        String result;
        String arg = "jhfsdhfds/=+;-%0Adsa";
        if (args[0] != null && args[0].trim().length() > 0) {
            arg = args[0];
        }
        if (!(result = arg.trim().replaceAll("([^A-Za-z0-9@.' _+&%/=\\-]+)(%0A)", "_")).equals(arg)) {
            Debug.debug("Before Filtering: " + result);
            Debug.debug("After Filtering: " + result);
        }
    }
}

