/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.timetable.security.UserContext;

public class MessageLogFilter
implements Filter {
    private String iHost = null;

    public void init(FilterConfig config) throws ServletException {
        try {
            this.iHost = InetAddress.getLocalHost().getHostName();
            if (this.iHost.indexOf(46) > 0) {
                this.iHost = this.iHost.substring(0, this.iHost.indexOf(46));
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void destroy() {
    }

    private UserContext getUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof UserContext) {
            return (UserContext)authentication.getPrincipal();
        }
        return null;
    }

    private void populateThreadContext() {
        try {
            UserContext user = this.getUser();
            if (user != null) {
                ThreadContext.push((String)("uid:" + user.getTrueExternalUserId()));
                if (user.getCurrentAuthority() != null) {
                    ThreadContext.push((String)("role:" + user.getCurrentAuthority().getRole()));
                    Long sessionId = user.getCurrentAcademicSessionId();
                    if (sessionId != null) {
                        ThreadContext.push((String)("sid:" + sessionId));
                    }
                }
            }
            if (this.iHost != null) {
                ThreadContext.push((String)("host:" + this.iHost));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        try {
            this.populateThreadContext();
            chain.doFilter(request, response);
        }
        finally {
            ThreadContext.removeStack();
        }
    }
}

