/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;

public class CSVPrinter
implements Exporter.Printer {
    private PrintWriter iOut;
    private String[] iLastLine = null;
    private boolean iCheckLast = false;
    private Set<Integer> iHiddenColumns = new HashSet<Integer>();
    private String iDelimiter = ",";
    private String iQuotation = "\"";

    public CSVPrinter(PrintWriter writer, boolean checkLast, String delimiter, String quotation) {
        this.iOut = writer;
        this.iCheckLast = checkLast;
        this.iDelimiter = delimiter == null || delimiter.isEmpty() ? "," : delimiter;
        this.iQuotation = quotation == null ? "\"" : quotation;
    }

    public CSVPrinter(PrintWriter writer, boolean checkLast) {
        this(writer, checkLast, ",", "\"");
    }

    public CSVPrinter(ExportHelper helper, boolean checkLast) throws IOException {
        this(helper.getWriter(), checkLast, helper.getParameter("csvDelimiter"), helper.getParameter("csvQuotation"));
    }

    @Override
    public String getContentType() {
        return "text/csv";
    }

    @Override
    public void hideColumn(int col) {
        this.iHiddenColumns.add(col);
    }

    @Override
    public void printHeader(String ... fields) {
        this.printLine(fields);
    }

    @Override
    public void printLine(String ... fields) {
        for (int idx = 0; idx < fields.length; ++idx) {
            if (this.iHiddenColumns.contains(idx)) continue;
            String f = fields[idx];
            if (!(f == null || f.isEmpty() || this.iCheckLast && f.equals(this.iLastLine == null || idx >= this.iLastLine.length ? null : this.iLastLine[idx]))) {
                if (this.iQuotation != null && !this.iQuotation.isEmpty()) {
                    this.iOut.print(this.iQuotation + f.replace(this.iQuotation, this.iQuotation + this.iQuotation) + this.iQuotation);
                } else {
                    this.iOut.print(f);
                }
            }
            if (idx + 1 >= fields.length) continue;
            this.iOut.print(this.iDelimiter == null || this.iDelimiter.isEmpty() ? "," : this.iDelimiter);
        }
        this.iOut.println();
        this.iLastLine = fields;
    }

    @Override
    public void flush() {
        this.iLastLine = null;
    }

    @Override
    public void close() {
    }
}

