/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Date;
import java.util.Properties;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.dom.DOMCDATA;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.ScriptParameter;
import org.unitime.timetable.model.Session;

public class ScriptExport
extends BaseExport {
    @Override
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            document.addDocType("scripts", "-//UniTime//UniTime Scripts DTD/EN", "http://www.unitime.org/interface/Script.dtd");
            Element root = document.addElement("scripts");
            root.addAttribute("created", new Date().toString());
            for (Script script : this.getHibSession().createQuery("from Script order by name", Script.class).list()) {
                ScriptExport.exportScript(root, script);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    public static Element exportScript(Element parent, Script script) {
        Element scriptEl = parent.addElement("script");
        scriptEl.addAttribute("name", script.getName());
        if (script.getPermission() != null) {
            scriptEl.addAttribute("permission", script.getPermission());
        }
        scriptEl.addAttribute("engine", script.getEngine());
        if (script.getDescription() != null) {
            scriptEl.addElement("description").add((CDATA)new DOMCDATA(script.getDescription()));
        }
        for (ScriptParameter parameter : script.getParameters()) {
            Element paramEl = scriptEl.addElement("parameter");
            paramEl.addAttribute("name", parameter.getName());
            if (parameter.getLabel() != null) {
                paramEl.addAttribute("label", parameter.getLabel());
            }
            paramEl.addAttribute("type", parameter.getType());
            if (parameter.getDefaultValue() == null) continue;
            paramEl.addAttribute("default", parameter.getDefaultValue());
        }
        if (script.getScript() != null) {
            scriptEl.addElement("body").add((CDATA)new DOMCDATA(script.getScript()));
        }
        return scriptEl;
    }
}

