/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomSharingModel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.util.CalendarUtils;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

public class RoomSharingImport
extends BaseImport {
    protected static Formats.Format<Date> sTimeFormat = Formats.getDateFormat("HHmm");
    private String iTimeFormat = null;

    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("roomSharing")) {
            throw new Exception("Given XML file is not a Room Sharing load file.");
        }
        try {
            Session session;
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            this.iTimeFormat = root.attributeValue("timeFormat");
            if (this.iTimeFormat == null) {
                this.iTimeFormat = "HHmm";
            }
            if ((session = Session.getSessionUsingInitiativeYearTerm(campus, year, term)) == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            if (!"true".equals(root.attributeValue("force")) && Solution.hasTimetable(session.getUniqueId())) {
                this.info("Note: set the attribute force='true' of the root element to override the following import eligibility check.");
                throw new Exception("Room sharing import is disabled: " + session.getLabel() + " already has a committed timetable.");
            }
            this.info("Loading rooms...");
            HashSet<String> avoidRoomId = new HashSet<String>();
            HashSet<String> avoidRoomName = new HashSet<String>();
            HashMap<String, Location> id2location = new HashMap<String, Location>();
            HashMap<String, Location> name2location = new HashMap<String, Location>();
            for (Location location : this.getHibSession().createQuery("from Location where session.uniqueId = :sessionId", Location.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                Object old;
                if (location.getExternalUniqueId() != null && !avoidRoomId.contains(location.getExternalUniqueId()) && (old = id2location.put(location.getExternalUniqueId(), location)) != null) {
                    this.warn("There are two or more rooms with the same external id " + location.getExternalUniqueId() + ": " + location.getLabel() + " and " + ((Location)old).getLabel() + ".");
                    avoidRoomId.add(location.getExternalUniqueId());
                }
                if (avoidRoomName.contains(location.getLabel()) || (old = name2location.put(location.getLabel(), location)) == null) continue;
                this.warn("There are two or more rooms with the same name " + location.getLabel() + ".");
                avoidRoomName.add(location.getLabel());
            }
            this.info("Loading departments...");
            HashMap<String, Department> id2department = new HashMap<String, Department>();
            HashMap<String, Department> code2department = new HashMap<String, Department>();
            for (Department dept : this.getHibSession().createQuery("from Department where session.uniqueId = :sessionId", Department.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                Department old;
                if (dept.getExternalUniqueId() != null && (old = id2department.put(dept.getExternalUniqueId(), dept)) != null) {
                    this.warn("There are two departments with the same external id " + dept.getExternalUniqueId() + ": " + dept.getLabel() + " and " + old.getLabel() + ".");
                }
                if ((old = code2department.put(dept.getDeptCode(), dept)) == null) continue;
                this.warn("There are two rooms with the same code " + dept.getDeptCode() + ": " + dept.getName() + " and " + old.getName() + ".");
            }
            this.info("Importing room sharing...");
            int nrChanged = 0;
            Iterator i = root.elementIterator("location");
            while (i.hasNext()) {
                String newModel;
                String name;
                Element locEl = (Element)i.next();
                Location location = null;
                String locId = locEl.attributeValue("id");
                if (locId != null && !avoidRoomId.contains(locId) && (location = (Location)id2location.get(locId)) == null) {
                    this.warn("Location of id " + locId + " does not exist.");
                }
                if (location == null) {
                    String building = locEl.attributeValue("building");
                    String roomNbr = locEl.attributeValue("roomNbr");
                    if (building != null && roomNbr != null && !avoidRoomName.contains(building + " " + roomNbr) && (location = (Location)name2location.get(building + " " + roomNbr)) == null) {
                        this.warn("Location of building " + building + " and room number " + roomNbr + " does not exist.");
                    }
                }
                if (location == null && (name = locEl.attributeValue("name")) != null && !avoidRoomName.contains(name) && (location = (Location)name2location.get(name)) == null) {
                    this.warn("Location of name " + name + " does not exist.");
                }
                if (location == null) continue;
                HashSet<RoomDept> existing = new HashSet<RoomDept>(location.getRoomDepts());
                HashSet<Department> departments = new HashSet<Department>();
                boolean changed = false;
                String note = locEl.attributeValue("note");
                if (note == null && location.getShareNote() != null) {
                    location.setShareNote(null);
                    this.info(location.getLabel() + ": share note removed.");
                    changed = true;
                } else if (note != null && !note.equals(location.getShareNote())) {
                    location.setShareNote(note);
                    this.info(location.getLabel() + ": share note changed to '" + note + "'.");
                    changed = true;
                }
                Iterator j = locEl.elementIterator("department");
                block5: while (j.hasNext()) {
                    String deptCode;
                    Element deptEl = (Element)j.next();
                    Department dept = null;
                    String deptId = deptEl.attributeValue("id");
                    if (deptId != null && (dept = (Department)id2department.get(deptId)) == null) {
                        this.warn(location.getLabel() + ": Department of id " + deptId + " does not exist.");
                    }
                    if ((deptCode = deptEl.attributeValue("code")) != null && (dept = (Department)code2department.get(deptCode)) == null) {
                        this.warn(location.getLabel() + ": Department of code " + deptCode + " does not exist.");
                    }
                    if (dept == null) continue;
                    Boolean control = "true".equals(deptEl.attributeValue("control"));
                    Iterator k = existing.iterator();
                    while (k.hasNext()) {
                        RoomDept rd = (RoomDept)k.next();
                        if (!rd.getDepartment().equals(dept)) continue;
                        if (!control.equals(rd.getControl())) {
                            rd.setControl(control);
                            this.getHibSession().merge((Object)rd);
                            this.info(location.getLabel() + ": " + (control != false ? " control moved to " + dept.getLabel() : " control removed from " + dept.getLabel()));
                            changed = true;
                        }
                        k.remove();
                        departments.add(dept);
                        continue block5;
                    }
                    RoomDept rd = new RoomDept();
                    rd.setControl(control);
                    rd.setDepartment(dept);
                    rd.setRoom(location);
                    location.getRoomDepts().add(rd);
                    dept.getRoomDepts().add(rd);
                    this.getHibSession().persist((Object)rd);
                    departments.add(dept);
                    this.info(location.getLabel() + ": added " + (control != false ? "controlling " : "") + " department" + dept.getLabel());
                    changed = true;
                }
                for (RoomDept rd : existing) {
                    this.info(location.getLabel() + ": removed " + (rd.isControl() != false ? "controlling " : "") + " department" + rd.getDepartment().getLabel());
                    location.getRoomDepts().remove(rd);
                    rd.getDepartment().getRoomDepts().remove(rd);
                    this.getHibSession().remove((Object)rd);
                    changed = true;
                }
                RoomSharingModel model = location.getRoomSharingModel();
                String oldModel = model.toString();
                model.setPreferences(null);
                Element sharingEl = locEl.element("sharing");
                if (sharingEl != null) {
                    Iterator j2 = sharingEl.elementIterator();
                    while (j2.hasNext()) {
                        Element el = (Element)j2.next();
                        TimeObject time = new TimeObject(el.attributeValue("start"), el.attributeValue("end"), el.attributeValue("days"));
                        String pref = null;
                        if ("unavailable".equals(el.getName())) {
                            pref = RoomSharingModel.sNotAvailablePref.toString();
                        } else if ("assigned".equals(el.getName())) {
                            String deptCode;
                            Department dept = null;
                            String deptId = el.attributeValue("id");
                            if (deptId != null && (dept = (Department)id2department.get(deptId)) == null) {
                                this.warn(location.getLabel() + ": Department of id " + deptId + " does not exist.");
                            }
                            if ((deptCode = el.attributeValue("code")) != null && (dept = (Department)code2department.get(deptCode)) == null) {
                                this.warn(location.getLabel() + ": Department of code " + deptCode + " does not exist.");
                            }
                            if (dept == null) continue;
                            if (!departments.contains(dept)) {
                                this.warn(location.getLabel() + ": Department " + dept.getLabel() + " is not among the room sharing departments.");
                                continue;
                            }
                            pref = dept.getUniqueId().toString();
                        }
                        if (pref == null) continue;
                        if (time.hasDays()) {
                            for (int d : time.getDays()) {
                                for (int t = time.getStartPeriod().intValue(); t < time.getEndPeriod(); ++t) {
                                    model.setPreference(d, t, pref);
                                }
                            }
                            continue;
                        }
                        for (int d = 0; d < model.getNrDays(); ++d) {
                            for (int t = time.getStartPeriod().intValue(); t < time.getEndPeriod(); ++t) {
                                model.setPreference(d, t, pref);
                            }
                        }
                    }
                }
                if (!oldModel.equals(newModel = model.toString())) {
                    this.info(location.getLabel() + ": room sharing changed to " + (newModel.isEmpty() ? "free for all" : newModel));
                    changed = true;
                }
                location.setRoomSharingModel(model);
                this.getHibSession().merge((Object)location);
                if (!changed) continue;
                ++nrChanged;
            }
            if (nrChanged == 0) {
                this.info("No change detected.");
            } else {
                this.info(nrChanged + " locations have changed.");
            }
            this.info("All done.");
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    protected class TimeObject {
        private Integer iStartPeriod;
        private Integer iEndPeriod;
        private Set<Integer> iDays = null;

        TimeObject(String startTime, String endTime, String daysOfWeek) throws Exception {
            this.iStartPeriod = startTime == null ? 0 : this.str2Slot(startTime);
            if (this.iStartPeriod < 0 || this.iStartPeriod >= 288) {
                this.iStartPeriod = 0;
            }
            this.iEndPeriod = endTime == null ? 288 : this.str2Slot(endTime);
            if (this.iEndPeriod < 0 || this.iEndPeriod > 288) {
                this.iEndPeriod = 288;
            }
            if (this.iStartPeriod > this.iEndPeriod) {
                RoomSharingImport.this.error("Invalid time '" + startTime + "' -- must be before " + endTime + ".");
                int x = this.iStartPeriod;
                this.iStartPeriod = this.iEndPeriod;
                this.iEndPeriod = x;
            }
            if (daysOfWeek != null) {
                this.setDaysOfWeek(daysOfWeek);
            }
        }

        private void setDaysOfWeek(String daysOfWeek) {
            this.iDays = new TreeSet<Integer>();
            String tmpDays = daysOfWeek;
            if (tmpDays.contains("Th")) {
                this.iDays.add(3);
                tmpDays = tmpDays.replace("Th", "..");
            }
            if (tmpDays.contains("R")) {
                this.iDays.add(3);
                tmpDays = tmpDays.replace("R", "..");
            }
            if (tmpDays.contains("Su")) {
                this.iDays.add(6);
                tmpDays = tmpDays.replace("Su", "..");
            }
            if (tmpDays.contains("U")) {
                this.iDays.add(6);
                tmpDays = tmpDays.replace("U", "..");
            }
            if (tmpDays.contains("M")) {
                this.iDays.add(0);
                tmpDays = tmpDays.replace("M", ".");
            }
            if (tmpDays.contains("T")) {
                this.iDays.add(1);
                tmpDays = tmpDays.replace("T", ".");
            }
            if (tmpDays.contains("W")) {
                this.iDays.add(2);
                tmpDays = tmpDays.replace("W", ".");
            }
            if (tmpDays.contains("F")) {
                this.iDays.add(4);
                tmpDays = tmpDays.replace("F", ".");
            }
            if (tmpDays.contains("S")) {
                this.iDays.add(5);
                tmpDays = tmpDays.replace("S", ".");
            }
        }

        public Integer getStartPeriod() {
            return this.iStartPeriod;
        }

        public Integer getEndPeriod() {
            return this.iEndPeriod;
        }

        public Set<Integer> getDays() {
            return this.iDays;
        }

        public boolean hasDays() {
            return this.iDays != null;
        }

        public Integer str2Slot(String timeString) {
            try {
                int time = 0;
                if ("HHmm".equals(RoomSharingImport.this.iTimeFormat)) {
                    time = Integer.parseInt(timeString);
                } else {
                    Date date = CalendarUtils.getDate(timeString, RoomSharingImport.this.iTimeFormat);
                    time = Integer.parseInt(sTimeFormat.format(date));
                }
                int hour = time / 100;
                int min = time % 100;
                if (hour > 24 || hour == 24 && min > 0) {
                    RoomSharingImport.this.error("Invalid time '" + timeString + "' -- hour (" + hour + ") must be between 0 and 23.");
                }
                if (min >= 60) {
                    RoomSharingImport.this.error("Invalid time '" + timeString + "' -- minute (" + min + ") must be between 0 and 59.");
                }
                if (min % Constants.SLOT_LENGTH_MIN != 0) {
                    RoomSharingImport.this.warn("Invalid time '" + timeString + "' -- minute (" + min + ") must be divisible by " + Constants.SLOT_LENGTH_MIN + ".");
                    min -= min % Constants.SLOT_LENGTH_MIN;
                }
                return (hour * 60 + min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            }
            catch (NumberFormatException ex) {
                RoomSharingImport.this.error("Invalid time '" + timeString + "' -- not a number.");
                return -1;
            }
            catch (Exception e) {
                RoomSharingImport.this.error("Invalid time '" + timeString + "' -- does not meet the format: " + RoomSharingImport.this.iTimeFormat);
                return -1;
            }
        }
    }
}

