/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.CourseOfferingImport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.test.UpdateExamConflicts;

public class ExamImport
extends CourseOfferingImport {
    protected List<Exam> exams;

    public ExamImport() {
        this.rootElementName = "exams";
    }

    @Override
    public void loadXml(Element rootElement) throws Exception {
        this.initializeTrimLeadingZeros();
        try {
            SolverParameterDef maxRoomsParam;
            if (!rootElement.getName().equalsIgnoreCase(this.rootElementName)) {
                throw new Exception("Given XML file is not an Examinations load file.");
            }
            this.beginTransaction();
            this.incremental = "true".equalsIgnoreCase(rootElement.attributeValue("incremental", "false"));
            if (this.incremental) {
                this.info("Incremental mode.");
            }
            this.includeExams = rootElement.attributeValue("includeExams", rootElement.attributeValue("type", "all"));
            if (!"none".equals(this.includeExams)) {
                this.info("Includes " + this.includeExams + " exams.");
            }
            if ((maxRoomsParam = SolverParameterDef.findByNameType(this.getHibSession(), "Exams.MaxRooms", SolverParameterGroup.SolverType.EXAM)) != null && maxRoomsParam.getDefault() != null) {
                this.defaultMaxNbrRooms = Integer.valueOf(maxRoomsParam.getDefault());
            }
            this.initializeLoad(rootElement, this.rootElementName);
            this.preLoadAction();
            this.loadExams(rootElement);
            this.commitTransaction();
            this.beginTransaction();
            this.postLoadAction();
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
        if (this.examPeriodChanged && this.session != null && ApplicationProperty.DataExchangeUpdateStudentConflictsFinal.isTrue()) {
            try {
                this.beginTransaction();
                for (ExamType type : ExamType.findAllOfType(0)) {
                    new UpdateExamConflicts(this).update(this.session.getUniqueId(), type.getUniqueId(), this.getHibSession());
                }
                this.commitTransaction();
            }
            catch (Exception e) {
                this.fatal("Exception: " + e.getMessage(), e);
                this.rollbackTransaction();
            }
        }
        if (this.examPeriodChanged && this.session != null && ApplicationProperty.DataExchangeUpdateStudentConflictsMidterm.isTrue()) {
            try {
                this.beginTransaction();
                for (ExamType type : ExamType.findAllOfType(1)) {
                    new UpdateExamConflicts(this).update(this.session.getUniqueId(), type.getUniqueId(), this.getHibSession());
                }
                this.commitTransaction();
            }
            catch (Exception e) {
                this.fatal("Exception: " + e.getMessage(), e);
                this.rollbackTransaction();
            }
        }
        this.addNote("Records Changed: " + this.changeCount);
        this.updateChangeList(true);
        this.reportMissingLocations();
        this.mailLoadResults();
    }

    @Override
    protected void preLoadAction() {
        this.exams = new ArrayList<Exam>(this.getHibSession().createQuery("select x from Exam x left join fetch x.owners o where x.session.uniqueId = :sessionId", Exam.class).setParameter("sessionId", (Object)this.session.getUniqueId()).list());
    }

    protected void loadExams(Element rootElement) throws Exception {
        Iterator it = rootElement.elementIterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            try {
                this.importExam(element, null, this.exams);
                this.flush(true);
            }
            catch (Exception e) {
                this.addNote("Not Loading 'exam' Error:  " + e.getMessage());
                e.printStackTrace();
                this.addNote("\t " + element.asXML());
                this.updateChangeList(true);
                this.rollbackTransaction();
                this.beginTransaction();
            }
        }
    }

    @Override
    protected void postLoadAction() {
        if (!this.incremental) {
            for (Exam exam : this.exams) {
                if ("final".equals(this.includeExams) && exam.getExamType().getType() != 0 || "midterm".equals(this.includeExams) && exam.getExamType().getType() != 1) continue;
                this.addNote("\tremoved exam: " + exam.getLabel() + " (" + exam.getExamType().getReference() + ")");
                exam = (Exam)ExamDAO.getInstance().get(exam.getUniqueId(), this.getHibSession());
                exam.deleteDependentObjects(this.getHibSession(), false);
                this.getHibSession().remove((Object)exam);
            }
        }
    }
}

