/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.dataexchange.CourseOfferingExport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;

public class CourseTimetableExport
extends CourseOfferingExport {
    @Override
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            this.iExportGroupInfos = ApplicationProperty.DataExchangeIncludeStudentGroups.isTrue();
            document.addDocType("timetable", "-//UniTime//DTD University Course Timetabling/EN", "http://www.unitime.org/interface/CourseTimetable.dtd");
            Element root = document.addElement("timetable");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            root.addAttribute("action", "update");
            root.addAttribute("dateFormat", sDateFormat.toPattern());
            root.addAttribute("timeFormat", sTimeFormat.toPattern());
            root.addAttribute("created", new Date().toString());
            if (ApplicationProperty.DataExchangeIncludeMeetings.isTrue()) {
                this.iClassEvents = new HashMap();
                for (ClassEvent e : this.getHibSession().createQuery("from ClassEvent e where e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId", ClassEvent.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                    this.iClassEvents.put(e.getClazz().getUniqueId(), e);
                }
                this.iMeetingLocations = new HashMap();
                for (Location l : this.getHibSession().createQuery("from Location l where l.session.uniqueId = :sessionId", Location.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                    this.iMeetingLocations.put(l.getPermanentId(), l);
                }
            }
            List courses = this.getHibSession().createQuery("select c from CourseOffering as c where c.subjectArea.session.uniqueId=:sessionId order by c.subjectArea.subjectAreaAbbreviation, c.courseNbr", CourseOffering.class).setParameter("sessionId", (Object)session.getUniqueId()).setFetchSize(1000).list();
            for (CourseOffering course : courses) {
                for (InstrOfferingConfig config : course.getInstructionalOffering().getInstrOfferingConfigs()) {
                    for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                        if (subpart.getParentSubpart() != null) continue;
                        for (Class_ clazz : subpart.getClasses()) {
                            this.exportClass(root.addElement("class"), clazz, course, session);
                        }
                    }
                }
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    protected void exportClass(Element classElement, Class_ clazz, CourseOffering course, Session session) {
        classElement.addAttribute("id", clazz.getUniqueId().toString());
        classElement.addAttribute("subject", course.getSubjectArea().getSubjectAreaAbbreviation());
        classElement.addAttribute("courseNbr", course.getCourseNbr());
        classElement.addAttribute("type", clazz.getItypeDesc().trim());
        classElement.addAttribute("suffix", this.getClassSuffix(clazz));
        if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
            classElement.addAttribute("limit", "inf");
        } else {
            classElement.addAttribute("limit", String.valueOf(clazz.getClassLimit()));
        }
        if (clazz.getSchedulePrintNote() != null) {
            classElement.addAttribute("scheduleNote", clazz.getSchedulePrintNote());
        }
        classElement.addAttribute("studentScheduling", clazz.isEnabledForStudentScheduling() != false ? "true" : "false");
        classElement.addAttribute("displayInScheduleBook", clazz.isEnabledForStudentScheduling() != false ? "true" : "false");
        classElement.addAttribute("controlling", course.isIsControl() != false ? "true" : "false");
        classElement.addAttribute("cancelled", clazz.isCancelled() != false ? "true" : "false");
        if (clazz.getManagingDept().getSolverGroup() != null) {
            classElement.addAttribute("solver", clazz.getManagingDept().getSolverGroup().getAbbv());
        }
        for (Class_ childClazz : clazz.getChildClasses()) {
            this.exportClass(classElement.addElement("class"), childClazz, course, session);
        }
        if (clazz.getCommittedAssignment() != null) {
            this.exportAssignment(classElement, clazz.getCommittedAssignment(), session);
        } else if (clazz.getManagingDept().getSolverGroup() != null && clazz.getManagingDept().getSolverGroup().getCommittedSolution() != null) {
            this.exportArrHours(classElement, clazz, session);
        }
        if (clazz.isDisplayInstructor().booleanValue()) {
            for (ClassInstructor instructor : clazz.getClassInstructors()) {
                if (instructor.getInstructor().getExternalUniqueId() == null) continue;
                this.exportInstructor(classElement.addElement("instructor"), instructor, session);
            }
        }
    }

    @Override
    protected void exportArrHours(Element classElement, Class_ clazz, Session session) {
        this.exportDatePattern(classElement, clazz.effectiveDatePattern(), session);
        Element arrangeTimeEl = classElement.addElement("arrangeTime");
        if (clazz.getSchedulingSubpart().getMinutesPerWk() != null && clazz.getSchedulingSubpart().getMinutesPerWk() > 0) {
            arrangeTimeEl.addAttribute("minPerWeek", clazz.getSchedulingSubpart().getMinutesPerWk().toString());
        }
        this.exportRequiredRooms(classElement, clazz, session);
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                args = new String[]{"c:\\test\\timetable.xml", "puWestLafayetteTrdtn", "2007", "Fal"};
            }
            ToolBox.configureLogging();
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            Session session = Session.getSessionUsingInitiativeYearTerm(args[1], args[2], args[3]);
            if (session == null) {
                throw new Exception("Session " + args[1] + " " + args[2] + args[3] + " not found!");
            }
            new CourseTimetableExport().saveXml(args[0], session, ApplicationProperties.getProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

