/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.util.Enumeration;
import java.util.TreeSet;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.gwt.server.CurriculaServlet;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.CurriculumInterface;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.curricula.CurriculumFilterBackend;
import org.unitime.timetable.util.Constants;

@Service(value="/api/curricula")
public class CurriculaConnector
extends ApiConnector {
    @Override
    public void doGet(final ApiHelper helper) throws IOException {
        Long curriculumId = helper.getOptinalParameterLong("id", null);
        if (curriculumId != null) {
            Curriculum curriculum = (Curriculum)CurriculumDAO.getInstance().get(curriculumId);
            if (curriculum == null) {
                throw new IllegalArgumentException("Curriculum " + curriculumId + " does not exist.");
            }
            final Long sessionId = curriculum.getAcademicArea().getSessionId();
            helper.getSessionContext().checkPermissionAnyAuthority(sessionId, "Session", Right.ApiRetrieveCurricula, new Qualifiable[0]);
            CurriculaServlet servlet = new CurriculaServlet(){

                @Override
                protected SessionContext getSessionContext() {
                    return helper.getSessionContext();
                }

                @Override
                protected Long getAcademicSessionId() {
                    return sessionId;
                }
            };
            helper.setResponse(servlet.loadCurriculum(curriculumId));
            return;
        }
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        CurriculumInterface.CurriculumFilterRpcRequest filter = new CurriculumInterface.CurriculumFilterRpcRequest();
        filter.setCommand(EventInterface.FilterRpcRequest.Command.ENUMERATE);
        filter.setSessionId(sessionId);
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String command = e.nextElement();
            if (command.equals("c:text")) {
                filter.setText(helper.getParameter("c:text"));
                continue;
            }
            if (!command.startsWith("c:")) continue;
            for (String value : helper.getParameterValues(command)) {
                filter.addOption(command.substring(2), value);
            }
        }
        helper.getSessionContext().checkPermissionAnyAuthority(sessionId, "Session", Right.ApiRetrieveCurricula, new Qualifiable[0]);
        CurriculaServlet servlet = null;
        if (helper.getOptinalParameterBoolean("details", false).booleanValue()) {
            servlet = new CurriculaServlet(){

                @Override
                protected SessionContext getSessionContext() {
                    return helper.getSessionContext();
                }

                @Override
                protected Long getAcademicSessionId() {
                    return helper.getAcademicSessionId();
                }
            };
        }
        TreeSet<CurriculumInterface> results = new TreeSet<CurriculumInterface>();
        for (Curriculum c : CurriculumFilterBackend.curricula(sessionId, filter.getOptions(), new Query(filter.getText()), -1, null, Department.findAll(sessionId))) {
            if (servlet != null) {
                results.add(servlet.loadCurriculum(c.getUniqueId()));
                continue;
            }
            CurriculumInterface ci = new CurriculumInterface();
            ci.setId(c.getUniqueId());
            ci.setAbbv(c.getAbbv());
            ci.setName(c.getName());
            ci.setMultipleMajors(c.isMultipleMajors());
            CurriculumInterface.DepartmentInterface di = new CurriculumInterface.DepartmentInterface();
            di.setId(c.getDepartment().getUniqueId());
            di.setAbbv(c.getDepartment().getAbbreviation());
            di.setCode(c.getDepartment().getDeptCode());
            di.setName(c.getDepartment().getName());
            ci.setDepartment(di);
            CurriculumInterface.AcademicAreaInterface ai = new CurriculumInterface.AcademicAreaInterface();
            ai.setId(c.getAcademicArea().getUniqueId());
            ai.setAbbv(c.getAcademicArea().getAcademicAreaAbbreviation());
            ai.setName(Constants.curriculaToInitialCase(c.getAcademicArea().getTitle()));
            ci.setAcademicArea(ai);
            for (PosMajor major : c.getMajors()) {
                CurriculumInterface.MajorInterface mi = new CurriculumInterface.MajorInterface();
                mi.setId(major.getUniqueId());
                mi.setCode(major.getCode());
                mi.setName(Constants.curriculaToInitialCase(major.getName()));
                ci.addMajor(mi);
            }
            results.add(ci);
        }
        helper.setResponse(results);
    }

    @Override
    protected String getName() {
        return "curricula";
    }
}

