/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;

public abstract class AbstractApiHelper
implements ApiHelper {
    protected SessionContext iContext;
    protected HttpServletRequest iRequest;
    protected HttpServletResponse iResponse;
    protected Long iSessionId = null;
    protected CacheMode iCacheMode = null;
    protected Session iHibSession = null;

    public AbstractApiHelper(HttpServletRequest request, HttpServletResponse response, SessionContext context, CacheMode cacheMode) {
        this.iRequest = request;
        this.iResponse = response;
        this.iContext = context;
        this.iCacheMode = cacheMode;
        UserContext user = this.iContext == null ? null : this.iContext.getUser();
        Long sessionId = this.getAcademicSessionId();
        if (user != null && sessionId != null && !sessionId.equals(user.getCurrentAcademicSessionId())) {
            String role;
            String string = role = user.getCurrentAuthority() == null ? null : user.getCurrentAuthority().getRole();
            if (this.getParameter("role") != null) {
                role = this.getParameter("role");
            }
            UserAuthority best = null;
            for (UserAuthority userAuthority : user.getAuthorities()) {
                if (userAuthority.getAcademicSession() == null || !userAuthority.getAcademicSession().getQualifierId().equals(sessionId) || best != null && !userAuthority.getRole().equals(role)) continue;
                best = userAuthority;
            }
            if (best != null) {
                user.setCurrentAuthority(best);
            }
        }
    }

    @Override
    public void sendError(int code, String message) throws IOException {
        this.iResponse.sendError(code, message);
    }

    @Override
    public void sendError(int code) throws IOException {
        this.iResponse.sendError(code);
    }

    @Override
    public void sendError(int code, Throwable error) throws IOException {
        this.iResponse.sendError(code, error.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long guessAcademicSessionId() {
        Long sessionId = null;
        sessionId = this.getParameter("sid") != null ? Long.valueOf(this.getParameter("sid")) : (this.iContext.isAuthenticated() ? (Long)(this.iContext.getUser().getCurrentAuthority() == null ? null : this.iContext.getUser().getCurrentAuthority().getAcademicSession().getQualifierId()) : (Long)this.iContext.getAttribute(SessionAttribute.OnlineSchedulingLastSession));
        if (this.getParameter("term") != null) {
            try (Session hibSession = SessionDAO.getInstance().createNewSession();){
                List sessions = hibSession.createQuery("select s.uniqueId from Session s where s.academicTerm || s.academicYear = :term or s.academicTerm || s.academicYear || s.academicInitiative = :term", Long.class).setParameter("term", (Object)this.getParameter("term")).list();
                if (!sessions.isEmpty()) {
                    sessionId = (Long)sessions.get(0);
                }
            }
        }
        return sessionId;
    }

    @Override
    public Long getAcademicSessionId() {
        if (this.iSessionId == null) {
            this.iSessionId = this.guessAcademicSessionId();
        }
        return this.iSessionId;
    }

    @Override
    public String getParameter(String name) {
        return this.iRequest.getParameter(name);
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.iRequest.getParameterValues(name);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return this.iRequest.getParameterNames();
    }

    @Override
    public SessionContext getSessionContext() {
        return this.iContext;
    }

    @Override
    public Session getHibSession() {
        if (this.iHibSession == null) {
            this.iHibSession = new _RootDAO().getSession();
            if (this.iCacheMode != null) {
                this.iHibSession.setCacheMode(this.iCacheMode);
            }
        }
        return this.iHibSession;
    }

    @Override
    public void close() {
    }

    @Override
    public String getOptinalParameter(String name, String defaultValue) {
        String ret = this.getParameter(name);
        return ret != null ? ret : defaultValue;
    }

    @Override
    public String getRequiredParameter(String name) {
        String ret = this.getParameter(name);
        if (ret == null) {
            throw new IllegalArgumentException("Parameter '" + name + "' was not provided.");
        }
        return ret;
    }

    @Override
    public Integer getOptinalParameterInteger(String name, Integer defaultValue) {
        String ret = this.getParameter(name);
        if (ret != null) {
            try {
                return Integer.valueOf(ret);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Parameter '" + name + "' must be an integer.");
            }
        }
        return defaultValue;
    }

    @Override
    public Integer getRequiredParameterInteger(String name) {
        String ret = this.getParameter(name);
        if (ret == null) {
            throw new IllegalArgumentException("Parameter '" + name + "' was not provided.");
        }
        try {
            return Integer.valueOf(ret);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Parameter '" + name + "' must be an integer.");
        }
    }

    @Override
    public Long getOptinalParameterLong(String name, Long defaultValue) {
        String ret = this.getParameter(name);
        if (ret != null) {
            try {
                return Long.valueOf(ret);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Parameter '" + name + "' must be a long.");
            }
        }
        return defaultValue;
    }

    @Override
    public Long getRequiredParameterLong(String name) {
        String ret = this.getParameter(name);
        if (ret == null) {
            throw new IllegalArgumentException("Parameter '" + name + "' was not provided.");
        }
        try {
            return Long.valueOf(ret);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Parameter '" + name + "' must be a long.");
        }
    }

    @Override
    public Boolean getOptinalParameterBoolean(String name, Boolean defaultValue) {
        String ret = this.getParameter(name);
        if (ret != null) {
            return "true".equalsIgnoreCase(ret) || "1".equalsIgnoreCase(ret);
        }
        return defaultValue;
    }

    @Override
    public Boolean getRequiredParameterBoolean(String name) {
        String ret = this.getParameter(name);
        if (ret == null) {
            throw new IllegalArgumentException("Parameter '" + name + "' was not provided.");
        }
        return "true".equalsIgnoreCase(ret) || "1".equalsIgnoreCase(ret);
    }
}

