/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import jakarta.activation.DataSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.Email;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InquiryForm;
import org.unitime.timetable.model.ContactCategory;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.ContactCategoryDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;

@Action(value="inquiry", results={@Result(name={"display"}, type="tiles", location="inquiry.tiles"), @Result(name={"submit"}, type="redirect", location="/selectPrimaryRole.action")})
@TilesDefinition(name="inquiry.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Contact Us"), @TilesPutAttribute(name="body", value="/user/inquiry.jsp"), @TilesPutAttribute(name="checkRole", value="false")})
public class InquiryAction
extends UniTimeAction<InquiryForm> {
    private static final long serialVersionUID = -3667385823477363659L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String op2;
    protected String deleteFile;
    protected Integer deleteId;
    private String nameFormat = null;

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    public String getDeleteFile() {
        return this.deleteFile;
    }

    public void setDeleteFile(String deleteFile) {
        this.deleteFile = deleteFile;
    }

    public Integer getDeleteId() {
        return this.deleteId;
    }

    public void setDeleteId(Integer deleteId) {
        this.deleteId = deleteId;
    }

    public String execute() throws Exception {
        HashMap<String, Attachment> files;
        if (this.form == null) {
            this.form = new InquiryForm();
        }
        this.sessionContext.checkPermission(Right.Inquiry);
        if (this.op == null) {
            this.op = ((InquiryForm)this.form).getOp();
        }
        if (this.op == null || this.op.isEmpty()) {
            this.op = this.op2;
        }
        ((InquiryForm)this.form).setNoRole(!this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.HasRole));
        if (this.op == null) {
            this.request.getSession().removeAttribute("ContactUsFiles");
        }
        if (MSG.actionInquiryCancel().equals(this.op) || MSG.actionInquiryBack().equals(this.op)) {
            this.request.getSession().removeAttribute("ContactUsFiles");
            return "submit";
        }
        if (MSG.actionAddRecipient().equals(this.op)) {
            if (((InquiryForm)this.form).getPuid() != null && ((InquiryForm)this.form).getPuid().length() > 0) {
                TimetableManager mgr = TimetableManager.findByExternalId(((InquiryForm)this.form).getPuid());
                if (mgr != null && mgr.getEmailAddress() != null && !mgr.getEmailAddress().isEmpty()) {
                    ((InquiryForm)this.form).addToCarbonCopyName(mgr.getEmailAddress(), mgr.getName(this.getNameFormat()));
                } else {
                    this.addFieldError("form.puid", MSG.errorInquiryInvalidRecipientAddress());
                }
                ((InquiryForm)this.form).setPuid(null);
            } else {
                this.addFieldError("form.puid", MSG.errorInquiryInvalidRecipientAddress());
            }
        }
        if (((InquiryForm)this.form).getFile() != null && ((InquiryForm)this.form).getFileFileName() != null) {
            files = (HashMap<String, Attachment>)this.request.getSession().getAttribute("ContactUsFiles");
            if (files == null) {
                files = new HashMap<String, Attachment>();
                this.request.getSession().setAttribute("ContactUsFiles", files);
            }
            files.put(((InquiryForm)this.form).getFileFileName(), new Attachment(((InquiryForm)this.form).getFile(), ((InquiryForm)this.form).getFileFileName(), ((InquiryForm)this.form).getFileContentType()));
        }
        if (this.deleteFile != null && !this.deleteFile.isEmpty() && (files = (Map)this.request.getSession().getAttribute("ContactUsFiles")) != null) {
            files.remove(this.request.getParameter("deleteFile"));
        }
        if (this.deleteId != null) {
            try {
                ((InquiryForm)this.form).removeCarbonCopy(this.deleteId);
                ((InquiryForm)this.form).setPuid(null);
            }
            catch (Exception e) {
                this.addFieldError("form.puid", MSG.errorInquiryInvalidAddress());
            }
        }
        if (MSG.actionInquirySubmit().equals(this.op)) {
            ((InquiryForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                Map files2;
                List<? extends UserQualifier> sg;
                List<? extends UserQualifier> depts;
                Object mail = ((InquiryForm)this.form).getMessage();
                mail = (String)mail + "\r\n";
                mail = (String)mail + "\r\n";
                mail = (String)mail + MSG.emailInquiryUserInfoSection() + "\r\n";
                mail = (String)mail + MSG.propUserName() + " " + this.sessionContext.getUser().getName() + "\r\n";
                mail = (String)mail + MSG.propLogin() + " " + this.sessionContext.getUser().getUsername() + "\r\n";
                mail = (String)mail + MSG.propertyEmail() + " " + this.sessionContext.getUser().getEmail() + "\r\n";
                mail = (String)mail + MSG.propertyRole() + " " + String.valueOf(this.sessionContext.getUser().getCurrentAuthority()) + "\r\n";
                List<? extends UserQualifier> sessions = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session");
                if (!sessions.isEmpty()) {
                    mail = (String)mail + MSG.propAcademicSession() + " " + ((Qualifiable)sessions.get(0)).getQualifierLabel() + "\r\n";
                }
                if (!(depts = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Department")).isEmpty()) {
                    mail = (String)mail + MSG.propDepartments() + " " + String.valueOf(depts) + "\r\n";
                }
                if (!(sg = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("SolverGroup")).isEmpty()) {
                    mail = (String)mail + MSG.propSolverGroups() + " " + String.valueOf(sg) + "\r\n";
                }
                mail = (String)mail + "\r\n";
                mail = (String)mail + "\r\n";
                mail = (String)mail + MSG.emailInquiryApplicationInfoSection() + "\r\n";
                mail = (String)mail + MSG.propVersion() + " " + Constants.getVersion() + " (" + Constants.getReleaseDate() + ")\r\n";
                mail = (String)mail + MSG.propTimeStamp() + " " + String.valueOf(new Date());
                EventContact c = EventContact.findByExternalUniqueId(this.sessionContext.getUser().getExternalUserId());
                Email email = Email.createEmail();
                email.setSubject(MSG.emailInquirySubject(((InquiryForm)this.form).getTypeMsg(((InquiryForm)this.form).getType()), ((InquiryForm)this.form).getSubject()));
                email.setText((String)mail);
                if (!((InquiryForm)this.form).getCarbonCopy().isEmpty()) {
                    for (int i = 0; i < ((InquiryForm)this.form).getCarbonCopy().size(); ++i) {
                        email.addRecipientCC(((InquiryForm)this.form).getCarbonCopy(i), ((InquiryForm)this.form).getCarbonCopyName(i));
                    }
                }
                ContactCategory cc = (ContactCategory)ContactCategoryDAO.getInstance().get(((InquiryForm)this.form).getType());
                Object replyTo = null;
                String replyToName = null;
                if (cc != null && cc.getEmail() != null && !cc.getEmail().isEmpty()) {
                    String suffix = ApplicationProperty.EmailDefaultAddressSuffix.value();
                    for (String address : cc.getEmail().split("[\n,]")) {
                        if (address.trim().isEmpty()) continue;
                        if (suffix != null && address.indexOf(64) < 0) {
                            email.addRecipient(address.trim() + suffix, null);
                            if (replyTo != null) continue;
                            replyTo = address.trim() + suffix;
                            continue;
                        }
                        email.addRecipient(address.trim(), null);
                        if (replyTo != null) continue;
                        replyTo = address.trim();
                    }
                } else if (ApplicationProperty.EmailInquiryAddress.value() != null) {
                    email.addRecipient(ApplicationProperty.EmailInquiryAddress.value(), ApplicationProperty.EmailInquiryAddressName.value());
                    replyTo = ApplicationProperty.EmailInquiryAddress.value();
                    replyToName = ApplicationProperty.EmailInquiryAddressName.value();
                } else {
                    email.addNotify();
                }
                if (this.sessionContext != null && this.sessionContext.isAuthenticated() && this.sessionContext.getUser().getEmail() != null) {
                    email.setReplyTo(this.sessionContext.getUser().getEmail(), this.sessionContext.getUser().getName());
                } else if (replyTo != null) {
                    email.setReplyTo((String)replyTo, replyToName);
                }
                boolean autoreply = ApplicationProperty.EmailInquiryAutoreply.isTrue();
                if (!autoreply) {
                    if (this.sessionContext.getUser().getEmail() != null && !this.sessionContext.getUser().getEmail().isEmpty()) {
                        email.addRecipientCC(this.sessionContext.getUser().getEmail(), this.sessionContext.getUser().getName());
                    } else if (c != null && c.getEmailAddress() != null && !c.getEmailAddress().isEmpty()) {
                        email.addRecipientCC(c.getEmailAddress(), c.getName());
                    } else {
                        email.addRecipientCC(this.sessionContext.getUser().getUsername() + ApplicationProperty.EmailInquiryAddressSuffix.value(), this.sessionContext.getUser().getName());
                    }
                }
                if ((files2 = (Map)this.request.getSession().getAttribute("ContactUsFiles")) != null) {
                    for (Attachment attachment : files2.values()) {
                        email.addAttachment(attachment);
                    }
                    this.request.getSession().removeAttribute("ContactUsFiles");
                }
                email.send();
                if (autoreply) {
                    try {
                        mail = MSG.emailInquiryCofirmation() + "\r\n\r\n";
                        if (ApplicationProperty.EmailSenderName.value() != null) {
                            mail = (String)mail + MSG.emailInquiryCofirmationThankYou(ApplicationProperty.EmailSenderName.value()) + "\r\n\r\n";
                        }
                        mail = (String)mail + MSG.emailInquiryBeginSection(((InquiryForm)this.form).getTypeMsg(((InquiryForm)this.form).getType()), ((InquiryForm)this.form).getSubject()) + "\r\n" + ((InquiryForm)this.form).getMessage() + "\r\n" + MSG.emailInquiryEndSection();
                        email = Email.createEmail();
                        email.setSubject("RE: " + MSG.emailInquirySubject(((InquiryForm)this.form).getTypeMsg(((InquiryForm)this.form).getType()), ((InquiryForm)this.form).getSubject()));
                        email.setText((String)mail);
                        if (this.sessionContext.getUser().getEmail() != null && !this.sessionContext.getUser().getEmail().isEmpty()) {
                            email.addRecipient(this.sessionContext.getUser().getEmail(), this.sessionContext.getUser().getName());
                        } else if (c != null && c.getEmailAddress() != null && !c.getEmailAddress().isEmpty()) {
                            email.addRecipient(c.getEmailAddress(), c.getName());
                        } else {
                            email.addRecipient(this.sessionContext.getUser().getUsername() + ApplicationProperty.EmailInquiryAddressSuffix.value(), this.sessionContext.getUser().getName());
                        }
                        if (replyTo != null) {
                            email.setReplyTo((String)replyTo, replyToName);
                        }
                        email.send();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ((InquiryForm)this.form).setOp("Sent");
                return "display";
            }
        }
        LookupTables.setupTimetableManagers(this.request);
        ((InquiryForm)this.form).updateMessage();
        return "display";
    }

    public String getNameFormat() {
        if (this.nameFormat == null) {
            this.nameFormat = UserProperty.NameFormat.get(this.sessionContext.getUser());
        }
        return this.nameFormat;
    }

    public Collection<String> getAttachedFiles() {
        Map files = (Map)this.request.getSession().getAttribute("ContactUsFiles");
        if (files == null) {
            return null;
        }
        return files.keySet();
    }

    public Long getAttachedFileSize(String name) {
        Map files = (Map)this.request.getSession().getAttribute("ContactUsFiles");
        if (files == null) {
            return null;
        }
        Attachment at = (Attachment)files.get(name);
        if (at == null) {
            return null;
        }
        return at.getSize();
    }

    static class Attachment
    implements DataSource,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iName;
        private byte[] iData;
        private String iContentType;

        public Attachment(File file, String name, String contentType) throws IOException {
            this.iData = FileUtils.readFileToByteArray((File)file);
            this.iName = name;
            this.iContentType = contentType;
        }

        public String getContentType() {
            return this.iContentType;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.iData);
        }

        public String getName() {
            return this.iName;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public Long getSize() {
            return this.iData.length;
        }
    }
}

