/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.ExamChangesForm;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.PdfWebTable;

@Action(value="examChanges", results={@Result(name={"showReport"}, type="tiles", location="examChanges.tiles")})
@TilesDefinition(name="examChanges.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Examination Assignment Changes"), @TilesPutAttribute(name="body", value="/exam/changes.jsp"), @TilesPutAttribute(name="showSolverWarnings", value="exams")})
public class ExamChangesAction
extends UniTimeAction<ExamChangesForm> {
    private static final long serialVersionUID = -1849884878783974335L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);

    public String execute() throws Exception {
        this.sessionContext.checkPermission(Right.ExaminationAssignmentChanges);
        ExamSolverProxy solver = this.getExaminationSolverService().getSolver();
        if (this.form == null) {
            this.form = new ExamChangesForm();
            ((ExamChangesForm)this.form).reset();
            if (solver != null) {
                ((ExamChangesForm)this.form).setExamType(solver.getExamTypeId());
            }
        }
        if (((ExamChangesForm)this.form).getOp() != null) {
            this.op = ((ExamChangesForm)this.form).getOp();
        }
        if (MSG.actionExportPdf().equals(this.op) || MSG.actionExportCsv().equals(this.op) || MSG.buttonApply().equals(this.op)) {
            ((ExamChangesForm)this.form).save(this.sessionContext);
        } else if (MSG.buttonRefresh().equals(this.op)) {
            ((ExamChangesForm)this.form).reset();
            if (solver != null) {
                ((ExamChangesForm)this.form).setExamType(solver.getExamTypeId());
            }
        }
        ((ExamChangesForm)this.form).load(this.sessionContext);
        ((ExamChangesForm)this.form).setNoSolver(solver == null);
        Collection<ExamAssignmentInfo[]> changes = null;
        if (((ExamChangesForm)this.form).getSubjectArea() != null && ((ExamChangesForm)this.form).getSubjectArea() != 0L && ((ExamChangesForm)this.form).getExamType() != null && solver != null) {
            if (ExamChangesForm.ExamChange.Initial.name().equals(((ExamChangesForm)this.form).getChangeType())) {
                changes = solver.getChangesToInitial(((ExamChangesForm)this.form).getSubjectArea());
            } else if (ExamChangesForm.ExamChange.Best.name().equals(((ExamChangesForm)this.form).getChangeType())) {
                changes = solver.getChangesToBest(((ExamChangesForm)this.form).getSubjectArea());
            } else {
                changes = new Vector<ExamAssignmentInfo[]>();
                List<Exam> exams = null;
                exams = ((ExamChangesForm)this.form).getSubjectArea() < 0L ? Exam.findAll(solver.getSessionId(), solver.getExamTypeId()) : Exam.findExamsOfSubjectArea(((ExamChangesForm)this.form).getSubjectArea(), solver.getExamTypeId());
                block0: for (Exam exam : exams) {
                    ExamAssignment assignment = solver.getAssignment(exam.getUniqueId());
                    if (assignment == null && exam.getAssignedPeriod() == null) continue;
                    if (assignment == null || exam.getAssignedPeriod() == null) {
                        changes.add(new ExamAssignmentInfo[]{new ExamAssignmentInfo(exam), solver.getAssignmentInfo(exam.getUniqueId())});
                        continue;
                    }
                    if (!exam.getAssignedPeriod().getUniqueId().equals(assignment.getPeriodId())) {
                        changes.add(new ExamAssignmentInfo[]{new ExamAssignmentInfo(exam), solver.getAssignmentInfo(exam.getUniqueId())});
                        continue;
                    }
                    if (exam.getAssignedRooms().size() != (assignment.getRooms() == null ? 0 : assignment.getRooms().size())) {
                        changes.add(new ExamAssignmentInfo[]{new ExamAssignmentInfo(exam), solver.getAssignmentInfo(exam.getUniqueId())});
                        continue;
                    }
                    for (Location location : exam.getAssignedRooms()) {
                        if (assignment.hasRoom(location.getUniqueId())) continue;
                        changes.add(new ExamAssignmentInfo[]{new ExamAssignmentInfo(exam), solver.getAssignmentInfo(exam.getUniqueId())});
                        continue block0;
                    }
                }
            }
        }
        WebTable.setOrder(this.sessionContext, "examChanges.ord", this.request.getParameter("ord"), 1);
        PdfWebTable table = this.getTable(Format.html, changes);
        if (MSG.actionExportPdf().equals(this.op) && table != null) {
            ExportUtils.exportPDF(this.getTable(Format.pdf, changes), WebTable.getOrder(this.sessionContext, "examChanges.ord"), this.response, "changes");
            return null;
        }
        if (MSG.actionExportCsv().equals(this.op) && table != null) {
            ExportUtils.exportCSV(this.getTable(Format.csv, changes), WebTable.getOrder(this.sessionContext, "examChanges.ord"), this.response, "changes");
            return null;
        }
        if (table != null) {
            ((ExamChangesForm)this.form).setTable(table.printTable(WebTable.getOrder(this.sessionContext, "examChanges.ord")), 9, changes.size());
        }
        if (this.request.getParameter("backId") != null) {
            this.request.setAttribute("hash", (Object)this.request.getParameter("backId"));
        }
        LookupTables.setupExamTypes(this.request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable);
        return "showReport";
    }

    public PdfWebTable getTable(Format format, Collection<ExamAssignmentInfo[]> changes) {
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        String nl = format == Format.html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(9, MSG.sectExaminationAssingmentChanges(), "examChanges.action?ord=%%", new String[]{((ExamChangesForm)this.form).getShowSections() ? MSG.colOwner() : MSG.colExamination(), MSG.colPeriod(), MSG.colRoom(), MSG.colSeatingType().replace("\n", nl), MSG.colStudents(), MSG.colInstructor(), MSG.conflictDirect(), MSG.conflictMoreThanTwoADay(), MSG.conflictBackToBack()}, new String[]{"left", "left", "left", "center", "right", "left", "right", "right", "right"}, new boolean[]{true, true, true, true, false, true, false, false, false});
        table.setRowStyle("white-space:nowrap");
        try {
            for (ExamAssignmentInfo[] change : changes) {
                Object btbStr;
                Object m2dStr;
                Object dcStr;
                ExamAssignmentInfo old = change[((ExamChangesForm)this.form).getReverse() ? 1 : 0];
                ExamAssignmentInfo exam = change[((ExamChangesForm)this.form).getReverse() ? 0 : 1];
                Object period = "";
                if (ToolBox.equals((Object)old.getPeriodId(), (Object)exam.getPeriodId())) {
                    period = format == Format.html ? exam.getPeriodAbbreviationWithPref() : exam.getPeriodAbbreviation();
                } else if (format == Format.html) {
                    period = old.getPeriodId() == null ? "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>" + MSG.notAssigned() + "</i></font>" : old.getPeriodAbbreviationWithPref();
                    period = (String)period + " &rarr; ";
                    period = (String)period + (String)(exam.getPeriodId() == null ? "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>" + MSG.notAssigned() + "</i></font>" : exam.getPeriodAbbreviationWithPref());
                } else if (format == Format.pdf) {
                    period = old.getPeriodId() == null ? "@@ITALIC " + MSG.notAssigned() + " @@END_ITALIC" : old.getPeriodAbbreviation();
                    period = (String)period + " -> ";
                    period = (String)period + (String)(exam.getPeriodId() == null ? "@@ITALIC " + MSG.notAssigned() + " @@END_ITALIC " : exam.getPeriodAbbreviation());
                } else {
                    period = old.getPeriodId() == null ? MSG.notAssigned() : old.getPeriodAbbreviation();
                    period = (String)period + " -> ";
                    period = (String)period + (exam.getPeriodId() == null ? MSG.notAssigned() : exam.getPeriodAbbreviation());
                }
                Object room = "";
                if (ToolBox.equals(old.getRooms(), exam.getRooms())) {
                    room = format == Format.html ? exam.getRoomsNameWithPref(", ") : exam.getRoomsName(", ");
                } else if (exam.getMaxRooms() > 0) {
                    if (format == Format.html) {
                        room = (String)room + "<table border='0'><tr><td valign='middle'>";
                        room = (String)room + (String)(old.getPeriodId() == null ? "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>" + MSG.notAssigned() + "</i></font>" : old.getRoomsNameWithPref("<br>"));
                        room = (String)room + "</td><td valign='middle'>&rarr;</td><td valign='middle'>";
                        room = (String)room + (String)(exam.getPeriodId() == null ? "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>" + MSG.notAssigned() + "</i></font>" : exam.getRoomsNameWithPref("<br>"));
                        room = (String)room + "</td></tr></table>";
                    } else if (format == Format.pdf) {
                        room = old.getPeriodId() == null ? "@@ITALIC " + MSG.notAssigned() + " @@END_ITALIC" : old.getRoomsName(", ");
                        room = (String)room + " -> ";
                        room = (String)room + (String)(exam.getPeriodId() == null ? "@@ITALIC " + MSG.notAssigned() + " @@END_ITALIC " : exam.getRoomsName(", "));
                    } else {
                        room = old.getPeriodId() == null ? MSG.notAssigned() : old.getRoomsName(", ");
                        room = (String)room + " -> ";
                        room = (String)room + (exam.getPeriodId() == null ? MSG.notAssigned() : exam.getRoomsName(", "));
                    }
                }
                int xdc = exam.getNrDirectConflicts();
                int dc = xdc - old.getNrDirectConflicts();
                Object object = xdc <= 0 ? "" : (dcStr = format == Format.html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + xdc + "</font>" : String.valueOf(xdc));
                if (format == Format.html && dc < 0) {
                    dcStr = (String)dcStr + "<font color='" + PreferenceLevel.prolog2color("R") + "'> (" + dc + ")</font>";
                }
                if (format == Format.html && dc > 0) {
                    dcStr = (String)dcStr + "<font color='" + PreferenceLevel.prolog2color("P") + "'> (+" + dc + ")</font>";
                }
                if (format != Format.html && dc < 0) {
                    dcStr = (String)dcStr + " (" + dc + ")";
                }
                if (format != Format.html && dc > 0) {
                    dcStr = (String)dcStr + " (+" + dc + ")";
                }
                int xm2d = exam.getNrMoreThanTwoConflicts();
                int m2d = exam.getNrMoreThanTwoConflicts() - old.getNrMoreThanTwoConflicts();
                Object object2 = xm2d <= 0 ? "" : (m2dStr = format == Format.html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + xm2d + "</font>" : String.valueOf(xm2d));
                if (format == Format.html && m2d < 0) {
                    m2dStr = (String)m2dStr + "<font color='" + PreferenceLevel.prolog2color("-2") + "'> (" + m2d + ")</font>";
                }
                if (format == Format.html && m2d > 0) {
                    m2dStr = (String)m2dStr + "<font color='" + PreferenceLevel.prolog2color("2") + "'> (+" + m2d + ")</font>";
                }
                if (format != Format.html && m2d < 0) {
                    m2dStr = (String)m2dStr + " (" + m2d + ")";
                }
                if (format != Format.html && m2d > 0) {
                    m2dStr = (String)m2dStr + " (+" + m2d + ")";
                }
                int xbtb = exam.getNrBackToBackConflicts();
                int btb = exam.getNrBackToBackConflicts() - old.getNrBackToBackConflicts();
                int dbtb = exam.getNrDistanceBackToBackConflicts() - old.getNrDistanceBackToBackConflicts();
                Object object3 = xbtb <= 0 ? "" : (btbStr = format == Format.html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + xbtb + "</font>" : String.valueOf(xbtb));
                if (format == Format.html) {
                    if (btb < 0) {
                        btbStr = (String)btbStr + "<font color='" + PreferenceLevel.prolog2color("-1") + "'> (" + btb + "</font>";
                    } else if (btb > 0) {
                        btbStr = (String)btbStr + "<font color='" + PreferenceLevel.prolog2color("1") + "'> (+" + btb + "</font>";
                    } else if (dbtb != 0) {
                        btbStr = (String)btbStr + " (" + String.valueOf(btb);
                    }
                    if (dbtb < 0) {
                        btbStr = (String)btbStr + "<font color='" + PreferenceLevel.prolog2color("-1") + "'> " + MSG.prefixDistanceConclict() + dbtb + "</font>";
                    }
                    if (dbtb > 0) {
                        btbStr = (String)btbStr + "<font color='" + PreferenceLevel.prolog2color("1") + "'> " + MSG.prefixDistanceConclict() + "+" + dbtb + "</font>";
                    }
                    if (btb < 0) {
                        btbStr = (String)btbStr + "<font color='" + PreferenceLevel.prolog2color("-1") + "'>)</font>";
                    } else if (btb > 0) {
                        btbStr = (String)btbStr + "<font color='" + PreferenceLevel.prolog2color("1") + "'>)</font>";
                    } else if (dbtb != 0) {
                        btbStr = (String)btbStr + ")";
                    }
                } else {
                    if (btb < 0) {
                        btbStr = (String)btbStr + " (" + btb;
                    } else if (btb > 0) {
                        btbStr = (String)btbStr + " (+" + btb;
                    } else if (dbtb != 0) {
                        btbStr = (String)btbStr + " (" + String.valueOf(btb);
                    }
                    if (dbtb < 0) {
                        btbStr = (String)btbStr + " " + MSG.prefixDistanceConclict() + dbtb;
                    }
                    if (dbtb > 0) {
                        btbStr = (String)btbStr + " " + MSG.prefixDistanceConclict() + "+" + dbtb;
                    }
                    if (btb < 0) {
                        btbStr = (String)btbStr + ")";
                    } else if (btb > 0) {
                        btbStr = (String)btbStr + ")";
                    } else if (dbtb != 0) {
                        btbStr = (String)btbStr + ")";
                    }
                }
                table.addLine("onClick=\"showGwtDialog('" + MSG.dialogExamAssign() + "', 'examInfo.action?examId=" + exam.getExamId() + "','900','90%');\"", new String[]{(String)(format == Format.html ? "<a name='" + exam.getExamId() + "'>" : "") + (((ExamChangesForm)this.form).getShowSections() ? exam.getSectionName(nl) : exam.getExamName()) + (format == Format.html ? "</a>" : ""), period, room, 0 == exam.getSeatingType() ? MSG.seatingNormal() : MSG.seatingExam(), String.valueOf(exam.getNrStudents()), exam.getInstructorName(", "), dcStr, m2dStr, btbStr}, new Comparable[]{exam, exam.getPeriodId() == null ? old.getPeriodOrd() : exam.getPeriodOrd(), exam.getPeriodId() == null ? "0" + old.getRoomsName(":") : exam.getRoomsName(":"), Integer.valueOf(exam.getSeatingType()), Integer.valueOf(exam.getNrStudents()), exam.getInstructorName(":"), Integer.valueOf(dc), Integer.valueOf(m2d), Integer.valueOf(btb)}, exam.getExamId().toString());
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.addLine(new String[]{"<font color='red'>" + MSG.error(e.getMessage()) + "</font>"}, null);
        }
        return table;
    }

    private static enum Format {
        html,
        csv,
        pdf;

    }
}

