/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Collection;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.ExamChangesForm;
import org.unitime.timetable.form.ExamReportForm;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.PdfWebTable;

@Action(value="assignedExams", results={@Result(name={"showReport"}, type="tiles", location="assignedExams.tiles")})
@TilesDefinition(name="assignedExams.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Assigned Examinations"), @TilesPutAttribute(name="body", value="/exam/assigned.jsp"), @TilesPutAttribute(name="showSolverWarnings", value="exams")})
public class AssignedExamsAction
extends UniTimeAction<ExamReportForm> {
    private static final long serialVersionUID = -2989357391696758181L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);

    public String execute() throws Exception {
        this.sessionContext.checkPermission(Right.AssignedExaminations);
        ExamSolverProxy solver = this.getExaminationSolverService().getSolver();
        if (this.form == null) {
            this.form = new ExamChangesForm();
            ((ExamReportForm)this.form).reset();
            if (solver != null) {
                ((ExamReportForm)this.form).setExamType(solver.getExamTypeId());
            }
        }
        if (((ExamReportForm)this.form).getOp() != null) {
            this.op = ((ExamReportForm)this.form).getOp();
        }
        if (MSG.actionExportPdf().equals(this.op) || MSG.actionExportCsv().equals(this.op) || MSG.buttonApply().equals(this.op)) {
            ((ExamReportForm)this.form).save(this.sessionContext);
        } else if (MSG.buttonRefresh().equals(this.op)) {
            ((ExamReportForm)this.form).reset();
            if (solver != null) {
                ((ExamReportForm)this.form).setExamType(solver.getExamTypeId());
            }
        }
        ((ExamReportForm)this.form).load(this.sessionContext);
        Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
        RoomAvailability.setAvailabilityWarning(this.request, session, ((ExamReportForm)this.form).getExamType(), true, false);
        Collection<ExamAssignmentInfo> assignedExams = null;
        if (((ExamReportForm)this.form).getSubjectArea() != null && ((ExamReportForm)this.form).getSubjectArea() != 0L && ((ExamReportForm)this.form).getExamType() != null) {
            assignedExams = solver != null && solver.getExamTypeId().equals(((ExamReportForm)this.form).getExamType()) ? solver.getAssignedExams(((ExamReportForm)this.form).getSubjectArea()) : Exam.findAssignedExams(session.getUniqueId(), ((ExamReportForm)this.form).getSubjectArea(), ((ExamReportForm)this.form).getExamType());
        }
        WebTable.setOrder(this.sessionContext, "assignedExams.ord", this.request.getParameter("ord"), 1);
        PdfWebTable table = this.getTable(true, false, assignedExams);
        if (MSG.actionExportPdf().equals(this.op) && table != null) {
            ExportUtils.exportPDF(this.getTable(false, true, assignedExams), WebTable.getOrder(this.sessionContext, "assignedExams.ord"), this.response, "assigned");
            return null;
        }
        if (MSG.actionExportCsv().equals(this.op) && table != null) {
            ExportUtils.exportCSV(this.getTable(false, false, assignedExams), WebTable.getOrder(this.sessionContext, "assignedExams.ord"), this.response, "assigned");
            return null;
        }
        if (table != null) {
            ((ExamReportForm)this.form).setTable(table.printTable(WebTable.getOrder(this.sessionContext, "assignedExams.ord")), 10, assignedExams.size());
        }
        if (this.request.getParameter("backId") != null) {
            this.request.setAttribute("hash", (Object)this.request.getParameter("backId"));
        }
        LookupTables.setupExamTypes(this.request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable);
        return "showReport";
    }

    public PdfWebTable getTable(boolean html, boolean color, Collection<ExamAssignmentInfo> exams) {
        if (exams == null || exams.isEmpty()) {
            return null;
        }
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(11, MSG.sectAssignedExaminations(), "assignedExams.action?ord=%%", new String[]{((ExamReportForm)this.form).getShowSections() ? MSG.colOwner() : MSG.colExamination(), MSG.colPeriod(), MSG.colRoom(), MSG.colSeatingType().replace("\n", nl), MSG.colExamSize(), MSG.colInstructor(), MSG.colViolatedDistributions().replace("\n", nl), MSG.conflictDirect(), MSG.conflictStudentNotAvailable(), MSG.conflictMoreThanTwoADay(), MSG.conflictBackToBack()}, new String[]{"left", "left", "left", "center", "right", "left", "left", "right", "right", "right", "right"}, new boolean[]{true, true, true, true, false, true, true, false, false, false, false});
        table.setRowStyle("white-space:nowrap");
        try {
            for (ExamAssignmentInfo exam : exams) {
                String dcStr;
                int dc = exam.getNrDirectConflicts();
                int edc = exam.getNrNotAvailableDirectConflicts();
                Object object = (dc -= edc) <= 0 ? "" : (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + dc + "</font>" : (dcStr = (String)(color ? "@@COLOR " + PreferenceLevel.prolog2color("P") + " " : "") + String.valueOf(dc)));
                String edcStr = edc <= 0 ? "" : (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + edc + "</font>" : (String)(color ? "@@COLOR " + PreferenceLevel.prolog2color("P") + " " : "") + String.valueOf(edc));
                int m2d = exam.getNrMoreThanTwoConflicts();
                String m2dStr = m2d <= 0 ? "" : (html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + m2d + "</font>" : (String)(color ? "@@COLOR " + PreferenceLevel.prolog2color("2") + " " : "") + String.valueOf(m2d));
                int btb = exam.getNrBackToBackConflicts();
                int dbtb = exam.getNrDistanceBackToBackConflicts();
                String btbStr = btb <= 0 && dbtb <= 0 ? "" : (html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + btb + (String)(dbtb > 0 ? " (" + MSG.prefixDistanceConclict() + dbtb + ")" : "") + "</font>" : (String)(color ? "@@COLOR " + PreferenceLevel.prolog2color("1") + " " : "") + btb + (String)(dbtb > 0 ? " (" + MSG.prefixDistanceConclict() + dbtb + ")" : ""));
                Object rooms = "";
                if (exam.getRooms() != null) {
                    for (ExamRoomInfo room : exam.getRooms()) {
                        if (((String)rooms).length() > 0) {
                            rooms = (String)rooms + (html || !color ? ", " : "@@COLOR 000000 , ");
                        }
                        rooms = (String)rooms + (String)(html ? room.toString() : (String)(color ? "@@COLOR " + PreferenceLevel.prolog2color(PreferenceLevel.int2prolog(room.getPreference())) + " " : "") + room.getName());
                    }
                }
                Object distConfs = "";
                for (ExamAssignmentInfo.DistributionConflict dist : exam.getDistributionConflicts()) {
                    if (((String)distConfs).length() > 0) {
                        distConfs = (String)distConfs + (html || !color ? ", " : "@@COLOR 000000 , ");
                    }
                    distConfs = (String)distConfs + (String)(html ? dist.getTypeHtml() : (String)(color ? "@@COLOR " + PreferenceLevel.prolog2color(dist.getPreference()) + " " : "") + dist.getType());
                }
                table.addLine("onClick=\"showGwtDialog('" + MSG.dialogExamAssign() + "', 'examInfo.action?examId=" + exam.getExamId() + "','900','90%');\"", new String[]{(String)(html ? "<a name='" + exam.getExamId() + "'>" : "") + (((ExamReportForm)this.form).getShowSections() ? exam.getSectionName(nl) : exam.getExamName()) + (html ? "</a>" : ""), html ? exam.getPeriodAbbreviationWithPref() : (String)(color ? "@@COLOR " + PreferenceLevel.prolog2color(exam.getPeriodPref()) + " " : "") + exam.getPeriodAbbreviation(), rooms, 0 == exam.getSeatingType() ? MSG.seatingNormal() : MSG.seatingExam(), String.valueOf(exam.getNrStudents()), exam.getInstructorName(", "), distConfs, dcStr, edcStr, m2dStr, btbStr}, new Comparable[]{exam, exam.getPeriodOrd(), exam.getRoomsName(":"), Integer.valueOf(exam.getSeatingType()), Integer.valueOf(exam.getNrStudents()), exam.getInstructorName(":"), exam.getDistributionConflictsList(", "), Integer.valueOf(dc), Integer.valueOf(edc), Integer.valueOf(m2d), Integer.valueOf(btb)}, exam.getExamId().toString());
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.addLine(new String[]{"<font color='red'>" + MSG.error(e.getMessage()) + "</font>"}, null);
        }
        return table;
    }
}

