/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.localization.impl;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.unitime.localization.impl.POHelper;
import org.unitime.localization.impl.PageNameGenerator;
import org.unitime.localization.messages.PageNames;
import org.unitime.timetable.util.Constants;

public class ExportTranslations {
    private List<Locale> iLocales = new ArrayList<Locale>();
    private File iBaseDir;
    private String iTranslations = "Documentation/Translations";
    private File iSource;
    private Project iProject = null;
    private boolean iGeneratePageNames = false;

    public void setProject(Project project) {
        this.iProject = project;
        this.iBaseDir = project.getBaseDir();
    }

    public void setSource(String source) {
        this.iSource = new File(source);
    }

    public void setBaseDir(String baseDir) {
        this.iBaseDir = new File(baseDir);
    }

    public void setGeneratePageNames(boolean generatePageNames) {
        this.iGeneratePageNames = generatePageNames;
    }

    public Locale createLocale() {
        Locale locale = new Locale();
        this.iLocales.add(locale);
        return locale;
    }

    public void addLocale(Locale locale) {
        this.iLocales.add(locale);
    }

    public void setLocales(String locales) {
        for (String value : locales.split(",")) {
            this.addLocale(new Locale(value));
        }
    }

    public void setTranslations(String translations) {
        this.iTranslations = translations;
    }

    public void info(String message) {
        if (this.iProject != null) {
            this.iProject.log(message);
        } else {
            System.out.println("     [info] " + message);
        }
    }

    public void warn(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 1);
        } else {
            System.out.println("  [warning] " + message);
        }
    }

    public void debug(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 4);
        } else {
            System.out.println("    [debug] " + message);
        }
    }

    public void error(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 0);
        } else {
            System.out.println("    [error] " + message);
        }
    }

    public void execute() throws BuildException {
        try {
            File translations = new File(this.iBaseDir, this.iTranslations);
            this.info("Exporting translations to: " + String.valueOf(translations));
            translations.mkdirs();
            Map<String, String> pageNames = null;
            if (this.iGeneratePageNames) {
                PageNameGenerator gen = new PageNameGenerator();
                gen.setSource(this.iSource);
                gen.execute();
                pageNames = gen.getPageNames();
            } else {
                Properties p = new Properties();
                p.load(new FileInputStream(new File(this.iSource, PageNames.class.getName().replace('.', File.separatorChar) + ".properties")));
                pageNames = new HashMap<String, String>();
                for (Map.Entry<Object, Object> e : p.entrySet()) {
                    pageNames.put((String)e.getKey(), (String)e.getValue());
                }
            }
            for (Locale locale : this.iLocales) {
                this.debug("Locale " + String.valueOf(locale));
                POHelper helper = new POHelper(locale.getValue(), pageNames);
                for (POHelper.Bundle bundle : POHelper.Bundle.values()) {
                    helper.readProperties(bundle, this.iSource, locale.getValue());
                }
                helper.writePOFile(new File(translations, "UniTime" + Constants.VERSION + "_" + locale.getValue() + ".po"));
                helper.writePOTFile(new File(translations, "UniTime" + Constants.VERSION + ".pot"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("Export failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            ExportTranslations task = new ExportTranslations();
            task.setBaseDir(System.getProperty("source", "/Users/muller/git/unitime"));
            task.setSource(System.getProperty("source", "/Users/muller/git/unitime") + File.separator + "JavaSource");
            task.setLocales(System.getProperty("locale", "cs"));
            task.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Locale {
        String iValue;

        public Locale(String value) {
            this.iValue = value;
        }

        public Locale() {
            this(null);
        }

        public void setValue(String value) {
            this.iValue = value;
        }

        public String getValue() {
            return this.iValue;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

