/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.localization.impl;

import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.Messages;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;

public class ExportMessages {
    private static String array2string(String[] value) {
        Object ret = "";
        for (String s : value) {
            if (!((String)ret).isEmpty()) {
                ret = (String)ret + ",";
            }
            ret = (String)ret + s.replace(",", "\\,");
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            Class<?> clazz = Class.forName("org.unitime.localization.messages." + System.getProperty("bundle", "CourseMessages"));
            String locale = System.getProperty("locale", "cs");
            Properties properties = new Properties();
            InputStream is = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + "_" + locale + ".properties");
            if (is != null) {
                properties.load(is);
            }
            System.out.println("\"Key\",\"Default\",\"Value\"");
            for (Method method : clazz.getMethods()) {
                Constants.DefaultStringMapValue dsm;
                Constants.DefaultStringArrayValue dsa;
                Constants.DefaultStringValue ds;
                Constants.DefaultIntValue di;
                Constants.DefaultFloatValue df;
                Constants.DefaultDoubleValue dd;
                Constants.DefaultBooleanValue db;
                Messages.DefaultMessage dm = method.getAnnotation(Messages.DefaultMessage.class);
                String text = properties.getProperty(method.getName());
                if (dm != null) {
                    System.out.println("\"" + method.getName() + "\",\"" + dm.value() + "\",\"" + (text == null ? "" : text) + "\"");
                }
                if ((db = method.getAnnotation(Constants.DefaultBooleanValue.class)) != null) {
                    System.out.println("\"" + method.getName() + "\",\"" + (db.value() ? "true" : "false") + "\",\"" + (text == null ? "" : text) + "\"");
                }
                if ((dd = method.getAnnotation(Constants.DefaultDoubleValue.class)) != null) {
                    System.out.println("\"" + method.getName() + "\",\"" + dd.value() + "\",\"" + (text == null ? "" : text) + "\"");
                }
                if ((df = method.getAnnotation(Constants.DefaultFloatValue.class)) != null) {
                    System.out.println("\"" + method.getName() + "\",\"" + df.value() + "\",\"" + (text == null ? "" : text) + "\"");
                }
                if ((di = method.getAnnotation(Constants.DefaultIntValue.class)) != null) {
                    System.out.println("\"" + method.getName() + "\",\"" + di.value() + "\",\"" + (text == null ? "" : text) + "\"");
                }
                if ((ds = method.getAnnotation(Constants.DefaultStringValue.class)) != null) {
                    System.out.println("\"" + method.getName() + "\",\"" + ds.value() + "\",\"" + (text == null ? "" : text) + "\"");
                }
                if ((dsa = method.getAnnotation(Constants.DefaultStringArrayValue.class)) != null) {
                    System.out.println("\"" + method.getName() + "\",\"" + ExportMessages.array2string(dsa.value()) + "\",\"" + (text == null ? "" : text) + "\"");
                }
                if ((dsm = method.getAnnotation(Constants.DefaultStringMapValue.class)) == null) continue;
                System.out.println("\"" + method.getName() + "\",\"" + ExportMessages.array2string(dsm.value()) + "\",\"" + (text == null ? "" : text) + "\"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

