/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.jgroups.Address;
import org.jgroups.Message;

public class MessageCache {
    protected final Map<Address, Queue<Message>> map = new ConcurrentHashMap<Address, Queue<Message>>();
    protected static final Function<Address, Queue<Message>> FUNC = __ -> new ConcurrentLinkedQueue();

    public MessageCache add(Address sender, Message msg) {
        Queue<Message> list = this.map.computeIfAbsent(sender, FUNC);
        list.add(msg);
        return this;
    }

    public Collection<Message> drain(Address sender) {
        if (sender == null) {
            return null;
        }
        return this.map.remove(sender);
    }

    public MessageCache clear() {
        this.map.clear();
        return this;
    }

    public int size() {
        return this.map.values().stream().mapToInt(Collection::size).sum();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return String.format("%d message(s)", this.size());
    }
}

