/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.util.Bits;

public class UnicastHeader
extends Header {
    public static final byte DATA = 0;
    public static final byte ACK = 1;
    public static final byte SEND_FIRST_SEQNO = 2;
    public static final byte XMIT_REQ = 3;
    public static final byte CLOSE = 4;
    byte type;
    long seqno;
    short conn_id;
    boolean first;
    int timestamp;

    public UnicastHeader() {
    }

    protected UnicastHeader(byte type) {
        this.type = type;
    }

    protected UnicastHeader(byte type, long seqno) {
        this.type = type;
        this.seqno = seqno;
    }

    protected UnicastHeader(byte type, long seqno, short conn_id, boolean first) {
        this.type = type;
        this.seqno = seqno;
        this.conn_id = conn_id;
        this.first = first;
    }

    @Override
    public short getMagicId() {
        return 100;
    }

    @Override
    public Supplier<? extends Header> create() {
        return UnicastHeader::new;
    }

    public static UnicastHeader createDataHeader(long seqno, short conn_id, boolean first) {
        return new UnicastHeader(0, seqno, conn_id, first);
    }

    public static UnicastHeader createAckHeader(long seqno, short conn_id, int timestamp) {
        return new UnicastHeader(1, seqno, conn_id, false).timestamp(timestamp);
    }

    public static UnicastHeader createSendFirstSeqnoHeader(int timestamp) {
        return new UnicastHeader(2).timestamp(timestamp);
    }

    public static UnicastHeader createXmitReqHeader() {
        return new UnicastHeader(3);
    }

    public static UnicastHeader createCloseHeader(short conn_id) {
        return new UnicastHeader(4, 0L, conn_id, false);
    }

    public byte type() {
        return this.type;
    }

    public long seqno() {
        return this.seqno;
    }

    public short connId() {
        return this.conn_id;
    }

    public UnicastHeader connId(short c) {
        this.conn_id = c;
        return this;
    }

    public boolean first() {
        return this.first;
    }

    public int timestamp() {
        return this.timestamp;
    }

    public UnicastHeader timestamp(int ts) {
        this.timestamp = ts;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(UnicastHeader.type2Str(this.type)).append(", seqno=").append(this.seqno);
        sb.append(", conn_id=").append(this.conn_id);
        if (this.first) {
            sb.append(", first");
        }
        if (this.timestamp != 0) {
            sb.append(", ts=").append(this.timestamp);
        }
        return sb.toString();
    }

    public static String type2Str(byte t) {
        switch (t) {
            case 0: {
                return "DATA";
            }
            case 1: {
                return "ACK";
            }
            case 2: {
                return "SEND_FIRST_SEQNO";
            }
            case 3: {
                return "XMIT_REQ";
            }
            case 4: {
                return "CLOSE";
            }
        }
        return "<unknown>";
    }

    @Override
    public final int serializedSize() {
        int retval = 1;
        switch (this.type) {
            case 0: {
                retval += Bits.size(this.seqno) + 2 + 1;
                break;
            }
            case 1: {
                retval += Bits.size(this.seqno) + 2 + Bits.size(this.timestamp);
                break;
            }
            case 2: {
                retval += Bits.size(this.timestamp);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                retval += 2;
            }
        }
        return retval;
    }

    public UnicastHeader copy() {
        return new UnicastHeader(this.type, this.seqno, this.conn_id, this.first);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.type);
        switch (this.type) {
            case 0: {
                Bits.writeLongCompressed(this.seqno, out);
                out.writeShort(this.conn_id);
                out.writeBoolean(this.first);
                break;
            }
            case 1: {
                Bits.writeLongCompressed(this.seqno, out);
                out.writeShort(this.conn_id);
                Bits.writeIntCompressed(this.timestamp, out);
                break;
            }
            case 2: {
                Bits.writeIntCompressed(this.timestamp, out);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                out.writeShort(this.conn_id);
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.type = in.readByte();
        switch (this.type) {
            case 0: {
                this.seqno = Bits.readLongCompressed(in);
                this.conn_id = in.readShort();
                this.first = in.readBoolean();
                break;
            }
            case 1: {
                this.seqno = Bits.readLongCompressed(in);
                this.conn_id = in.readShort();
                this.timestamp = Bits.readIntCompressed(in);
                break;
            }
            case 2: {
                this.timestamp = Bits.readIntCompressed(in);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.conn_id = in.readShort();
            }
        }
    }
}

