/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;

public class FirstSkipLimitHandler
extends AbstractLimitHandler {
    public static final FirstSkipLimitHandler INSTANCE = new FirstSkipLimitHandler();

    public String processSql(String sql, Limit limit) {
        boolean hasFirstRow = FirstSkipLimitHandler.hasFirstRow((Limit)limit);
        boolean hasMaxRows = FirstSkipLimitHandler.hasMaxRows((Limit)limit);
        if (!hasFirstRow && !hasMaxRows) {
            return sql;
        }
        StringBuilder skipFirst = new StringBuilder();
        if (hasMaxRows) {
            skipFirst.append(" first ?");
        }
        if (hasFirstRow) {
            skipFirst.append(" skip ?");
        }
        return FirstSkipLimitHandler.insertAfterSelect((String)skipFirst.toString(), (String)sql);
    }

    public final boolean supportsLimit() {
        return true;
    }

    public boolean supportsOffset() {
        return true;
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public final boolean bindLimitParametersFirst() {
        return true;
    }
}

