/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;

public class HSQLLegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public HSQLLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected void visitInsertStatementOnly(InsertSelectStatement statement) {
        if (statement.getConflictClause() == null || statement.getConflictClause().isDoNothing()) {
            super.visitInsertStatementOnly(statement);
        } else {
            this.visitInsertStatementEmulateMerge(statement);
        }
    }

    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        if (HSQLLegacySqlAstTranslator.hasNonTrivialFromClause((FromClause)statement.getFromClause())) {
            this.visitUpdateStatementEmulateMerge(statement);
        } else {
            super.visitUpdateStatementOnly(statement);
        }
    }

    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
        }
    }

    protected void visitConflictClause(ConflictClause conflictClause) {
        if (conflictClause != null && conflictClause.isDoUpdate() && conflictClause.getConstraintName() != null) {
            throw new IllegalQueryOperationException("Insert conflict 'do update' clause with constraint name is not supported");
        }
    }

    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept((SqlAstWalker)this);
    }

    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept((SqlAstWalker)this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    protected boolean supportsArrayConstructor() {
        return true;
    }

    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    protected boolean supportsRecursiveClauseArrayAndRowEmulation() {
        return false;
    }

    protected void visitRecursivePath(Expression recursivePath, int sizeEstimate) {
        if (sizeEstimate == -1) {
            super.visitRecursivePath(recursivePath, sizeEstimate);
        } else {
            this.appendSql("cast(");
            recursivePath.accept((SqlAstWalker)this);
            this.appendSql(" as varchar(");
            this.appendSql(sizeEstimate);
            this.appendSql("))");
        }
    }

    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression expression, Consumer<Expression> resultRenderer) {
        if (this.areAllResultsPlainParametersOrStringLiterals(expression)) {
            List whenFragments = expression.getWhenFragments();
            Expression firstResult = ((CaseSearchedExpression.WhenFragment)whenFragments.get(0)).getResult();
            super.visitAnsiCaseSearchedExpression(expression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(expression, resultRenderer);
        }
    }

    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression expression, Consumer<Expression> resultRenderer) {
        if (this.areAllResultsPlainParametersOrStringLiterals(expression)) {
            List whenFragments = expression.getWhenFragments();
            Expression firstResult = ((CaseSimpleExpression.WhenFragment)whenFragments.get(0)).getResult();
            super.visitAnsiCaseSimpleExpression(expression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(expression, resultRenderer);
        }
    }

    protected boolean areAllResultsPlainParametersOrStringLiterals(CaseSearchedExpression caseSearchedExpression) {
        List whenFragments = caseSearchedExpression.getWhenFragments();
        Expression firstResult = ((CaseSearchedExpression.WhenFragment)whenFragments.get(0)).getResult();
        if (this.isParameter(firstResult) && this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT || this.isStringLiteral(firstResult)) {
            for (int i = 1; i < whenFragments.size(); ++i) {
                Expression result = ((CaseSearchedExpression.WhenFragment)whenFragments.get(i)).getResult();
                if (!(this.isParameter(result) ? this.getParameterRenderingMode() != SqlAstNodeRenderingMode.DEFAULT : !this.isStringLiteral(result))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean areAllResultsPlainParametersOrStringLiterals(CaseSimpleExpression caseSimpleExpression) {
        List whenFragments = caseSimpleExpression.getWhenFragments();
        Expression firstResult = ((CaseSimpleExpression.WhenFragment)whenFragments.get(0)).getResult();
        if (this.isParameter(firstResult) && this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT || this.isStringLiteral(firstResult)) {
            for (int i = 1; i < whenFragments.size(); ++i) {
                Expression result = ((CaseSimpleExpression.WhenFragment)whenFragments.get(i)).getResult();
                if (!(this.isParameter(result) ? this.getParameterRenderingMode() != SqlAstNodeRenderingMode.DEFAULT : !this.isStringLiteral(result))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isStringLiteral(Expression expression) {
        if (expression instanceof Literal) {
            return ((Literal)expression).getJdbcMapping().getJdbcType().isStringLike();
        }
        return false;
    }

    public boolean supportsFilterClause() {
        return true;
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        if (this.getDialect().getVersion().isBefore(2)) {
            return AbstractSqlAstTranslator.LockStrategy.NONE;
        }
        return super.determineLockingStrategy(querySpec, forUpdateClause, followOnLocking);
    }

    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
        if (this.getDialect().getVersion().isBefore(2)) {
            return;
        }
        super.renderForUpdateClause(querySpec, forUpdateClause);
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.supportsOffsetFetchClause()) {
            this.assertRowsOnlyFetchClauseType(queryPart);
            this.renderOffsetFetchClause(queryPart, true);
        } else {
            this.renderLimitOffsetClause(queryPart);
        }
    }

    protected void renderSelectExpression(Expression expression) {
        this.renderSelectExpressionWithCastedOrInlinedPlainParameters(expression);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType == null || lhsExpressionType.getJdbcTypeCount() != 1) {
            this.renderComparisonStandard(lhs, operator, rhs);
            return;
        }
        switch (operator) {
            case DISTINCT_FROM: 
            case NOT_DISTINCT_FROM: {
                if (lhsExpressionType.getSingleJdbcMapping().getJdbcType() instanceof ArrayJdbcType) {
                    lhs.accept((SqlAstWalker)this);
                    this.appendSql(operator == ComparisonOperator.DISTINCT_FROM ? "<>" : "=");
                    rhs.accept((SqlAstWalker)this);
                    break;
                }
                this.render((SqlAstNode)lhs, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
                this.appendSql(operator.sqlText());
                this.render((SqlAstNode)rhs, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
                break;
            }
            default: {
                this.renderComparisonStandard(lhs, operator, rhs);
            }
        }
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion().isSameOrAfter(2, 5);
    }

    protected void visitArithmeticOperand(Expression expression) {
        this.render((SqlAstNode)expression, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
    }
}

