/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.criteria;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.instructor.criteria.InstructorSchedulingCriterion;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class OriginalInstructor
extends InstructorSchedulingCriterion {
    private boolean iMPP = false;

    @Override
    public void configure(DataProperties properties) {
        super.configure(properties);
        this.iMPP = properties.getPropertyBoolean("General.MPP", this.iMPP);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 100.0;
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
        if (this.iMPP && ((TeachingRequest.Variable)value.variable()).getInitialAssignment() != null) {
            return value.getInstructor().equals(((TeachingAssignment)((TeachingRequest.Variable)value.variable()).getInitialAssignment()).getInstructor()) ? 0.0 : 1.0;
        }
        return 0.0;
    }

    @Override
    public String getAbbreviation() {
        return "Original";
    }

    @Override
    public void getInfo(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Map<String, String> info) {
        double val = this.getValue(assignment);
        double[] bounds = this.getBounds(assignment);
        if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1]) {
            info.put(this.getName(), this.getPerc(val, bounds[0], bounds[1]) + "% (" + sDoubleFormat.format(bounds[1] - val) + ")");
        }
    }

    @Override
    public void getInfo(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Map<String, String> info, Collection<TeachingRequest.Variable> variables) {
        double val = this.getValue(assignment, variables);
        double[] bounds = this.getBounds(assignment, variables);
        if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1]) {
            info.put(this.getName(), this.getPerc(val, bounds[0], bounds[1]) + "% (" + sDoubleFormat.format(bounds[1] - val) + ")");
        }
    }
}

