/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.util.Locale;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class BasicTypeImpl<J>
extends AbstractSingleColumnStandardBasicType<J>
implements AdjustableBasicType<J> {
    public static final String EXTERNALIZED_PREFIX = "basicType";
    public static final String[] NO_REG_KEYS = ArrayHelper.EMPTY_STRING_ARRAY;
    private static int count;
    private final String name;

    public BasicTypeImpl(JavaType<J> jtd, JdbcType std) {
        super(std, jtd);
        this.name = String.format(Locale.ROOT, "%s@%s(%s,%s)", EXTERNALIZED_PREFIX, ++count, jtd.getJavaTypeClass().getName(), std.getDefaultSqlTypeCode());
    }

    @Override
    public String[] getRegistrationKeys() {
        return NO_REG_KEYS;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

