/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GetChoices {
    public static void getChoicesFile(File folder, List<List<String>> choices, String prefix) {
        File choicesFile = new File(folder, "choices.csv");
        if (choicesFile.exists()) {
            System.out.println("Reading " + choicesFile + " ...");
            try {
                List<Object> prefixes = null;
                if (choices.isEmpty()) {
                    prefixes = new ArrayList();
                    choices.add(prefixes);
                } else {
                    prefixes = choices.get(0);
                }
                prefixes.add(prefix);
                BufferedReader reader = new BufferedReader(new FileReader(choicesFile));
                String line = null;
                int idx = 1;
                while ((line = reader.readLine()) != null) {
                    List<Object> cx = null;
                    if (choices.size() <= idx) {
                        cx = new ArrayList();
                        choices.add(cx);
                    } else {
                        cx = choices.get(idx);
                    }
                    cx.add(line);
                    ++idx;
                }
                reader.close();
            }
            catch (Exception e) {
                System.err.println("Error reading file " + choicesFile + ", message: " + e.getMessage());
            }
        }
    }

    public static void getChoices(File folder, List<List<String>> choices, String prefix) {
        System.out.println("Checking " + folder + " ...");
        File[] files = folder.listFiles();
        GetChoices.getChoicesFile(folder, choices, prefix == null ? "" : prefix);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            GetChoices.getChoices(files[i], choices, (prefix == null ? "" : prefix + "/") + files[i].getName());
        }
    }

    public static void writeChoices(List<List<String>> choices, File file) {
        try {
            System.out.println("Writing " + file + " ...");
            PrintWriter writer = new PrintWriter(new FileWriter(file, false));
            for (List<String> cx : choices) {
                Iterator<String> f = cx.iterator();
                while (f.hasNext()) {
                    String s = f.next();
                    writer.print(s);
                    if (!f.hasNext()) continue;
                    writer.print(",");
                }
                writer.println();
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            System.err.println("Error writing file " + file + ", message: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            File folder = new File(args[0]);
            ArrayList<List<String>> choices = new ArrayList<List<String>>();
            GetChoices.getChoices(folder, choices, null);
            if (!choices.isEmpty()) {
                GetChoices.writeChoices(choices, new File(folder, "all-choices.csv"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

