/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cpsolver.ifs.extension.AssignedValue;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Value;

public class AssignedValueSet<T extends Value<?, T>> {
    private List<AssignedValue<T>> iSet = new ArrayList<AssignedValue<T>>();
    private int iCounter = 1;
    private String iName = null;
    private String iDescription = null;
    private Constraint<?, T> iConstraint = null;

    public AssignedValueSet() {
    }

    public AssignedValueSet(AssignedValue<T>[] assignments) {
        for (AssignedValue<T> a : assignments) {
            this.iSet.add(a);
        }
    }

    public AssignedValueSet(Collection<AssignedValue<T>> assignments) {
        for (AssignedValue<T> a : assignments) {
            this.iSet.add(a);
        }
    }

    public static <T extends Value<?, T>> AssignedValueSet<T> createAssignmentSet(Collection<AssignedValue<T>> assignments) {
        AssignedValueSet<T> set = new AssignedValueSet<T>();
        for (AssignedValue<T> a : assignments) {
            set.addAssignment(a);
        }
        return set;
    }

    public static <T extends Value<?, T>> AssignedValueSet<T> createAssignmentSetForValues(Collection<T> assignments) {
        AssignedValueSet<Value> set = new AssignedValueSet<Value>();
        for (Value a : assignments) {
            set.addAssignment(0L, a, 1.0);
        }
        return set;
    }

    public void incCounter() {
        ++this.iCounter;
    }

    public int getCounter() {
        return this.iCounter;
    }

    public List<AssignedValue<T>> getSet() {
        return this.iSet;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    public Constraint<?, T> getConstraint() {
        return this.iConstraint;
    }

    public void setConstraint(Constraint<?, T> constraint) {
        this.iConstraint = constraint;
    }

    public boolean contains(AssignedValue<T> assignment) {
        return this.iSet.contains(assignment);
    }

    public boolean contains(AssignedValueSet<T> assignmentSet) {
        return this.iSet.containsAll(assignmentSet.getSet());
    }

    public boolean contains(T value) {
        return this.iSet.contains(new AssignedValue<T>(0L, value, 1.0));
    }

    public boolean contains(Collection<AssignedValue<T>> assignments) {
        for (AssignedValue<T> a : assignments) {
            if (this.iSet.contains(a)) continue;
            return false;
        }
        return true;
    }

    public boolean containsValues(Collection<T> assignments) {
        for (Value a : assignments) {
            if (this.iSet.contains(new AssignedValue<Value>(0L, a, 1.0))) continue;
            return false;
        }
        return true;
    }

    public void addAssignment(AssignedValue<T> assignment) {
        if (!this.contains((T)assignment)) {
            this.iSet.add(assignment);
        }
    }

    public void addAssignment(long iteration, T value, double aging) {
        this.addAssignment(new AssignedValue<T>(iteration, value, aging));
    }

    public AssignedValue<T> getAssignment(T value) {
        for (AssignedValue<T> a : this.iSet) {
            if (((Value)a.getValue()).getId() != ((Value)value).getId()) continue;
            return a;
        }
        return null;
    }

    public int size() {
        return this.getSet().size();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof AssignedValueSet) {
            AssignedValueSet as = (AssignedValueSet)o;
            if (this.getName() == null && as.getName() != null) {
                return false;
            }
            if (this.getName() != null && as.getName() == null) {
                return false;
            }
            if (this.getName() != null && !this.getName().equals(as.getName())) {
                return false;
            }
            if (as.getSet().size() != this.getSet().size()) {
                return false;
            }
            return this.contains((T)as);
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            if (c.size() != this.getSet().size()) {
                return false;
            }
            return this.contains(c);
        }
        return false;
    }

    public static int xor(int a, int b) {
        return (a | b) & (~a | ~b);
    }

    public int hashCode() {
        int ret = this.getSet().size();
        for (AssignedValue<T> a : this.iSet) {
            ret = AssignedValueSet.xor(ret, a.hashCode());
        }
        return ret;
    }
}

