/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.model;

import java.util.Iterator;
import java.util.Set;
import org.cpsolver.exam.criteria.DistributionPenalty;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.model.Variable;

public class ExamDistributionConstraint
extends ConstraintWithContext<Exam, ExamPlacement, Context> {
    @Deprecated
    public static int sDistSameRoom = DistributionType.SameRoom.ordinal();
    private DistributionType iType = null;
    private boolean iHard = true;
    private int iWeight = 0;

    public ExamDistributionConstraint(long id, DistributionType type, boolean hard, int weight) {
        this.iId = id;
        this.iType = type;
        this.iHard = hard;
        this.iWeight = weight;
    }

    @Deprecated
    public ExamDistributionConstraint(long id, int type, boolean hard, int weight) {
        this.iId = id;
        this.iType = DistributionType.values()[type];
        this.iHard = hard;
        this.iWeight = weight;
    }

    public ExamDistributionConstraint(long id, String type, String pref) {
        this.iId = id;
        boolean neg = "P".equals(pref) || "2".equals(pref) || "1".equals(pref);
        for (DistributionType t : DistributionType.values()) {
            if (!t.getUniTimeReference().equals(type) || t.isUniTimeNegative() != neg) continue;
            this.iType = t;
            break;
        }
        if (this.iType == null) {
            throw new RuntimeException("Unkown type " + type);
        }
        if ("P".equals(pref) || "R".equals(pref)) {
            this.iHard = true;
        } else {
            this.iHard = false;
            this.iWeight = Integer.parseInt(pref) * Integer.parseInt(pref);
        }
    }

    public ExamDistributionConstraint(long id, String type, boolean hard, int weight) {
        this.iId = id;
        for (DistributionType t : DistributionType.values()) {
            if (!t.getReference().equals(type)) continue;
            this.iType = t;
            break;
        }
        if (this.iType == null) {
            throw new RuntimeException("Unknown type '" + type + "'.");
        }
        this.iHard = hard;
        this.iWeight = weight;
    }

    @Override
    public boolean isHard() {
        return this.iHard;
    }

    public int getWeight() {
        return this.iWeight;
    }

    public int getType() {
        return this.iType.ordinal() - 1;
    }

    public DistributionType getDistributionType() {
        return this.iType;
    }

    public String getTypeString() {
        return this.iType.getReference();
    }

    public String toString() {
        return this.getTypeString() + " (" + this.variables() + ")";
    }

    @Override
    public void computeConflicts(Assignment<Exam, ExamPlacement> assignment, ExamPlacement givenPlacement, Set<ExamPlacement> conflicts) {
        boolean before = true;
        for (Exam exam : this.variables()) {
            if (exam.equals(givenPlacement.variable())) {
                before = false;
                continue;
            }
            ExamPlacement placement = assignment.getValue(exam);
            if (placement == null || this.iType.isSatisfied(before ? placement : givenPlacement, before ? givenPlacement : placement)) continue;
            conflicts.add(placement);
        }
    }

    @Override
    public boolean inConflict(Assignment<Exam, ExamPlacement> assignment, ExamPlacement givenPlacement) {
        boolean before = true;
        for (Exam exam : this.variables()) {
            if (exam.equals(givenPlacement.variable())) {
                before = false;
                continue;
            }
            ExamPlacement placement = assignment.getValue(exam);
            if (placement == null || this.iType.isSatisfied(before ? placement : givenPlacement, before ? givenPlacement : placement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConsistent(ExamPlacement first, ExamPlacement second) {
        boolean before = this.variables().indexOf(first.variable()) < this.variables().indexOf(second.variable());
        return this.iType.isSatisfied(before ? first : second, before ? second : first);
    }

    @Deprecated
    public boolean check(ExamPlacement first, ExamPlacement second) {
        return this.iType.isSatisfied(first, second);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamDistributionConstraint)) {
            return false;
        }
        ExamDistributionConstraint c = (ExamDistributionConstraint)o;
        return this.getType() == c.getType() && this.getId() == c.getId();
    }

    public boolean isSatisfied(Assignment<Exam, ExamPlacement> assignment) {
        return this.isSatisfied(assignment, null);
    }

    public boolean isSatisfied(Assignment<Exam, ExamPlacement> assignment, ExamPlacement p) {
        return this.countViolations(assignment, p) == 0;
    }

    public int countViolations(Assignment<Exam, ExamPlacement> assignment, ExamPlacement p) {
        if (this.isHard()) {
            return 0;
        }
        if (p == null) {
            return this.countViolations(assignment);
        }
        if (this.countAssignedVariables(assignment) + (assignment.getValue((Exam)p.variable()) == null ? 1 : 0) < 2) {
            return 0;
        }
        int nrViolatedPairs = 0;
        boolean before = true;
        for (Exam other : this.variables()) {
            if (other.equals(p.variable())) {
                before = false;
                continue;
            }
            ExamPlacement otherPlacement = assignment.getValue(other);
            if (otherPlacement == null) continue;
            if (before) {
                if (this.iType.isSatisfied(otherPlacement, p)) continue;
                ++nrViolatedPairs;
                continue;
            }
            if (this.iType.isSatisfied(p, otherPlacement)) continue;
            ++nrViolatedPairs;
        }
        return nrViolatedPairs;
    }

    public int countViolations(Assignment<Exam, ExamPlacement> assignment) {
        if (this.isHard()) {
            return 0;
        }
        int violations = 0;
        for (int i = 0; i < this.variables().size() - 1; ++i) {
            ExamPlacement first = assignment.getValue((Exam)((Variable)this.variables().get(i)));
            if (first == null) continue;
            for (int j = i + 1; j < this.variables().size(); ++j) {
                ExamPlacement second = assignment.getValue((Exam)((Variable)this.variables().get(j)));
                if (second == null || this.iType.isSatisfied(first, second)) continue;
                ++violations;
            }
        }
        return violations;
    }

    public boolean isRoomRelated() {
        return this.iType.isRoomRelated();
    }

    public boolean isPeriodRelated() {
        return this.iType.isPeriodRelated();
    }

    @Override
    public Context createAssignmentContext(Assignment<Exam, ExamPlacement> assignment) {
        return new Context(assignment);
    }

    public class Context
    implements AssignmentConstraintContext<Exam, ExamPlacement> {
        private int iViolations = 0;

        public Context(Assignment<Exam, ExamPlacement> assignment) {
            this.updateCriterion(assignment);
        }

        @Override
        public void assigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement placement) {
            this.updateCriterion(assignment);
        }

        @Override
        public void unassigned(Assignment<Exam, ExamPlacement> assignment, ExamPlacement placement) {
            this.updateCriterion(assignment);
        }

        protected void updateCriterion(Assignment<Exam, ExamPlacement> assignment) {
            if (!ExamDistributionConstraint.this.isHard()) {
                ((DistributionPenalty)ExamDistributionConstraint.this.getModel().getCriterion(DistributionPenalty.class)).inc(assignment, -this.iViolations * ExamDistributionConstraint.this.getWeight(), ExamDistributionConstraint.this);
                this.iViolations = ExamDistributionConstraint.this.countViolations(assignment);
                ((DistributionPenalty)ExamDistributionConstraint.this.getModel().getCriterion(DistributionPenalty.class)).inc(assignment, this.iViolations * ExamDistributionConstraint.this.getWeight(), ExamDistributionConstraint.this);
            }
        }

        public int getViolations() {
            return this.iViolations;
        }
    }

    public static interface RoomCheck
    extends PairCheck {
        public boolean isSatisfied(ExamPlacement var1, ExamRoomPlacement var2);
    }

    public static interface PeriodCheck
    extends PairCheck {
        public boolean isSatisfied(ExamPeriod var1, ExamPeriod var2);
    }

    public static interface PairCheck {
        public boolean isSatisfied(ExamPlacement var1, ExamPlacement var2);
    }

    public static enum DistributionType {
        SameRoom("same-room", "EX_SAME_ROOM", false, new RoomCheck(){

            @Override
            public boolean isSatisfied(ExamPlacement first, ExamPlacement second) {
                return first.getRoomPlacements().containsAll(second.getRoomPlacements()) || second.getRoomPlacements().containsAll(first.getRoomPlacements());
            }

            @Override
            public boolean isSatisfied(ExamPlacement first, ExamRoomPlacement second) {
                return first.getRoomPlacements().contains(second);
            }
        }),
        DifferentRoom("different-room", "EX_SAME_ROOM", true, new RoomCheck(){

            @Override
            public boolean isSatisfied(ExamPlacement first, ExamPlacement second) {
                Iterator<ExamRoomPlacement> i = first.getRoomPlacements().iterator();
                while (i.hasNext()) {
                    if (!second.getRoomPlacements().contains(i.next())) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isSatisfied(ExamPlacement first, ExamRoomPlacement second) {
                return !first.getRoomPlacements().contains(second);
            }
        }),
        SamePeriod("same-period", "EX_SAME_PER", false, new PeriodCheck(){

            @Override
            public boolean isSatisfied(ExamPlacement first, ExamPlacement second) {
                return first.getPeriod().getIndex() == second.getPeriod().getIndex();
            }

            @Override
            public boolean isSatisfied(ExamPeriod first, ExamPeriod second) {
                return first.getIndex() == second.getIndex();
            }
        }),
        DifferentPeriod("different-period", "EX_SAME_PER", true, new PeriodCheck(){

            @Override
            public boolean isSatisfied(ExamPlacement first, ExamPlacement second) {
                return first.getPeriod().getIndex() != second.getPeriod().getIndex();
            }

            @Override
            public boolean isSatisfied(ExamPeriod first, ExamPeriod second) {
                return first.getIndex() != second.getIndex();
            }
        }),
        Precedence("precedence", "EX_PRECEDENCE", false, new PeriodCheck(){

            @Override
            public boolean isSatisfied(ExamPlacement first, ExamPlacement second) {
                return first.getPeriod().getIndex() < second.getPeriod().getIndex();
            }

            @Override
            public boolean isSatisfied(ExamPeriod first, ExamPeriod second) {
                return first.getIndex() < second.getIndex();
            }
        }),
        PrecedenceRev("precedence-rev", "EX_PRECEDENCE", true, new PeriodCheck(){

            @Override
            public boolean isSatisfied(ExamPlacement first, ExamPlacement second) {
                return first.getPeriod().getIndex() > second.getPeriod().getIndex();
            }

            @Override
            public boolean isSatisfied(ExamPeriod first, ExamPeriod second) {
                return first.getIndex() > second.getIndex();
            }
        }),
        SameDay("same-day", "EX_SAME_DAY", false, new PeriodCheck(){

            @Override
            public boolean isSatisfied(ExamPlacement first, ExamPlacement second) {
                return first.getPeriod().getDay() == second.getPeriod().getDay();
            }

            @Override
            public boolean isSatisfied(ExamPeriod first, ExamPeriod second) {
                return first.getDay() == second.getDay();
            }
        }),
        DifferentDay("different-day", "EX_SAME_DAY", true, new PeriodCheck(){

            @Override
            public boolean isSatisfied(ExamPlacement first, ExamPlacement second) {
                return first.getPeriod().getDay() != second.getPeriod().getDay();
            }

            @Override
            public boolean isSatisfied(ExamPeriod first, ExamPeriod second) {
                return first.getDay() != second.getDay();
            }
        });

        private String iReference;
        private String iUniTimeReference;
        private boolean iUniTimeNegative;
        private PairCheck iCheck;

        private DistributionType(String reference, String utReference, boolean utNegative, PairCheck check) {
            this.iReference = reference;
            this.iUniTimeReference = utReference;
            this.iUniTimeNegative = utNegative;
            this.iCheck = check;
        }

        public String getReference() {
            return this.iReference;
        }

        public boolean isSatisfied(ExamPlacement first, ExamPlacement second) {
            return this.iCheck.isSatisfied(first, second);
        }

        public boolean isRoomRelated() {
            return this.iCheck instanceof RoomCheck;
        }

        public boolean isPeriodRelated() {
            return this.iCheck instanceof PeriodCheck;
        }

        public boolean isSatisfied(ExamPeriod first, ExamPeriod second) {
            if (this.iCheck instanceof PeriodCheck) {
                return ((PeriodCheck)this.iCheck).isSatisfied(first, second);
            }
            return true;
        }

        public boolean isSatisfied(ExamPlacement first, ExamRoomPlacement second) {
            if (this.iCheck instanceof RoomCheck) {
                return ((RoomCheck)this.iCheck).isSatisfied(first, second);
            }
            return true;
        }

        public String getUniTimeReference() {
            return this.iUniTimeReference;
        }

        public boolean isUniTimeNegative() {
            return this.iUniTimeNegative;
        }
    }
}

