/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class PerturbationPenalty
extends ExamCriterion {
    private boolean iMPP = false;

    @Override
    public void configure(DataProperties properties) {
        super.configure(properties);
        this.iMPP = properties.getPropertyBoolean("General.MPP", this.iMPP);
    }

    @Override
    public String getWeightName() {
        return "Exams.PerturbationWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "perturbationWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 0.01;
    }

    public boolean isMPP() {
        return this.iMPP;
    }

    @Override
    public void getXmlParameters(Map<String, String> params) {
        params.put(this.getXmlWeightName(), String.valueOf(this.getWeight()));
        params.put("mpp", this.isMPP() ? "true" : "false");
    }

    @Override
    public void setXmlParameters(Map<String, String> params) {
        try {
            this.setWeight(Double.valueOf(params.get(this.getXmlWeightName())));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.iMPP = "true".equals(params.get("mpp"));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        if (!this.isMPP()) {
            return 0.0;
        }
        Exam exam = (Exam)value.variable();
        ExamPlacement initial = (ExamPlacement)exam.getInitialAssignment();
        if (initial == null) {
            return 0.0;
        }
        return Math.abs(initial.getPeriod().getIndex() - value.getPeriod().getIndex()) * (1 + exam.getSize());
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return this.isMPP() ? "IP:" + sDoubleFormat.format(this.getValue(assignment)) : "";
    }
}

