/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.util.Collection;
import java.util.Vector;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.security.SessionContext;

public class Navigation {
    public static String sLastDisplayedIdsSessionAttribute = SessionAttribute.NavigationLastIds.key();
    public static int sNrLevels = 3;
    public static int sInstructionalOfferingLevel = 0;
    public static int sSchedulingSubpartLevel = 1;
    public static int sClassLevel = 2;

    public static Long getNext(SessionContext context, int level, Long id) {
        int idx;
        Vector[] ids = (Vector[])context.getAttribute(SessionAttribute.NavigationLastIds);
        int n = idx = ids == null ? -1 : ids[level].indexOf(id);
        if (idx >= 0) {
            try {
                return (Long)ids[level].elementAt(idx + 1);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return -1L;
            }
        }
        return null;
    }

    public static Long getPrevious(SessionContext context, int level, Long id) {
        int idx;
        Vector[] ids = (Vector[])context.getAttribute(SessionAttribute.NavigationLastIds);
        int n = idx = ids == null ? -1 : ids[level].indexOf(id);
        if (idx >= 0) {
            try {
                return (Long)ids[level].elementAt(idx - 1);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return -1L;
            }
        }
        return null;
    }

    public static void set(SessionContext session, int level, Collection entities) {
        int i;
        Vector[] ids = (Vector[])session.getAttribute(SessionAttribute.NavigationLastIds);
        if (ids == null) {
            ids = new Vector[sNrLevels];
            for (i = 0; i < sNrLevels; ++i) {
                ids[i] = new Vector();
            }
            session.setAttribute(SessionAttribute.NavigationLastIds, (Object)ids);
        }
        for (i = level; i < sNrLevels; ++i) {
            ids[i].clear();
        }
        if (entities == null || entities.isEmpty()) {
            return;
        }
        for (Object o : entities) {
            if (o instanceof Long) {
                ids[level].add(o);
                continue;
            }
            try {
                if (o.getClass().isArray()) {
                    ids[level].add(((Object[])o)[0].getClass().getMethod("getUniqueId", new Class[0]).invoke(((Object[])o)[0], new Object[0]));
                    continue;
                }
                ids[level].add(o.getClass().getMethod("getUniqueId", new Class[0]).invoke(o, new Object[0]));
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
    }
}

