/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula.students;

import java.util.ArrayList;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.RouletteWheelSelection;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.solver.curricula.students.CurModel;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

public class CurVariableSelection
implements VariableSelection<CurVariable, CurValue> {
    RouletteWheelSelection<CurVariable> iWheel = null;

    public CurVariableSelection(DataProperties p) {
    }

    public void init(Solver<CurVariable, CurValue> solver) {
    }

    public CurVariable selectVariable(Solution<CurVariable, CurValue> solution) {
        Assignment assignment;
        CurModel m = (CurModel)solution.getModel();
        if (m.nrUnassignedVariables(assignment = solution.getAssignment()) > 0) {
            ArrayList<CurVariable> best = new ArrayList<CurVariable>();
            double bestValue = 0.0;
            for (CurVariable course : m.unassignedVariables(assignment)) {
                if (course.getCourse().isComplete((Assignment<CurVariable, CurValue>)assignment)) continue;
                double value = course.getCourse().getMaxSize() - course.getCourse().getSize((Assignment<CurVariable, CurValue>)assignment);
                if (best.isEmpty() || bestValue < value) {
                    best.clear();
                    best.add(course);
                    bestValue = value;
                    continue;
                }
                if (bestValue != value) continue;
                best.add(course);
            }
            if (!best.isEmpty()) {
                return (CurVariable)((Object)ToolBox.random(best));
            }
        }
        if (this.iWheel == null || !this.iWheel.hasMoreElements()) {
            this.iWheel = new RouletteWheelSelection();
            for (CurVariable course : m.assignedVariables(assignment)) {
                double penalty = ((CurValue)assignment.getValue((Variable)course)).toDouble((Assignment<CurVariable, CurValue>)assignment);
                if (course.getCourse().getStudents((Assignment<CurVariable, CurValue>)assignment).size() == m.getStudents().size() || penalty == 0.0) continue;
                this.iWheel.add((Object)course, penalty);
            }
        }
        return (CurVariable)((Object)this.iWheel.nextElement());
    }
}

