/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorCourseRequirementNote;
import org.unitime.timetable.model.InstructorCourseRequirementType;
import org.unitime.timetable.model.base.BaseInstructorCourseRequirement;
import org.unitime.timetable.model.dao.InstructorCourseRequirementDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="instr_crsreq")
public class InstructorCourseRequirement
extends BaseInstructorCourseRequirement
implements Comparable<InstructorCourseRequirement> {
    private static final long serialVersionUID = 3076787808984760805L;

    @Override
    public int compareTo(InstructorCourseRequirement req) {
        if (this.getInstructorSurvey().equals(req.getInstructorSurvey())) {
            int cmp = this.getCourse().compareTo(req.getCourse());
            if (cmp != 0) {
                return cmp;
            }
            InstructorCourseRequirementNote n1 = this.getFirstNote();
            InstructorCourseRequirementNote n2 = req.getFirstNote();
            if (n1 == null) {
                if (n2 == null) {
                    return this.getUniqueId().compareTo(req.getUniqueId());
                }
                return 1;
            }
            if (n2 == null) {
                return -1;
            }
            cmp = n1.getType().getSortOrder().compareTo(n2.getType().getSortOrder());
            if (cmp != 0) {
                return cmp;
            }
            cmp = (n1.getNote() == null ? "" : n1.getNote()).compareTo(n2.getNote() == null ? "" : n2.getNote());
            if (cmp != 0) {
                return cmp;
            }
        } else {
            int cmp = this.getInstructorSurvey().getExternalUniqueId().compareTo(req.getInstructorSurvey().getExternalUniqueId());
            if (cmp != 0) {
                return cmp;
            }
        }
        return this.getUniqueId().compareTo(req.getUniqueId());
    }

    @Transient
    public InstructorCourseRequirementNote getFirstNote() {
        InstructorCourseRequirementNote ret = null;
        for (InstructorCourseRequirementNote note : this.getNotes()) {
            if (ret != null && note.getType().getSortOrder() >= ret.getType().getSortOrder()) continue;
            ret = note;
        }
        return ret;
    }

    public InstructorCourseRequirementNote getNote(InstructorCourseRequirementType type) {
        for (InstructorCourseRequirementNote note : this.getNotes()) {
            if (!note.getType().equals(type)) continue;
            return note;
        }
        return null;
    }

    public static List<InstructorCourseRequirement> getRequirementsForOffering(InstructionalOffering io) {
        return InstructorCourseRequirementDAO.getInstance().getSession().createQuery("select r from InstructorCourseRequirement r, CourseOffering co where co.instructionalOffering.uniqueId = :offeringId and r.instructorSurvey.session = co.instructionalOffering.session and (r.courseOffering = co or r.course = (co.subjectAreaAbbv || ' ' || co.courseNbr)) and r.instructorSurvey.submitted is not null", InstructorCourseRequirement.class).setParameter("offeringId", (Object)io.getUniqueId()).setCacheable(true).list();
    }

    public static boolean hasRequirementsForOffering(InstructionalOffering io) {
        int reqs = ((Number)InstructorCourseRequirementDAO.getInstance().getSession().createQuery("select count(r) from InstructorCourseRequirement r, CourseOffering co where co.instructionalOffering.uniqueId = :offeringId and r.instructorSurvey.session = co.instructionalOffering.session and (r.courseOffering = co or r.course = (co.subjectAreaAbbv || ' ' || co.courseNbr)) and r.instructorSurvey.submitted is not null", Number.class).setParameter("offeringId", (Object)io.getUniqueId()).setCacheable(true).uniqueResult()).intValue();
        if (reqs > 0) {
            return true;
        }
        int survs = ((Number)InstructorCourseRequirementDAO.getInstance().getSession().createQuery("select count(s) from InstructorSurvey s where s.submitted is not null and s.externalUniqueId in (select ci.instructor.externalUniqueId from ClassInstructor ci where ci.classInstructing.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId = :offeringId and ci.instructor.externalUniqueId is not null) and s.session.uniqueId = :sessionId and (s.preferences is not empty or length(s.note) > 0)", Number.class).setParameter("sessionId", (Object)io.getSessionId()).setParameter("offeringId", (Object)io.getUniqueId()).setCacheable(true).uniqueResult()).intValue();
        return survs > 0;
    }
}

