/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.courses;

import com.lowagie.text.DocumentException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.PdfWorksheet;

@Service(value="org.unitime.timetable.export.Exporter:worksheet.pdf")
public class WorksheetPDF
implements Exporter {
    @Override
    public String reference() {
        return "worksheet.pdf";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        ArrayList<SubjectArea> subjectAreas = new ArrayList<SubjectArea>();
        for (String subjectAreaId : helper.getParameter("subjectArea").split(",")) {
            SubjectArea subjectArea;
            if (subjectAreaId.isEmpty() || (subjectArea = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(subjectAreaId))) == null) continue;
            subjectAreas.add(subjectArea);
            helper.getSessionContext().checkPermissionAnySession((Object)subjectArea.getDepartment(), Right.InstructionalOfferingsExportPDF, new Qualifiable[0]);
        }
        helper.setup("application/pdf", this.reference(), true);
        OutputStream out = helper.getOutputStream();
        try {
            PdfWorksheet.print(out, subjectAreas, helper.getParameter("courseNbr"), helper.getParameter("waitlist"));
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        out.flush();
        out.close();
    }
}

