/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalInstrOffrConfigChangeAction;
import org.unitime.timetable.interfaces.ExternalSectionMonitoredUpdateMessage;
import org.unitime.timetable.interfaces.ExternalVariableTitleDataLookup;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditFormat;
import org.unitime.timetable.model.CourseCreditType;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseCreditUnitType;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.OfferingConsentType;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.updates.ReloadOfferingAction;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.service.SolverServerService;

@Service(value="/api/var-title-crs")
public class VariableTitleCourseConnector
extends ApiConnector {
    @Autowired
    private SolverServerService solverServerService;

    @Override
    protected String getName() {
        return "var-title-crs";
    }

    @Override
    public void doGet(ApiHelper helper) throws IOException {
        VariableTitleQuery vtq = (VariableTitleQuery)helper.getRequest((Type)((Object)VariableTitleQuery.class));
        this.validateRequest(vtq, helper);
        helper.getSessionContext().checkPermissionAnyAuthority((Object)this.getAcadSession(vtq, helper.getHibSession()), Right.ApiVariableTitleSectionLookup, new Qualifiable[0]);
        this.findClassAndUpdateQueryData(vtq, this.findCourse(vtq, helper.getHibSession()), helper.getHibSession());
        helper.setResponse(vtq);
    }

    @Override
    public void doPost(ApiHelper helper) throws IOException {
        VariableTitleQuery vtq = (VariableTitleQuery)helper.getRequest((Type)((Object)VariableTitleQuery.class));
        this.validateRequest(vtq, helper);
        helper.getSessionContext().checkPermissionAnyAuthority((Object)this.getAcadSession(vtq, helper.getHibSession()), Right.ApiVariableTitleSectionCreate, new Qualifiable[0]);
        this.findOrCreateVariableTitleSection(vtq, helper);
        helper.setResponse(vtq);
    }

    private boolean validateRequest(VariableTitleQuery variableTitleQuery, ApiHelper helper) {
        if (variableTitleQuery == null) {
            throw new IllegalArgumentException("Missing Query Data.");
        }
        if (variableTitleQuery.getCampus() == null) {
            throw new IllegalArgumentException("Missing Campus.");
        }
        if (variableTitleQuery.getYear() == null) {
            throw new IllegalArgumentException("Missing Year.");
        }
        if (variableTitleQuery.getTerm() == null) {
            throw new IllegalArgumentException("Missing Term.");
        }
        if (variableTitleQuery.getSubjectArea() == null) {
            throw new IllegalArgumentException("Missing Subject Area.");
        }
        if (variableTitleQuery.getCourseNumber() == null) {
            throw new IllegalArgumentException("Missing Course Number.");
        }
        if (variableTitleQuery.getCourseTitle() == null) {
            throw new IllegalArgumentException("Missing Course Title.");
        }
        if (ApplicationProperty.VariableTitleInstructorIdRequired.isTrue() && variableTitleQuery.getInstructorId() == null) {
            throw new IllegalArgumentException("Missing Instructor Id.");
        }
        if (variableTitleQuery.getStartDate() == null) {
            throw new IllegalArgumentException("Missing Start Date.");
        }
        if (variableTitleQuery.getEndDate() == null) {
            throw new IllegalArgumentException("Missing End Date.");
        }
        Session s = this.getAcadSession(variableTitleQuery, helper.getHibSession());
        if (s == null) {
            throw new IllegalArgumentException("Academic session not found for campus, year, and term.");
        }
        SubjectArea sa = this.getSubjectObject(variableTitleQuery, helper.getHibSession());
        if (sa == null) {
            throw new IllegalArgumentException("Subject area not found for campus, year, term, and subject area abbreviaton.");
        }
        ExternalVariableTitleDataLookup evtdl = null;
        try {
            evtdl = this.lookupExternalVariableTitleDataLookup();
        }
        catch (Exception e) {
            Debug.error("Unable to look up external variable title data.", e);
            throw new IllegalArgumentException("Unable to look up external variable title data.  Unable to instantiate lookup class.");
        }
        if (evtdl != null && !evtdl.isVariableTitleCourse(sa, variableTitleQuery.getCourseNumber(), s, helper.getHibSession())) {
            throw new IllegalArgumentException("Course for provided subject area and course number is not a variable title course.");
        }
        if (variableTitleQuery.getInstructorId() != null && DepartmentalInstructor.findByPuidDepartmentId(variableTitleQuery.getInstructorId(), sa.getDepartment().getUniqueId(), helper.getHibSession()) == null) {
            throw new IllegalArgumentException("Instructor with matching id not found for provided subject area.");
        }
        if (ApplicationProperty.VariableTitleConfigName.value() == null || ApplicationProperty.VariableTitleConfigName.value().trim().equals("")) {
            throw new IllegalArgumentException("Variable Title Application Properties: Config Name must be set.");
        }
        if (ApplicationProperty.VariableTitleDefaultLimit.value() == null || ApplicationProperty.VariableTitleDefaultLimit.value().trim().equals("")) {
            throw new IllegalArgumentException("Variable Title Application Properties: Default Limit must be set.");
        }
        if (ApplicationProperty.VariableTitleInstructionalType.value() == null || ApplicationProperty.VariableTitleInstructionalType.value().trim().equals("")) {
            throw new IllegalArgumentException("Variable Title Application Properties: Instructional Type must be set.");
        }
        if (ItypeDesc.findForReference(ApplicationProperty.VariableTitleInstructionalType.value(), helper.getHibSession()) == null) {
            throw new IllegalArgumentException("Variable Title Application Properties: Instructional Type Not Found.");
        }
        return true;
    }

    private Session getAcadSession(VariableTitleQuery variableTitleQuery, org.hibernate.Session hibSession) {
        return Session.getSessionUsingCampusYearTerm(variableTitleQuery.getCampus(), variableTitleQuery.getYear(), variableTitleQuery.getTerm(), hibSession);
    }

    private SubjectArea getSubjectObject(VariableTitleQuery variableTitleQuery, org.hibernate.Session hibSession) {
        return SubjectArea.findUsingCampusYearTermExternalSubjectAbbreviation(variableTitleQuery.getCampus(), variableTitleQuery.getYear(), variableTitleQuery.getTerm(), variableTitleQuery.getSubjectArea(), hibSession);
    }

    private CourseOffering findCourse(VariableTitleQuery variableTitleQuery, org.hibernate.Session hibSession) {
        StringBuffer sb = new StringBuffer();
        sb.append("from CourseOffering co").append(" where co.instructionalOffering.session.uniqueId = ").append(this.getAcadSession(variableTitleQuery, hibSession).getUniqueId()).append(" and co.subjectArea.uniqueId = ").append(this.getSubjectObject(variableTitleQuery, hibSession).getUniqueId()).append(" and co.courseNbr like '").append(variableTitleQuery.getCourseNumber()).append("%'");
        List courses = hibSession.createQuery(sb.toString(), CourseOffering.class).setCacheable(true).list();
        CourseOffering co = null;
        for (CourseOffering c : courses) {
            if (c.getTitle() == null || !c.getTitle().trim().equalsIgnoreCase(variableTitleQuery.getCourseTitle().trim())) continue;
            co = c;
            break;
        }
        return co;
    }

    private Class_ findClass(VariableTitleQuery variableTitleQuery, CourseOffering courseOffering, org.hibernate.Session hibSession) {
        if (ApplicationProperty.VariableTitleInstructorIdRequired.isTrue() && variableTitleQuery.getInstructorId() == null) {
            return null;
        }
        if (courseOffering != null && courseOffering.getInstructionalOffering() != null && courseOffering.getInstructionalOffering().getInstrOfferingConfigs() != null && !courseOffering.getInstructionalOffering().getInstrOfferingConfigs().isEmpty()) {
            for (InstrOfferingConfig ioc : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                if (ioc.getSchedulingSubparts().size() != 1 || (ApplicationProperty.VariableTitleConfigName.value() == null || ApplicationProperty.VariableTitleConfigName.value() == "" || !ioc.getName().equals(ApplicationProperty.VariableTitleConfigName.value())) && ApplicationProperty.VariableTitleConfigName.value() != null && ApplicationProperty.VariableTitleConfigName.value().trim() != "") continue;
                for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                    if (!ss.getItype().getSis_ref().equals(ApplicationProperty.VariableTitleInstructionalType.value())) continue;
                    for (Class_ c : ss.getClasses()) {
                        if (!c.effectiveDatePattern().getStartDate().equals(variableTitleQuery.getStartDate()) || !c.effectiveDatePattern().getEndDate().equals(variableTitleQuery.getEndDate())) continue;
                        if ((ApplicationProperty.VariableTitleInstructorIdRequired.isTrue() || variableTitleQuery.getInstructorId() != null) && c.getClassInstructors().size() == 1) {
                            for (ClassInstructor ci : c.getClassInstructors()) {
                                if (ci.getInstructor().getExternalUniqueId() == null || !ci.getInstructor().getExternalUniqueId().equalsIgnoreCase(variableTitleQuery.getInstructorId())) continue;
                                return c;
                            }
                            continue;
                        }
                        if (!ApplicationProperty.VariableTitleInstructorIdRequired.isFalse() || variableTitleQuery.getInstructorId() != null || c.getClassInstructors().size() != 0) continue;
                        return c;
                    }
                }
            }
        }
        return null;
    }

    private void findClassAndUpdateQueryData(VariableTitleQuery variableTitleQuery, CourseOffering courseOffering, org.hibernate.Session hibSession) {
        Class_ clazz = this.findClass(variableTitleQuery, courseOffering, hibSession);
        if (clazz != null) {
            variableTitleQuery.setFullCourseNumber(courseOffering.getCourseNbr());
            variableTitleQuery.setExternalId(clazz.getExternalId(courseOffering));
        }
        variableTitleQuery.setStatus(this.findClassCreationStatus(courseOffering, clazz, hibSession));
    }

    private String findClassCreationStatus(CourseOffering courseOffering, Class_ clazz, org.hibernate.Session hibSession) {
        ExternalInstrOffrConfigChangeAction externalInstrOffrConfigChangeAction = null;
        try {
            externalInstrOffrConfigChangeAction = this.lookupExternalConfigChangeAction();
        }
        catch (Exception e) {
            Debug.error("Error trying to instantiate External Config Change Action, section will not be sent to the External System, FAILED will be returned by default", e);
            return ExternalSectionMonitoredUpdateMessage.ExternalSectionCreationStatus.FAILED.toString();
        }
        return this.createExternalSectionAndReturnStatus(courseOffering, clazz, externalInstrOffrConfigChangeAction != null, externalInstrOffrConfigChangeAction, hibSession);
    }

    private String createExternalSectionAndReturnStatus(CourseOffering co, Class_ clazz, boolean externalConfigChangeActionExists, ExternalInstrOffrConfigChangeAction configChangeAction, org.hibernate.Session hibSession) {
        if (co == null || co.getUniqueId() == null) {
            return ExternalSectionMonitoredUpdateMessage.ExternalSectionCreationStatus.DOES_NOT_EXIST.toString();
        }
        if (clazz == null || clazz.getUniqueId() == null) {
            return ExternalSectionMonitoredUpdateMessage.ExternalSectionCreationStatus.DOES_NOT_EXIST.toString();
        }
        if (externalConfigChangeActionExists && configChangeAction == null) {
            return ExternalSectionMonitoredUpdateMessage.ExternalSectionCreationStatus.FAILED.toString();
        }
        if (configChangeAction == null) {
            return ExternalSectionMonitoredUpdateMessage.ExternalSectionCreationStatus.SUCCESS.toString();
        }
        ExternalSectionMonitoredUpdateMessage externalSectionMonitoredUpdateMessage = null;
        try {
            externalSectionMonitoredUpdateMessage = this.lookupExternalSectionMonitoredUpdateMessageAction();
        }
        catch (Exception e) {
            Debug.error("Error trying to instantiate External Section Monitored Message Action, section will not be sent to the External System, FAILED will be returned by default", e);
            return ExternalSectionMonitoredUpdateMessage.ExternalSectionCreationStatus.FAILED.toString();
        }
        if (externalSectionMonitoredUpdateMessage != null) {
            return externalSectionMonitoredUpdateMessage.monitorExternalSectionUpdate(co, clazz, configChangeAction, ApplicationProperty.VariableTitleExternalSystemWaitTime.intValue(), hibSession).toString();
        }
        return ExternalSectionMonitoredUpdateMessage.ExternalSectionCreationStatus.SUCCESS.toString();
    }

    private String generateCourseNumber(SubjectArea subjectArea, String courseNumber, org.hibernate.Session hibSession) {
        HashSet existingNumbers = new HashSet();
        String query = "select co.courseNbr from CourseOffering co where co.subjectArea.uniqueId = :subjId and co.courseNbr like '" + courseNumber + "%'";
        existingNumbers.addAll(hibSession.createQuery(query, String.class).setParameter("subjId", (Object)subjectArea.getUniqueId()).list());
        int char1 = 65;
        int char2 = 65;
        boolean needSecondCharacter = false;
        while (char1 <= 90 && char2 <= 90) {
            StringBuffer chkCrsNumber = new StringBuffer();
            chkCrsNumber.append(courseNumber).append(ApplicationProperty.VariableTitleCourseSuffixDefaultStartCharacter.value()).append((char)char1);
            if (needSecondCharacter) {
                chkCrsNumber.append((char)char2);
            }
            if (existingNumbers.contains(chkCrsNumber.toString())) {
                if (!needSecondCharacter) {
                    if (char1 == 90) {
                        char1 = 65;
                        needSecondCharacter = true;
                        continue;
                    }
                    char1 = (char)(char1 + 1);
                    continue;
                }
                if (char2 == 90) {
                    char2 = 65;
                    char1 = (char)(char1 + 1);
                    continue;
                }
                char2 = (char)(char2 + 1);
                continue;
            }
            return chkCrsNumber.toString();
        }
        return null;
    }

    private String getProperlyCasedTitle(String originalTitle) {
        if (ApplicationProperty.VariableTitleTitleFirstCharsOfWordsUpperCase.isTrue()) {
            StringBuffer sb = new StringBuffer();
            String[] words = originalTitle.split("\\s");
            boolean first = true;
            for (String word : words) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" ");
                }
                sb.append(word.substring(0, 1).toUpperCase()).append(word.substring(1));
            }
            return sb.toString();
        }
        return originalTitle;
    }

    private InstructionalOffering createOffering(VariableTitleQuery variableTitleQuery, SubjectArea subjectArea, org.hibernate.Session hibSession) {
        String newCourseNumber = this.generateCourseNumber(subjectArea, variableTitleQuery.getCourseNumber(), hibSession);
        CourseOffering courseOffering = new CourseOffering();
        OfferingConsentType consent = OfferingConsentType.getOfferingConsentTypeForReference(ApplicationProperty.VariableTitleDefaultConsentType.value());
        courseOffering.setSubjectArea(subjectArea);
        subjectArea.addToCourseOfferings(courseOffering);
        courseOffering.setSubjectAreaAbbv(subjectArea.getSubjectAreaAbbreviation());
        courseOffering.setCourseNbr(newCourseNumber);
        courseOffering.setTitle(this.getProperlyCasedTitle(variableTitleQuery.getCourseTitle()));
        courseOffering.setIsControl(true);
        courseOffering.setNbrExpectedStudents(0);
        courseOffering.setDemand(0);
        courseOffering.setConsentType(consent);
        InstructionalOffering instructionalOffering = new InstructionalOffering();
        instructionalOffering.setNotOffered(false);
        instructionalOffering.addToCourseOfferings(courseOffering);
        courseOffering.setInstructionalOffering(instructionalOffering);
        instructionalOffering.setSession(subjectArea.getSession());
        instructionalOffering.setByReservationOnly(false);
        instructionalOffering.generateInstrOfferingPermId();
        hibSession.persist((Object)instructionalOffering);
        hibSession.persist((Object)courseOffering);
        ExternalVariableTitleDataLookup externalVariableTitleDataLookup = null;
        try {
            externalVariableTitleDataLookup = this.lookupExternalVariableTitleDataLookup();
        }
        catch (Exception e) {
            Debug.error("Error trying to instantiate variable title data lookup class, course credit config will not be created.", e);
        }
        if (externalVariableTitleDataLookup != null) {
            CourseCreditUnitType ccut;
            CourseCreditType cct;
            CourseCreditFormat ccf = externalVariableTitleDataLookup.courseCreditFormatForCourse(subjectArea, variableTitleQuery.getCourseNumber(), subjectArea.getSession(), hibSession);
            Float minCredit = externalVariableTitleDataLookup.minCreditForCourse(subjectArea, variableTitleQuery.getCourseNumber(), subjectArea.getSession(), hibSession);
            Float maxCredit = externalVariableTitleDataLookup.maxCreditForCourse(subjectArea, variableTitleQuery.getCourseNumber(), subjectArea.getSession(), hibSession);
            if (ccf != null && minCredit != null && ApplicationProperty.VariableTitleDefaultCourseCreditType.value() != null && ApplicationProperty.VariableTitleDefaultCourseCreditType.value().trim().length() != 0 && ApplicationProperty.VariableTitleDefaultCourseCreditUnitType.value() != null && ApplicationProperty.VariableTitleDefaultCourseCreditUnitType.value().trim().length() != 0 && (cct = CourseCreditType.getCourseCreditTypeForReference(ApplicationProperty.VariableTitleDefaultCourseCreditType.value())) != null & (ccut = CourseCreditUnitType.getCourseCreditUnitTypeForReference(ApplicationProperty.VariableTitleDefaultCourseCreditUnitType.value())) != null) {
                CourseCreditUnitConfig ccuc = CourseCreditUnitConfig.createCreditUnitConfigOfFormat(ccf.getReference(), cct, ccut, minCredit, maxCredit, Boolean.TRUE, Boolean.TRUE);
                ccuc.setOwner(courseOffering);
                courseOffering.addToCreditConfigs(ccuc);
                hibSession.persist((Object)ccuc);
            }
        }
        return instructionalOffering;
    }

    private InstrOfferingConfig createConfiguration(InstructionalOffering instructionalOffering, String configName, org.hibernate.Session hibSession) {
        InstrOfferingConfig instrOfferingConfig = new InstrOfferingConfig();
        instrOfferingConfig.setInstructionalOffering(instructionalOffering);
        instructionalOffering.addToInstrOfferingConfigs(instrOfferingConfig);
        if (ApplicationProperty.VariableTitleDefaultLimit.intValue() < 0) {
            instrOfferingConfig.setUnlimitedEnrollment(Boolean.TRUE);
            instrOfferingConfig.setLimit(0);
        } else {
            instrOfferingConfig.setUnlimitedEnrollment(Boolean.FALSE);
            instrOfferingConfig.setLimit(ApplicationProperty.VariableTitleDefaultLimit.intValue());
        }
        instrOfferingConfig.setName(configName);
        hibSession.persist((Object)instrOfferingConfig);
        return instrOfferingConfig;
    }

    private SchedulingSubpart createSubpart(InstrOfferingConfig instrOfferingConfig, org.hibernate.Session hibSession) {
        ItypeDesc itype = ItypeDesc.findForReference(ApplicationProperty.VariableTitleInstructionalType.value(), hibSession);
        SchedulingSubpart ss = new SchedulingSubpart();
        ss.setInstrOfferingConfig(instrOfferingConfig);
        instrOfferingConfig.addToschedulingSubparts(ss);
        ss.setItype(itype);
        ss.setMinutesPerWk(0);
        ss.setAutoSpreadInTime(ApplicationProperty.SchedulingSubpartAutoSpreadInTimeDefault.isTrue());
        ss.setStudentAllowOverlap(ApplicationProperty.SchedulingSubpartStudentOverlapsDefault.isTrue());
        ss.setChildSubparts(new HashSet<SchedulingSubpart>());
        ss.setPreferences(new HashSet<Preference>());
        hibSession.persist((Object)ss);
        return ss;
    }

    private Class_ createClass(VariableTitleQuery variableTitleQuery, SubjectArea subjectArea, SchedulingSubpart ss, org.hibernate.Session hibSession) {
        DatePattern datePattern = this.lookupDatePattern(variableTitleQuery, hibSession);
        if (datePattern == null) {
            datePattern = this.createVariableTitleDatePattern(variableTitleQuery, hibSession);
        }
        Class_ clazz = new Class_();
        clazz.setCancelled(false);
        clazz.setControllingDept(subjectArea.getDepartment());
        clazz.setManagingDept(subjectArea.getDepartment());
        if (!datePattern.isDefault()) {
            clazz.setDatePattern(datePattern);
        }
        clazz.setDisplayInstructor(true);
        if (ApplicationProperty.VariableTitleDefaultLimit.intValue() >= 0) {
            clazz.setExpectedCapacity(ApplicationProperty.VariableTitleDefaultLimit.intValue());
            clazz.setMaxExpectedCapacity(ApplicationProperty.VariableTitleDefaultLimit.intValue());
        } else {
            clazz.setExpectedCapacity(0);
            clazz.setMaxExpectedCapacity(0);
        }
        clazz.setEnabledForStudentScheduling(true);
        clazz.setNbrRooms(0);
        clazz.setSchedulingSubpart(ss);
        clazz.setRoomRatio(Float.valueOf(0.0f));
        clazz.setPreferences(new HashSet<Preference>());
        ss.addToClasses(clazz);
        hibSession.persist((Object)clazz);
        if (variableTitleQuery.getInstructorId() != null) {
            DepartmentalInstructor di = DepartmentalInstructor.findByPuidDepartmentId(variableTitleQuery.getInstructorId(), subjectArea.getDepartment().getUniqueId(), hibSession);
            ClassInstructor ci = new ClassInstructor();
            ci.setLead(true);
            ci.setPercentShare(100);
            ci.setInstructor(di);
            ci.setClassInstructing(clazz);
            clazz.addToClassInstructors(ci);
            hibSession.persist((Object)ci);
        }
        return clazz;
    }

    private InstrOfferingConfig findConfigWithName(InstructionalOffering instructionalOffering, String name) {
        for (InstrOfferingConfig ioc : instructionalOffering.getInstrOfferingConfigs()) {
            if (!ioc.getName().equals(name.trim())) continue;
            return ioc;
        }
        return null;
    }

    private boolean isConfigValidForVariableTitle(InstrOfferingConfig instrOfferingConfig) {
        if (instrOfferingConfig.getSchedulingSubparts() == null || instrOfferingConfig.getSchedulingSubparts().isEmpty()) {
            return true;
        }
        if (instrOfferingConfig.getSchedulingSubparts().size() > 1) {
            return false;
        }
        for (SchedulingSubpart ss : instrOfferingConfig.getSchedulingSubparts()) {
            if (ss.getItype().getSis_ref().equals(ApplicationProperty.VariableTitleInstructionalType.value())) continue;
            return false;
        }
        return true;
    }

    private InstrOfferingConfig findOrCreateVariableTitleConfig(InstructionalOffering instructionalOffering, org.hibernate.Session hibSession) {
        InstrOfferingConfig instrOfferingConfig = null;
        Object vtConfigName = ApplicationProperty.VariableTitleConfigName.value().trim();
        int cnt = 0;
        while (instrOfferingConfig == null) {
            if (instructionalOffering.getInstrOfferingConfigs() != null && instructionalOffering.existsConfig((String)vtConfigName, null)) {
                InstrOfferingConfig checkIoc = this.findConfigWithName(instructionalOffering, (String)vtConfigName);
                if (this.isConfigValidForVariableTitle(checkIoc)) {
                    instrOfferingConfig = checkIoc;
                    continue;
                }
                vtConfigName = ApplicationProperty.VariableTitleConfigName.value().trim() + ++cnt;
                continue;
            }
            instrOfferingConfig = this.createConfiguration(instructionalOffering, (String)vtConfigName, hibSession);
        }
        return instrOfferingConfig;
    }

    private void findOrCreateVariableTitleSection(VariableTitleQuery variableTitleQuery, ApiHelper helper) {
        OnlineSectioningServer server;
        CourseOffering courseOffering = this.findCourse(variableTitleQuery, helper.getHibSession());
        Class_ clazz = null;
        if (courseOffering != null && (clazz = this.findClass(variableTitleQuery, courseOffering, helper.getHibSession())) != null) {
            variableTitleQuery.setFullCourseNumber(courseOffering.getCourseNbr());
            variableTitleQuery.setExternalId(clazz.getExternalId(courseOffering));
            variableTitleQuery.setStatus(this.findClassCreationStatus(courseOffering, clazz, helper.getHibSession()));
            return;
        }
        ExternalInstrOffrConfigChangeAction configChangeAction = null;
        boolean configChangeActionExists = false;
        try {
            configChangeAction = this.lookupExternalConfigChangeAction();
        }
        catch (Exception e2) {
            Debug.error("Error trying to instantiate External Config Change Action, this will result in a FAILED response.", e2);
            configChangeActionExists = true;
        }
        if (configChangeAction != null) {
            configChangeActionExists = true;
        }
        InstructionalOffering instructionalOffering = null;
        Transaction trans = null;
        try {
            trans = helper.getHibSession().beginTransaction();
            SubjectArea subjectArea = this.getSubjectObject(variableTitleQuery, helper.getHibSession());
            if (courseOffering == null) {
                instructionalOffering = this.createOffering(variableTitleQuery, subjectArea, helper.getHibSession());
                courseOffering = instructionalOffering.getControllingCourseOffering();
            } else {
                instructionalOffering = courseOffering.getInstructionalOffering();
                if (instructionalOffering.isNotOffered().booleanValue()) {
                    instructionalOffering.setNotOffered(false);
                    helper.getHibSession().merge((Object)instructionalOffering);
                }
            }
            InstrOfferingConfig instrOfferingConfig = this.findOrCreateVariableTitleConfig(instructionalOffering, helper.getHibSession());
            SchedulingSubpart schedulingSubpart = null;
            if (instrOfferingConfig.getSchedulingSubparts() == null || instrOfferingConfig.getSchedulingSubparts().isEmpty()) {
                schedulingSubpart = this.createSubpart(instrOfferingConfig, helper.getHibSession());
            } else {
                Iterator<SchedulingSubpart> iterator = instrOfferingConfig.getSchedulingSubparts().iterator();
                while (iterator.hasNext()) {
                    SchedulingSubpart ss;
                    schedulingSubpart = ss = iterator.next();
                }
            }
            clazz = this.createClass(variableTitleQuery, subjectArea, schedulingSubpart, helper.getHibSession());
            if (configChangeAction != null && !configChangeAction.validateConfigChangeCanOccur(instructionalOffering, helper.getHibSession())) {
                throw new Exception("Configuration change violates rules for Add On, rolling back the change.");
            }
            instructionalOffering.computeLabels(helper.getHibSession());
            ChangeLog.addChange(helper.getHibSession(), helper.getSessionContext(), clazz, ChangeLog.Source.VARIABLE_TITLE_API, ChangeLog.Operation.CREATE, instrOfferingConfig.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), null);
            helper.getHibSession().flush();
            trans.commit();
        }
        catch (Exception e) {
            Debug.error("Failed to create variable title section.", e);
            try {
                if (trans != null && trans.isActive()) {
                    trans.rollback();
                }
            }
            catch (Exception e1) {
                Debug.error("Unable to roll back transaction.", e1);
            }
            variableTitleQuery.setStatus(ExternalSectionMonitoredUpdateMessage.ExternalSectionCreationStatus.FAILED.toString());
            return;
        }
        variableTitleQuery.setStatus(this.createExternalSectionAndReturnStatus(courseOffering, clazz, configChangeActionExists, configChangeAction, helper.getHibSession()));
        if (courseOffering != null && courseOffering.getUniqueId() != null) {
            variableTitleQuery.setFullCourseNumber(courseOffering.getCourseNbr());
        }
        if (courseOffering != null && courseOffering.getUniqueId() != null && clazz != null && clazz.getUniqueId() != null) {
            variableTitleQuery.setExternalId(clazz.getExternalId(courseOffering));
        }
        if ((server = this.getOnlineSectioningServer(instructionalOffering.getSessionId())) != null && server.isReady()) {
            server.execute(server.createAction(ReloadOfferingAction.class).forOfferings(instructionalOffering.getUniqueId()), this.getUser());
        } else {
            StudentSectioningQueue.offeringChanged(helper.getHibSession(), helper.getSessionContext().getUser(), instructionalOffering.getSessionId(), instructionalOffering.getUniqueId());
            helper.getHibSession().flush();
        }
    }

    protected OnlineSectioningServer getOnlineSectioningServer(Long sessionId) {
        return this.solverServerService == null ? null : this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(sessionId.toString());
    }

    protected OnlineSectioningLog.Entity getUser() {
        return OnlineSectioningLog.Entity.newBuilder().setExternalId(StudentClassEnrollment.SystemChange.SYSTEM.name()).setName(StudentClassEnrollment.SystemChange.SYSTEM.getName()).setType(OnlineSectioningLog.Entity.EntityType.OTHER).build();
    }

    private ExternalInstrOffrConfigChangeAction lookupExternalConfigChangeAction() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        String className = ApplicationProperty.ExternalActionInstrOffrConfigChange.value();
        ExternalInstrOffrConfigChangeAction configChangeAction = null;
        if (className != null && className.trim().length() > 0) {
            configChangeAction = (ExternalInstrOffrConfigChangeAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return configChangeAction;
    }

    private ExternalVariableTitleDataLookup lookupExternalVariableTitleDataLookup() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        String className = ApplicationProperty.ExternalVariableTitleDataLookup.value();
        ExternalVariableTitleDataLookup externalVariableTitleDataLookup = null;
        if (className != null && className.trim().length() > 0) {
            externalVariableTitleDataLookup = (ExternalVariableTitleDataLookup)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return externalVariableTitleDataLookup;
    }

    private ExternalSectionMonitoredUpdateMessage lookupExternalSectionMonitoredUpdateMessageAction() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        String className = ApplicationProperty.ExternalActionSectionMonitoredUpdateMessage.value();
        ExternalSectionMonitoredUpdateMessage esmum = null;
        if (className != null && className.trim().length() > 0) {
            esmum = (ExternalSectionMonitoredUpdateMessage)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return esmum;
    }

    private DatePattern createVariableTitleDatePattern(VariableTitleQuery variableTitleQuery, org.hibernate.Session hibSession) {
        DatePattern dp = new DatePattern();
        dp.setName(this.generatedVariableTitleDatePatternName(variableTitleQuery));
        dp.setSession(this.getAcadSession(variableTitleQuery, hibSession));
        dp.setPatternOffset(variableTitleQuery.getStartDate());
        StringBuffer sb = new StringBuffer();
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(variableTitleQuery.getStartDate());
        while (cal.getTime().compareTo(variableTitleQuery.getEndDate()) <= 0) {
            sb.append(1);
            cal.add(6, 1);
        }
        dp.setPattern(sb.toString());
        dp.setDatePatternType(DatePattern.DatePatternType.Extended);
        dp.setVisible(true);
        hibSession.persist((Object)dp);
        return dp;
    }

    private String generatedVariableTitleDatePatternName(VariableTitleQuery variableTitleQuery) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sb = new StringBuffer();
        sb.append(ApplicationProperty.VariableTitleDatePatternPrefix.value()).append(sdf.format(variableTitleQuery.getStartDate())).append("_").append(sdf.format(variableTitleQuery.getEndDate()));
        return sb.toString();
    }

    private DatePattern lookupDatePattern(VariableTitleQuery variableTitleQuery, org.hibernate.Session hibSession) {
        Session s = this.getAcadSession(variableTitleQuery, hibSession);
        if (s.getDefaultDatePattern() != null && s.getDefaultDatePattern().getStartDate().equals(variableTitleQuery.getStartDate()) && s.getDefaultDatePattern().getEndDate().equals(variableTitleQuery.getEndDate())) {
            return s.getDefaultDatePattern();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("from DatePattern dp").append(" where dp.session.uniqueId = :sessionId").append(" and dp.type = ").append(DatePattern.DatePatternType.Extended.ordinal()).append(" and dp.name = '").append(this.generatedVariableTitleDatePatternName(variableTitleQuery)).append("'");
        DatePattern dp = (DatePattern)hibSession.createQuery(sb.toString(), DatePattern.class).setParameter("sessionId", (Object)s.getUniqueId()).uniqueResult();
        if (dp == null) {
            for (DatePattern sdp : DatePattern.findAll(s, false, null, null)) {
                if (!sdp.getType().equals(DatePattern.DatePatternType.Standard.ordinal()) && !sdp.getType().equals(DatePattern.DatePatternType.NonStandard.ordinal()) || !sdp.getStartDate().equals(variableTitleQuery.getStartDate()) || !sdp.getEndDate().equals(variableTitleQuery.getEndDate()) || !sdp.getPattern().contains("0") || !sdp.respectsSessionHolidaysAndHasNoNonHolidayBreaks()) continue;
                dp = sdp;
                break;
            }
        }
        return dp;
    }

    public class VariableTitleQuery
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String iCampus;
        String iYear;
        String iTerm;
        String iSubjectArea;
        String iCourseNumber;
        String iCourseTitle;
        String iInstructorId;
        Date iStartDate;
        Date iEndDate;
        String iFullCourseNumber;
        String iExternalId;
        String iStatus;

        public String getCampus() {
            return this.iCampus;
        }

        public void setCampus(String campus) {
            this.iCampus = campus;
        }

        public String getYear() {
            return this.iYear;
        }

        public void setYear(String year) {
            this.iYear = year;
        }

        public String getTerm() {
            return this.iTerm;
        }

        public void setTerm(String term) {
            this.iTerm = term;
        }

        public String getSubjectArea() {
            return this.iSubjectArea;
        }

        public void setSubjectArea(String subjectArea) {
            this.iSubjectArea = subjectArea;
        }

        public String getCourseNumber() {
            return this.iCourseNumber;
        }

        public void setCourseNumber(String courseNumber) {
            this.iCourseNumber = courseNumber;
        }

        public String getCourseTitle() {
            return this.iCourseTitle;
        }

        public void setCourseTitle(String courseTitle) {
            this.iCourseTitle = courseTitle;
        }

        public String getInstructorId() {
            if (this.iInstructorId != null && ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue()) {
                return this.iInstructorId.trim().replaceFirst("^0+(?!$)", "");
            }
            return this.iInstructorId;
        }

        public void setInstructorId(String instructorId) {
            this.iInstructorId = instructorId;
        }

        public Date getStartDate() {
            return this.iStartDate;
        }

        public void setStartDate(Date startDate) {
            this.iStartDate = startDate;
        }

        public Date getEndDate() {
            return this.iEndDate;
        }

        public void setEndDate(Date endDate) {
            this.iEndDate = endDate;
        }

        public String getFullCourseNumber() {
            return this.iFullCourseNumber;
        }

        public void setFullCourseNumber(String fullCourseNumber) {
            this.iFullCourseNumber = fullCourseNumber;
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public String getStatus() {
            return this.iStatus;
        }

        public void setStatus(String status) {
            this.iStatus = status;
        }
    }
}

