/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.util.DayOfWeek;
import biweekly.util.Frequency;
import biweekly.util.Recurrence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RecurrenceParserV1 {
    private final ParseContext context;

    public RecurrenceParserV1(ParseContext context) {
        this.context = context;
    }

    public Recurrence parse(String value) {
        Recurrence.Builder builder = new Recurrence.Builder((Frequency)null);
        LinkedList<String> tokens = this.splitTokens(value);
        String frequencyStr = this.parseFrequencyAndInterval(tokens, builder);
        this.parseCountAndUntil(tokens, builder);
        TokenHandler tokenHandler = this.getTokenHandler(frequencyStr);
        builder.frequency(tokenHandler.frequency());
        for (String token : tokens) {
            if (token.endsWith("$")) {
                this.context.addWarning(36, token);
                token = this.removeLastChar(token);
            }
            tokenHandler.processToken(token, builder);
        }
        tokenHandler.noMoreTokens(builder);
        return builder.build();
    }

    private String removeLastChar(String s) {
        return s.substring(0, s.length() - 1);
    }

    private String parseFrequencyAndInterval(LinkedList<String> tokens, Recurrence.Builder builder) {
        String token = tokens.remove(0);
        Pattern p = Pattern.compile("^([A-Z]+)(\\d+)$");
        Matcher m = p.matcher(token);
        if (!m.find()) {
            throw new CannotParseException(40, token);
        }
        builder.interval(this.integerValueOf(m.group(2)));
        return m.group(1);
    }

    private void parseCountAndUntil(LinkedList<String> tokens, Recurrence.Builder builder) {
        int DEFAULT_COUNT = 2;
        if (tokens.isEmpty()) {
            builder.count(2);
            return;
        }
        String lastToken = tokens.getLast();
        if (lastToken.startsWith("#")) {
            String countStr = lastToken.substring(1);
            Integer count = this.integerValueOf(countStr);
            if (count != 0) {
                builder.count(count);
            }
            tokens.removeLast();
            return;
        }
        try {
            builder.until(ICalPropertyScribe.date(lastToken).parse());
            tokens.removeLast();
        }
        catch (IllegalArgumentException e) {
            builder.count(2);
        }
    }

    private TokenHandler getTokenHandler(String frequencyStr) {
        if ("YD".equals(frequencyStr)) {
            return new YDHandler();
        }
        if ("YM".equals(frequencyStr)) {
            return new YMHandler();
        }
        if ("MD".equals(frequencyStr)) {
            return new MDHandler();
        }
        if ("MP".equals(frequencyStr)) {
            return new MPHandler();
        }
        if ("W".equals(frequencyStr)) {
            return new WHandler();
        }
        if ("D".equals(frequencyStr)) {
            return new DHandler();
        }
        if ("M".equals(frequencyStr)) {
            return new MHandler();
        }
        throw new CannotParseException(41, frequencyStr);
    }

    private LinkedList<String> splitTokens(String value) {
        String valueUpper = value.toUpperCase();
        String[] split = valueUpper.split("\\s+");
        return new LinkedList<String>(Arrays.asList(split));
    }

    private Integer integerValueOf(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new CannotParseException(40, value);
        }
    }

    private int parseVCalInt(String value) {
        int negate;
        String num;
        if (value.endsWith("+")) {
            num = this.removeLastChar(value);
            negate = 1;
        } else if (value.endsWith("-")) {
            num = this.removeLastChar(value);
            negate = -1;
        } else {
            num = value;
            negate = 1;
        }
        return Integer.parseInt(num) * negate;
    }

    private DayOfWeek parseDay(String value) {
        DayOfWeek day = DayOfWeek.valueOfAbbr(value);
        if (day == null) {
            throw new CannotParseException(42, value);
        }
        return day;
    }

    public static List<String> splitPropertyValue(String value) {
        ArrayList<String> values = new ArrayList<String>();
        Pattern p = Pattern.compile("#\\d+|\\d{8}T\\d{6}Z?");
        Matcher m = p.matcher(value);
        int prevIndex = 0;
        while (m.find()) {
            int end = m.end();
            String subValue = value.substring(prevIndex, end).trim();
            values.add(subValue);
            prevIndex = end;
        }
        String subValue = value.substring(prevIndex).trim();
        if (subValue.length() > 0) {
            values.add(subValue);
        }
        return values;
    }

    private class MHandler
    implements TokenHandler {
        private MHandler() {
        }

        @Override
        public Frequency frequency() {
            return Frequency.MINUTELY;
        }

        @Override
        public void processToken(String token, Recurrence.Builder builder) {
        }

        @Override
        public void noMoreTokens(Recurrence.Builder builder) {
        }
    }

    private class DHandler
    implements TokenHandler {
        private DHandler() {
        }

        @Override
        public Frequency frequency() {
            return Frequency.DAILY;
        }

        @Override
        public void processToken(String token, Recurrence.Builder builder) {
            Integer hour = RecurrenceParserV1.this.integerValueOf(token.substring(0, 2));
            builder.byHour(hour);
            Integer minute = RecurrenceParserV1.this.integerValueOf(token.substring(2, 4));
            builder.byMinute(minute);
        }

        @Override
        public void noMoreTokens(Recurrence.Builder builder) {
        }
    }

    private class WHandler
    implements TokenHandler {
        private WHandler() {
        }

        @Override
        public Frequency frequency() {
            return Frequency.WEEKLY;
        }

        @Override
        public void processToken(String token, Recurrence.Builder builder) {
            DayOfWeek day = RecurrenceParserV1.this.parseDay(token);
            builder.byDay(day);
        }

        @Override
        public void noMoreTokens(Recurrence.Builder builder) {
        }
    }

    private class MPHandler
    implements TokenHandler {
        private final List<Integer> nums = new ArrayList<Integer>();
        private final List<DayOfWeek> days = new ArrayList<DayOfWeek>();
        private boolean readNum = false;

        private MPHandler() {
        }

        @Override
        public Frequency frequency() {
            return Frequency.MONTHLY;
        }

        @Override
        public void processToken(String token, Recurrence.Builder builder) {
            if (token.matches("\\d{4}")) {
                this.readNum = false;
                Integer hour = RecurrenceParserV1.this.integerValueOf(token.substring(0, 2));
                builder.byHour(hour);
                Integer minute = RecurrenceParserV1.this.integerValueOf(token.substring(2, 4));
                builder.byMinute(minute);
                return;
            }
            try {
                Integer curNum = RecurrenceParserV1.this.parseVCalInt(token);
                if (!this.readNum) {
                    for (Integer num : this.nums) {
                        for (DayOfWeek day : this.days) {
                            builder.byDay(num, day);
                        }
                    }
                    this.nums.clear();
                    this.days.clear();
                    this.readNum = true;
                }
                this.nums.add(curNum);
            }
            catch (NumberFormatException e) {
                this.readNum = false;
                this.days.add(RecurrenceParserV1.this.parseDay(token));
            }
        }

        @Override
        public void noMoreTokens(Recurrence.Builder builder) {
            for (Integer num : this.nums) {
                for (DayOfWeek day : this.days) {
                    builder.byDay(num, day);
                }
            }
        }
    }

    private class MDHandler
    implements TokenHandler {
        private MDHandler() {
        }

        @Override
        public Frequency frequency() {
            return Frequency.MONTHLY;
        }

        @Override
        public void processToken(String token, Recurrence.Builder builder) {
            try {
                Integer date = "LD".equals(token) ? -1 : RecurrenceParserV1.this.parseVCalInt(token);
                builder.byMonthDay(date);
            }
            catch (NumberFormatException e) {
                throw new CannotParseException(40, token);
            }
        }

        @Override
        public void noMoreTokens(Recurrence.Builder builder) {
        }
    }

    private class YMHandler
    implements TokenHandler {
        private YMHandler() {
        }

        @Override
        public Frequency frequency() {
            return Frequency.YEARLY;
        }

        @Override
        public void processToken(String token, Recurrence.Builder builder) {
            Integer month = RecurrenceParserV1.this.integerValueOf(token);
            builder.byMonth(month);
        }

        @Override
        public void noMoreTokens(Recurrence.Builder builder) {
        }
    }

    private class YDHandler
    implements TokenHandler {
        private YDHandler() {
        }

        @Override
        public Frequency frequency() {
            return Frequency.YEARLY;
        }

        @Override
        public void processToken(String token, Recurrence.Builder builder) {
            Integer dayOfYear = RecurrenceParserV1.this.integerValueOf(token);
            builder.byYearDay(dayOfYear);
        }

        @Override
        public void noMoreTokens(Recurrence.Builder builder) {
        }
    }

    private static interface TokenHandler {
        public Frequency frequency();

        public void processToken(String var1, Recurrence.Builder var2);

        public void noMoreTokens(Recurrence.Builder var1);
    }
}

