/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.DialogBox;
import java.util.Set;

public class DialogBoxParser
implements ElementParser {
    private static final String CAPTION = "caption";
    private static final String CUSTOM_CAPTION = "customCaption";

    @Override
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        String caption = null;
        FieldWriter body = null;
        XMLElement customCaption = null;
        String prefix = elem.getPrefix();
        for (XMLElement child : elem.consumeChildElements()) {
            if (CAPTION.equals(child.getLocalName())) {
                if (caption != null) {
                    writer.die(elem, "May have only one <%s:%s>", new Object[]{prefix, CAPTION});
                }
                HtmlInterpreter interpreter = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
                caption = child.consumeInnerHtml((XMLElement.Interpreter)interpreter);
                continue;
            }
            if (CUSTOM_CAPTION.equals(child.getLocalName())) {
                if (customCaption != null) {
                    writer.die(elem, "May only have one <%s:%s>", new Object[]{prefix, CUSTOM_CAPTION});
                }
                customCaption = child.consumeSingleChildElement();
                continue;
            }
            if (body != null) {
                writer.die(elem, "May have only one widget, but found %s and %s", new Object[]{body.getName(), child});
            }
            if (!writer.isWidgetElement(child)) {
                writer.die(elem, "Found non-widget %s", new Object[]{child});
            }
            body = writer.parseElementToField(child);
        }
        if (caption != null && customCaption != null) {
            writer.die("Must choose between <%s:%s> or <%s:%s>", new Object[]{prefix, CAPTION, prefix, CUSTOM_CAPTION});
        }
        this.handleConstructorArgs(elem, fieldName, type, writer, customCaption);
        if (caption != null) {
            writer.addStatement("%s.setHTML(%s);", new Object[]{fieldName, writer.declareTemplateCall(caption, fieldName)});
        }
        if (body != null) {
            writer.addStatement("%s.setWidget(%s);", new Object[]{fieldName, body.getNextReference()});
        }
    }

    protected boolean isCaption(UiBinderWriter writer, XMLElement element) throws UnableToCompleteException {
        JClassType type = writer.findFieldType(element);
        Set classes = type.getFlattenedSupertypeHierarchy();
        JClassType captionType = writer.getOracle().findType(DialogBox.Caption.class.getCanonicalName());
        return classes.contains(captionType);
    }

    protected boolean isCustomWidget(UiBinderWriter writer, JClassType type) {
        return !type.equals((Object)writer.getOracle().findType(DialogBox.class.getCanonicalName()));
    }

    void handleConstructorArgs(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer, XMLElement customCaption) throws UnableToCompleteException {
        boolean custom = this.isCustomWidget(writer, type);
        if (!custom) {
            String autoHide = elem.consumeBooleanAttribute("autoHide", false);
            String modal = elem.consumeBooleanAttribute("modal", true);
            if (customCaption != null) {
                if (!writer.isWidgetElement(customCaption)) {
                    writer.die(customCaption, "<%s:%s> must be a widget", new Object[]{customCaption.getPrefix(), CUSTOM_CAPTION});
                }
                if (!this.isCaption(writer, customCaption)) {
                    writer.die(customCaption, "<%s:%s> must implement %s", new Object[]{customCaption.getPrefix(), CUSTOM_CAPTION, DialogBox.Caption.class.getCanonicalName()});
                }
                FieldWriter fieldElement = writer.parseElementToField(customCaption);
                writer.setFieldInitializerAsConstructor(fieldName, new String[]{autoHide, modal, fieldElement.getNextReference()});
            } else {
                writer.setFieldInitializerAsConstructor(fieldName, new String[]{autoHide, modal});
            }
        }
    }
}

