/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor.survey;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyInterface;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstructorCourseRequirement;
import org.unitime.timetable.model.InstructorCourseRequirementNote;
import org.unitime.timetable.model.InstructorSurvey;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseCourseOffering;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.AccessDeniedException;

@GwtRpcImplements(value=InstructorSurveyInterface.InstructorSurveyCopyRequest.class)
public class CopyInstructorSurveyBackend
implements GwtRpcImplementation<InstructorSurveyInterface.InstructorSurveyCopyRequest, InstructorSurveyInterface.InstructorSurveyData> {
    @Override
    public InstructorSurveyInterface.InstructorSurveyData execute(InstructorSurveyInterface.InstructorSurveyCopyRequest request, SessionContext context) {
        InstructorSurvey is;
        if (!context.isAuthenticated() || context.getUser() == null || context.getUser().getCurrentAuthority() == null) {
            throw new AccessDeniedException();
        }
        Long sessionId = request.getData().getSessionId();
        if (sessionId == null) {
            sessionId = context.getUser().getCurrentAcademicSessionId();
        }
        final InstructorSurveyInterface.InstructorSurveyData survey = request.getData();
        if (context.getUser() == null || survey.getExternalId().equals(context.getUser().getExternalUserId())) {
            context.checkPermissionAnyAuthority(Right.InstructorSurvey, new SimpleQualifier("Session", sessionId));
        } else {
            context.checkPermissionAnySession(Right.InstructorSurveyAdmin, new SimpleQualifier("Session", sessionId));
        }
        if (request.getPreferencesSessionId() != null && (is = InstructorSurvey.getInstructorSurvey(survey.getExternalId(), request.getPreferencesSessionId())) != null) {
            survey.setNote(is.getNote());
            survey.getDistributionPreferences().clearSelections();
            survey.getTimePrefs().setPattern("");
            if (survey.hasRoomPreferences()) {
                for (InstructorSurveyInterface.Preferences preferences : survey.getRoomPreferences()) {
                    preferences.clearSelections();
                }
            }
            for (Preference preference : is.getPreferences()) {
                InstructorSurveyInterface.Problem prob;
                if (preference instanceof TimePref) {
                    TimePref tp = (TimePref)preference;
                    survey.getTimePrefs().setPattern(tp.getPreference());
                    survey.getTimePrefs().setNote(tp.getNote());
                    continue;
                }
                if (preference instanceof BuildingPref) {
                    BuildingPref bp = (BuildingPref)preference;
                    prob = InstructorSurveyInterface.Problem.NOT_APPLIED;
                    InstructorSurveyInterface.Preferences buildingPrefs = survey.getRoomPreference(-1L);
                    if (buildingPrefs == null) continue;
                    buildingPrefs.addSelection(new InstructorSurveyInterface.Selection(bp.getBuilding().getUniqueId(), bp.getPrefLevel().getUniqueId(), preference.getNote()).withProblem(prob));
                    continue;
                }
                if (preference instanceof RoomGroupPref) {
                    RoomGroupPref gp = (RoomGroupPref)preference;
                    InstructorSurveyInterface.Preferences groupPref = survey.getRoomPreference(-2L);
                    InstructorSurveyInterface.Problem prob2 = InstructorSurveyInterface.Problem.NOT_APPLIED;
                    if (groupPref == null) continue;
                    groupPref.addSelection(new InstructorSurveyInterface.Selection(gp.getRoomGroup().getUniqueId(), gp.getPrefLevel().getUniqueId(), preference.getNote()).withProblem(prob2));
                    continue;
                }
                if (preference instanceof RoomFeaturePref) {
                    RoomFeaturePref fp = (RoomFeaturePref)preference;
                    prob = InstructorSurveyInterface.Problem.NOT_APPLIED;
                    if (fp.getRoomFeature().getFeatureType() != null) {
                        InstructorSurveyInterface.Preferences prefs = survey.getRoomPreference(fp.getRoomFeature().getFeatureType().getUniqueId());
                        if (prefs == null) continue;
                        prefs.addSelection(new InstructorSurveyInterface.Selection(fp.getRoomFeature().getUniqueId(), fp.getPrefLevel().getUniqueId(), preference.getNote()).withProblem(prob));
                        continue;
                    }
                    InstructorSurveyInterface.Preferences featurePrefs = survey.getRoomPreference(-3L);
                    if (featurePrefs == null) continue;
                    featurePrefs.addSelection(new InstructorSurveyInterface.Selection(fp.getRoomFeature().getUniqueId(), fp.getPrefLevel().getUniqueId(), preference.getNote()).withProblem(prob));
                    continue;
                }
                if (preference instanceof DistributionPref) {
                    DistributionPref dp = (DistributionPref)preference;
                    if (!dp.getDistributionType().effectiveSurvey()) continue;
                    survey.getDistributionPreferences().addSelection(new InstructorSurveyInterface.Selection(dp.getDistributionType().getUniqueId(), dp.getPrefLevel().getUniqueId(), preference.getNote()));
                    continue;
                }
                if (!(preference instanceof RoomPref)) continue;
                RoomPref rp = (RoomPref)preference;
                prob = InstructorSurveyInterface.Problem.NOT_APPLIED;
                InstructorSurveyInterface.Preferences roomPrefs = survey.getRoomPreference(-4L);
                if (roomPrefs == null) continue;
                roomPrefs.addSelection(new InstructorSurveyInterface.Selection(rp.getRoom().getUniqueId(), rp.getPrefLevel().getUniqueId(), preference.getNote()).withProblem(prob));
            }
        }
        if (request.getCoursesSessionId() != null && (is = InstructorSurvey.getInstructorSurvey(survey.getExternalId(), request.getCoursesSessionId())) != null) {
            survey.clearCourses();
            HashSet<Long> courseIds = new HashSet<Long>();
            for (InstructorCourseRequirement r : is.getCourseRequirements()) {
                InstructorSurveyInterface.Course ci = new InstructorSurveyInterface.Course();
                ci.setReqId(r.getUniqueId());
                BaseCourseOffering course = null;
                if (r.getCourseOffering() != null && (course = CourseOffering.findBySubjectAreaCourseNbr(sessionId, r.getCourseOffering().getSubjectAreaAbbv(), r.getCourseOffering().getCourseNbr())) == null) continue;
                ci.setId(course == null ? null : course.getUniqueId());
                ci.setCourseName(course == null ? r.getCourse() : ((CourseOffering)course).getCourseName());
                ci.setCourseTitle(course == null ? null : course.getTitle());
                for (InstructorCourseRequirementNote n : r.getNotes()) {
                    InstructorSurveyInterface.CustomField cf = survey.getCustomField(n.getType().getUniqueId());
                    if (cf == null) continue;
                    ci.setCustomField(cf, n.getNote());
                }
                if (!ci.hasCustomFields()) continue;
                if (course != null) {
                    courseIds.add(course.getUniqueId());
                }
                survey.addCourse(ci);
            }
            boolean bl = ApplicationProperty.InstructorSurveyExcludeAuxiliaryAssignments.isTrue();
            String excludeCourseType = ApplicationProperty.InstructorSurveyExcludeCourseTypes.value();
            for (CourseOffering co : CourseOfferingDAO.getInstance().getSession().createQuery("select distinct co from DepartmentalInstructor i inner join i.classes ci inner join ci.classInstructing c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering io inner join io.courseOfferings co " + (bl ? "left outer join ci.responsibility r " : "") + "where co.isControl = true and io.notOffered = false and io.session.uniqueId = :sessionId and i.externalUniqueId=:id and ci.lead = true and c.schedulingSubpart.itype.organized = true" + (String)(bl ? " and (r is null or bitand(r.options, " + TeachingResponsibility.Option.auxiliary.toggle() + ") = 0)" : ""), CourseOffering.class).setParameter("id", (Object)survey.getExternalId()).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
                if (excludeCourseType != null && !excludeCourseType.isEmpty() && co.getCourseType() != null && co.getCourseType().getReference().matches(excludeCourseType) || !courseIds.add(co.getUniqueId())) continue;
                InstructorSurveyInterface.Course ci = new InstructorSurveyInterface.Course();
                ci.setId(co.getUniqueId());
                ci.setCourseName(co.getCourseName());
                ci.setCourseTitle(co.getTitle());
                survey.addCourse(ci);
            }
            if (survey.hasCourses()) {
                Collections.sort(survey.getCourses(), new Comparator<InstructorSurveyInterface.Course>(){

                    @Override
                    public int compare(InstructorSurveyInterface.Course co1, InstructorSurveyInterface.Course co2) {
                        int cmp = co1.getCourseName().compareTo(co2.getCourseName());
                        if (cmp != 0) {
                            return cmp;
                        }
                        for (InstructorSurveyInterface.CustomField f : survey.getCustomFields()) {
                            String cf2;
                            String cf1 = co1.getCustomField(f);
                            cmp = (cf1 == null ? "" : cf1).compareTo((cf2 = co2.getCustomField(f)) == null ? "" : cf2);
                            if (cmp == 0) continue;
                            return cmp;
                        }
                        return 0;
                    }
                });
            }
        }
        return survey;
    }
}

