/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.updates.CheckOfferingAction;
import org.unitime.timetable.onlinesectioning.updates.EnrollStudent;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;
import org.unitime.timetable.onlinesectioning.updates.StudentEmail;

public class MassCancelAction
implements OnlineSectioningAction<Boolean> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private List<Long> iStudentIds;
    private String iStatus;
    private boolean iEmail = false;
    private String iSubject;
    private String iMessage;
    private String iCC;

    public MassCancelAction forStudents(List<Long> studentIds) {
        this.iStudentIds = studentIds;
        return this;
    }

    public MassCancelAction withStatus(String status) {
        this.iStatus = status;
        return this;
    }

    public MassCancelAction withEmail(String subject, String message, String cc) {
        this.iEmail = true;
        this.iSubject = subject;
        this.iMessage = message;
        this.iCC = cc;
        return this;
    }

    public List<Long> getStudentIds() {
        return this.iStudentIds;
    }

    public String getStatus() {
        return this.iStatus;
    }

    public boolean hasStatus() {
        return this.iStatus != null && !this.iStatus.isEmpty();
    }

    public boolean changeStatus() {
        return !"-".equals(this.iStatus);
    }

    public String getSubject() {
        return this.iSubject;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public String getCC() {
        return this.iCC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Boolean execute(OnlineSectioningServer server, final OnlineSectioningHelper helper) {
        if (!server.getAcademicSession().isSectioningEnabled()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        Throwable caughtException = null;
        HashSet<Long> offeringsToCheck = new HashSet<Long>();
        OnlineSectioningServer.ServerCallback<Boolean> emailSent = new OnlineSectioningServer.ServerCallback<Boolean>(){

            @Override
            public void onFailure(Throwable exception) {
                helper.error("Student email failed: " + exception.getMessage(), exception);
            }

            @Override
            public void onSuccess(Boolean result) {
            }
        };
        StudentSectioningStatus status = this.changeStatus() && this.hasStatus() ? (StudentSectioningStatus)helper.getHibSession().createQuery("from StudentSectioningStatus where reference = :ref and (session is null or session.uniqueId = :sessionId)", StudentSectioningStatus.class).setParameter("ref", (Object)this.getStatus()).setParameter("sessionId", (Object)server.getAcademicSession().getUniqueId()).uniqueResult() : null;
        for (Long studentId : this.getStudentIds()) {
            OnlineSectioningServer.Lock lock = server.lockStudent(studentId, null, this.name());
            try {
                helper.beginTransaction();
                try {
                    Student student = (Student)StudentDAO.getInstance().get(studentId, helper.getHibSession());
                    if (student != null) {
                        XStudent oldStudent;
                        OnlineSectioningLog.Action.Builder action = helper.addAction(this, server.getAcademicSession(), true);
                        OnlineSectioningInterface.WaitListMode wlMode = student.getWaitListMode();
                        action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(student.getUniqueId()).setExternalId(student.getExternalUniqueId()).setName(helper.getStudentNameFormat().format(student)));
                        if (status != null) {
                            action.addOther(OnlineSectioningLog.Entity.newBuilder().setUniqueId(status.getUniqueId()).setName(status.getLabel()).setExternalId(status.getReference()).setType(OnlineSectioningLog.Entity.EntityType.OTHER));
                        }
                        if ((oldStudent = server.getStudent(studentId)) != null) {
                            for (XRequest xRequest : oldStudent.getRequests()) {
                                XEnrollment oldEnrollment;
                                XEnrollment xEnrollment = oldEnrollment = xRequest instanceof XCourseRequest ? ((XCourseRequest)xRequest).getEnrollment() : null;
                                if (oldEnrollment == null) continue;
                                offeringsToCheck.add(oldEnrollment.getOfferingId());
                                XOffering offering = server.getOffering(oldEnrollment.getOfferingId());
                                EnrollStudent.updateSpace(server, null, oldEnrollment == null ? null : SectioningRequest.convert(oldStudent, (XCourseRequest)xRequest, server, offering, oldEnrollment, wlMode, helper), offering);
                            }
                            OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                            enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                            for (XRequest oldRequest3 : oldStudent.getRequests()) {
                                XEnrollment oldEnrollment = oldRequest3 instanceof XCourseRequest ? ((XCourseRequest)oldRequest3).getEnrollment() : null;
                                if (oldEnrollment == null) continue;
                                for (XSection section : server.getOffering(oldEnrollment.getOfferingId()).getSections(oldEnrollment)) {
                                    enrollment.addSection(OnlineSectioningHelper.toProto(section, oldEnrollment));
                                }
                            }
                            action.addEnrollment(enrollment);
                        }
                        HashMap<Long, HashSet<Long>> enrollmentsToKeep = null;
                        if (CustomStudentEnrollmentHolder.hasProvider()) {
                            HashSet<Long> hashSet = new HashSet<Long>();
                            ArrayList<StudentEnrollmentProvider.EnrollmentRequest> enrollments = new ArrayList<StudentEnrollmentProvider.EnrollmentRequest>();
                            OnlineSectioningInterface.GradeModes gradeModes = new OnlineSectioningInterface.GradeModes();
                            boolean hasWaitListedCourses = false;
                            List<StudentEnrollmentProvider.EnrollmentFailure> failures = CustomStudentEnrollmentHolder.getProvider().enroll(server, helper, oldStudent, enrollments, hashSet, gradeModes, hasWaitListedCourses);
                            for (StudentEnrollmentProvider.EnrollmentFailure f : failures) {
                                HashSet<Long> sectionIds;
                                if (!f.isEnrolled()) continue;
                                if (enrollmentsToKeep == null) {
                                    enrollmentsToKeep = new HashMap<Long, HashSet<Long>>();
                                }
                                if ((sectionIds = (HashSet<Long>)enrollmentsToKeep.get(f.getCourse().getCourseId())) == null) {
                                    sectionIds = new HashSet<Long>();
                                    enrollmentsToKeep.put(f.getCourse().getCourseId(), sectionIds);
                                }
                                sectionIds.add(f.getSection().getSectionId());
                            }
                        }
                        Iterator<StudentClassEnrollment> iterator = student.getClassEnrollments().iterator();
                        while (iterator.hasNext()) {
                            StudentClassEnrollment enrl = iterator.next();
                            if (enrollmentsToKeep != null && enrollmentsToKeep.containsKey(enrl.getCourseOffering().getUniqueId()) && ((Set)enrollmentsToKeep.get(enrl.getCourseOffering().getUniqueId())).contains(enrl.getClazz().getUniqueId())) continue;
                            enrl.getClazz().getStudentEnrollments().remove(enrl);
                            helper.getHibSession().remove((Object)enrl);
                            iterator.remove();
                        }
                        Iterator<CourseDemand> iterator2 = student.getCourseDemands().iterator();
                        while (iterator2.hasNext()) {
                            CourseDemand cd = iterator2.next();
                            if (cd.getFreeTime() != null) {
                                helper.getHibSession().remove((Object)cd.getFreeTime());
                            }
                            Iterator<CourseRequest> j = cd.getCourseRequests().iterator();
                            while (j.hasNext()) {
                                CourseRequest cr = j.next();
                                Iterator<ClassWaitList> k = cr.getClassWaitLists().iterator();
                                while (k.hasNext()) {
                                    helper.getHibSession().remove((Object)k.next());
                                    k.remove();
                                }
                                if (enrollmentsToKeep != null && enrollmentsToKeep.containsKey(cr.getCourseOffering().getUniqueId())) {
                                    cr.setOrder(0);
                                    helper.getHibSession().merge((Object)cr);
                                    continue;
                                }
                                helper.getHibSession().remove((Object)cr);
                                j.remove();
                            }
                            if (cd.getCourseRequests().isEmpty()) {
                                helper.getHibSession().remove((Object)cd);
                                iterator2.remove();
                                continue;
                            }
                            cd.setAlternative(false);
                            cd.setWaitlist(false);
                        }
                        if (!student.getCourseDemands().isEmpty()) {
                            boolean bl = false;
                            for (CourseDemand cd : new TreeSet<CourseDemand>(student.getCourseDemands())) {
                                void var15_26;
                                cd.setPriority((int)(++var15_26));
                                helper.getHibSession().merge((Object)cd);
                            }
                        }
                        if (this.changeStatus()) {
                            student.setSectioningStatus(status);
                        }
                        helper.getHibSession().merge((Object)student);
                        helper.getHibSession().flush();
                        Object var15_27 = null;
                        try {
                            XStudent xStudent = ReloadAllData.loadStudent(student, null, server, helper, WaitList.WaitListType.MASS_CANCEL);
                            if (xStudent != null) {
                                server.update(xStudent, true);
                                OnlineSectioningLog.Enrollment.Builder enrollment = OnlineSectioningLog.Enrollment.newBuilder();
                                enrollment.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                                for (XRequest newRequest : xStudent.getRequests()) {
                                    action.addRequest(OnlineSectioningHelper.toProto(newRequest));
                                    if (!(newRequest instanceof XCourseRequest) || ((XCourseRequest)newRequest).getEnrollment() == null) continue;
                                    XEnrollment enrl = ((XCourseRequest)newRequest).getEnrollment();
                                    XOffering offering = server.getOffering(enrl.getOfferingId());
                                    for (XSection section : offering.getSections(enrl)) {
                                        enrollment.addSection(OnlineSectioningHelper.toProto(section, enrl));
                                    }
                                }
                                action.addEnrollment(enrollment);
                            }
                        }
                        catch (Exception e) {
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                        }
                        if (this.iEmail) {
                            StudentEmail email = server.createAction(StudentEmail.class).forStudent(studentId).fromAction(this.name()).oldStudent(oldStudent);
                            email.setCC(this.getCC());
                            email.setEmailSubject(this.getSubject() == null || this.getSubject().isEmpty() ? MSG.defaulSubjectMassCancel() : this.getSubject());
                            email.setMessage(this.getMessage());
                            server.execute(email, helper.getUser(), emailSent);
                        }
                    }
                    helper.commitTransaction();
                }
                catch (Exception e) {
                    helper.rollbackTransaction();
                    caughtException = e;
                }
            }
            finally {
                lock.release();
            }
        }
        OnlineSectioningServer.ServerCallback<Boolean> offeringChecked = new OnlineSectioningServer.ServerCallback<Boolean>(){

            @Override
            public void onFailure(Throwable exception) {
                helper.error("Offering check failed: " + exception.getMessage(), exception);
            }

            @Override
            public void onSuccess(Boolean result) {
            }
        };
        for (Long offeringId : offeringsToCheck) {
            server.persistExpectedSpaces(offeringId);
            server.execute(server.createAction(CheckOfferingAction.class).forOfferings(offeringId), helper.getUser(), offeringChecked);
        }
        if (caughtException != null) {
            if (caughtException instanceof SectioningException) {
                throw (SectioningException)caughtException;
            }
            throw new SectioningException(MSG.exceptionUnknown(caughtException.getMessage()), caughtException);
        }
        return true;
    }

    @Override
    public String name() {
        return "mass-cancel";
    }
}

