/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.specreg;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.WaitListValidationProvider;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.specreg.WaitListSubmitOverrides;

public class WaitListCheckValidation
implements OnlineSectioningAction<CourseRequestInterface.CheckCoursesResponse> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private CourseRequestInterface iRequest = null;
    private boolean iSubmitIfNoConfims = false;

    public WaitListCheckValidation withRequest(CourseRequestInterface request) {
        this.iRequest = request;
        return this;
    }

    public WaitListCheckValidation withSubmitIfNoConfirms(boolean submitIfNoConfims) {
        this.iSubmitIfNoConfims = submitIfNoConfims;
        return this;
    }

    public Long getStudentId() {
        return this.iRequest.getStudentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CourseRequestInterface.CheckCoursesResponse execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        if (!server.getAcademicSession().isSectioningEnabled() || !Customization.WaitListValidationProvider.hasProvider()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        CourseRequestInterface.CheckCoursesResponse response = new CourseRequestInterface.CheckCoursesResponse();
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        try {
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            XStudent student = server.getStudent(this.getStudentId());
            action.getStudentBuilder().setUniqueId(student.getStudentId()).setExternalId(student.getExternalId()).setName(student.getName());
            WaitListValidationProvider provider = (WaitListValidationProvider)Customization.WaitListValidationProvider.getProvider();
            provider.validate(server, helper, this.iRequest, response);
            if (response.hasMessages()) {
                for (CourseRequestInterface.CourseMessage m : response.getMessages()) {
                    if (!m.hasCourse()) continue;
                    action.addMessageBuilder().setText(m.toString()).setLevel(m.isError() ? OnlineSectioningLog.Message.Level.ERROR : (m.isConfirm() ? OnlineSectioningLog.Message.Level.WARN : OnlineSectioningLog.Message.Level.INFO));
                }
            }
            if (response.hasCreditNote()) {
                action.addMessageBuilder().setText(response.getCreditNote()).setLevel(OnlineSectioningLog.Message.Level.INFO);
            }
            if (response.hasCreditWarning()) {
                action.addMessageBuilder().setText(response.getCreditWarning()).setLevel(OnlineSectioningLog.Message.Level.WARN);
            }
            if (response.hasErrorMessage()) {
                action.addMessageBuilder().setText(response.getErrorMessage()).setLevel(OnlineSectioningLog.Message.Level.ERROR);
            }
            if (response.isError()) {
                action.setResult(OnlineSectioningLog.Action.ResultType.FAILURE);
            } else if (response.isConfirm()) {
                action.setResult(OnlineSectioningLog.Action.ResultType.FALSE);
            } else {
                action.setResult(OnlineSectioningLog.Action.ResultType.TRUE);
            }
        }
        finally {
            lock.release();
        }
        if (this.iSubmitIfNoConfims && !response.isConfirm()) {
            this.iRequest.addConfirmations(response.getMessages());
            new WaitListSubmitOverrides().withRequest(this.iRequest).execute(server, helper);
        }
        return response;
    }

    @Override
    public String name() {
        return "wait-validate";
    }
}

