/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.unitime.timetable.model.RefTableEntry;
import org.unitime.timetable.model.StudentGroupType;

@MappedSuperclass
public abstract class BaseStudentGroupType
extends RefTableEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean iKeepTogether;
    private Short iAllowDisabled;
    private Boolean iAdvisorsCanSet;

    public BaseStudentGroupType() {
    }

    public BaseStudentGroupType(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="together", nullable=false)
    public Boolean isKeepTogether() {
        return this.iKeepTogether;
    }

    @Transient
    public Boolean getKeepTogether() {
        return this.iKeepTogether;
    }

    public void setKeepTogether(Boolean keepTogether) {
        this.iKeepTogether = keepTogether;
    }

    @Column(name="allow_disabled", nullable=false)
    public Short getAllowDisabled() {
        return this.iAllowDisabled;
    }

    public void setAllowDisabled(Short allowDisabled) {
        this.iAllowDisabled = allowDisabled;
    }

    @Column(name="advisor", nullable=false)
    public Boolean isAdvisorsCanSet() {
        return this.iAdvisorsCanSet;
    }

    @Transient
    public Boolean getAdvisorsCanSet() {
        return this.iAdvisorsCanSet;
    }

    public void setAdvisorsCanSet(Boolean advisorsCanSet) {
        this.iAdvisorsCanSet = advisorsCanSet;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof StudentGroupType)) {
            return false;
        }
        if (this.getUniqueId() == null || ((StudentGroupType)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((StudentGroupType)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "StudentGroupType[" + this.getUniqueId() + " " + this.getLabel() + "]";
    }

    @Override
    public String toDebugString() {
        return "StudentGroupType[\n\tAdvisorsCanSet: " + this.getAdvisorsCanSet() + "\n\tAllowDisabled: " + this.getAllowDisabled() + "\n\tKeepTogether: " + this.getKeepTogether() + "\n\tLabel: " + this.getLabel() + "\n\tReference: " + this.getReference() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

