/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;

public class InstrOfferingConfigInterface
implements IsSerializable,
Serializable,
GwtRpcResponse,
GwtRpcRequest<InstrOfferingConfigInterface> {
    private static final long serialVersionUID = 6991472992890559070L;
    private List<SubpartLine> iSubpartLines = new ArrayList<SubpartLine>();
    private List<Reference> iDepartments;
    private List<Reference> iInstructionalMethods;
    private List<Reference> iDurationTypes;
    private List<Reference> iInstructionalTypes;
    private List<Reference> iConfigs;
    private Long iOfferingId;
    private Long iCourseId;
    private Long iConfigId;
    private Operation iOperation;
    private Integer iLimit;
    private Boolean iUnlimited;
    private Boolean iDisplayOptionForMaxLimit;
    private Boolean iDisplayMaxLimit;
    private Boolean iCanDelete;
    private Long iInstructionalMethodId;
    private Boolean iInstructionalMethodEditable;
    private Long iDurationTypeId;
    private String iDefaultDurationType;
    private Boolean iDurationTypeEditable;
    private String iCourseName;
    private String iConfigName;
    private long iLastGeneratedId = 0L;
    private Boolean iDisplayCourseLink;
    private Boolean iCheckLimits;
    private Integer iMaxNumberOfClasses;
    private String iOp;

    public InstrOfferingConfigInterface() {
    }

    public InstrOfferingConfigInterface(Operation op, Long offeringId, Long configId) {
        this.iOperation = op;
        this.iOfferingId = offeringId;
        this.iConfigId = configId;
    }

    public Long addSubpartLine(SubpartLine subpartLine) {
        if (subpartLine.getSubpartId() == null) {
            subpartLine.setSubpartId(--this.iLastGeneratedId);
        }
        this.iSubpartLines.add(subpartLine);
        return subpartLine.getSubpartId();
    }

    public SubpartLine addSubpartLine(Reference instructionalType) {
        SubpartLine subpartLine = new SubpartLine();
        subpartLine.setSubpartId(--this.iLastGeneratedId);
        subpartLine.setLabel(instructionalType.getLabel());
        subpartLine.setIType(instructionalType.getId().intValue());
        subpartLine.setRoomRatio(Float.valueOf(1.0f));
        subpartLine.setNumberOfRooms(1);
        subpartLine.setSplitAttendance(false);
        subpartLine.setIndent(0);
        this.iSubpartLines.add(subpartLine);
        return subpartLine;
    }

    public SubpartLine copy(SubpartLine classLine) {
        SubpartLine copy = new SubpartLine(classLine);
        copy.setSubpartId(--this.iLastGeneratedId);
        copy.setLabel(copy.getLabel() + this.iLastGeneratedId);
        Reference d = this.getDepartment(copy.getDepartmentId());
        if (d == null || !d.isSelectable()) {
            copy.setDepartmentId(null);
        }
        return copy;
    }

    public List<SubpartLine> getSubpartLines() {
        return this.iSubpartLines;
    }

    public Operation getOperation() {
        return this.iOperation;
    }

    public void setOperation(Operation operation) {
        this.iOperation = operation;
    }

    public void setConfigId(Long configId) {
        this.iConfigId = configId;
    }

    public Long getConfigId() {
        return this.iConfigId;
    }

    public void setLimit(Integer limit) {
        this.iLimit = limit;
    }

    public Integer getLimit() {
        return this.iLimit;
    }

    public void setUnlimited(Boolean unlimited) {
        this.iUnlimited = unlimited;
    }

    public Boolean isUnlimited() {
        return this.iUnlimited;
    }

    public void setOfferingId(Long offeringId) {
        this.iOfferingId = offeringId;
    }

    public Long getOfferingId() {
        return this.iOfferingId;
    }

    public void setCourseId(Long courseId) {
        this.iCourseId = courseId;
    }

    public Long getCourseId() {
        return this.iCourseId;
    }

    public void setCourseName(String name) {
        this.iCourseName = name;
    }

    public String getCourseName() {
        return this.iCourseName;
    }

    public void setConfigName(String name) {
        this.iConfigName = name;
    }

    public String getConfigName() {
        return this.iConfigName;
    }

    public void setInstructionalMethodId(Long instructionalMethodId) {
        this.iInstructionalMethodId = instructionalMethodId;
    }

    public Long getInstructionalMethodId() {
        return this.iInstructionalMethodId;
    }

    public void setDurationTypeId(Long durationTypeId) {
        this.iDurationTypeId = durationTypeId;
    }

    public Long getDurationTypeId() {
        return this.iDurationTypeId;
    }

    public void setDefaultDurationType(String durationType) {
        this.iDefaultDurationType = durationType;
    }

    public String getDefaultDurationType() {
        return this.iDefaultDurationType;
    }

    public boolean hasDefaultDurationType() {
        return this.iDefaultDurationType != null && !this.iDefaultDurationType.isEmpty();
    }

    public void setDisplayOptionForMaxLimit(boolean displayOptionForMaxLimit) {
        this.iDisplayOptionForMaxLimit = displayOptionForMaxLimit;
    }

    public boolean isDisplayOptionForMaxLimit() {
        return Boolean.TRUE.equals(this.iDisplayOptionForMaxLimit);
    }

    public void setDisplayMaxLimit(boolean displayMaxLimit) {
        this.iDisplayMaxLimit = displayMaxLimit;
    }

    public boolean isDisplayMaxLimit() {
        return Boolean.TRUE.equals(this.iDisplayMaxLimit);
    }

    public void setCanDelete(boolean canDelete) {
        this.iCanDelete = canDelete;
    }

    public boolean isCanDelete() {
        return Boolean.TRUE.equals(this.iCanDelete);
    }

    public void setInstructionalMethodEditable(boolean instructionalMethodEditable) {
        this.iInstructionalMethodEditable = instructionalMethodEditable;
    }

    public boolean isInstructionalMethodEditable() {
        return Boolean.TRUE.equals(this.iInstructionalMethodEditable);
    }

    public void setDurationTypeEditable(boolean durationTypeEditable) {
        this.iDurationTypeEditable = durationTypeEditable;
    }

    public boolean isDurationTypeEditable() {
        return Boolean.TRUE.equals(this.iDurationTypeEditable);
    }

    public void setDisplayCourseLink(boolean displayCourseLink) {
        this.iDisplayCourseLink = displayCourseLink;
    }

    public boolean isDisplayCourseLink() {
        return Boolean.TRUE.equals(this.iDisplayCourseLink);
    }

    public void setCheckLimits(boolean checkLimits) {
        this.iCheckLimits = checkLimits;
    }

    public boolean isCheckLimits() {
        return Boolean.TRUE.equals(this.iCheckLimits);
    }

    public void setMaxNumberOfClasses(Integer maxNumberOfClasses) {
        this.iMaxNumberOfClasses = maxNumberOfClasses;
    }

    public Integer getMaxNumberOfClasses() {
        return this.iMaxNumberOfClasses;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getOp() {
        return this.iOp;
    }

    public void addDepartment(Long id, String ref, String label, boolean selectable) {
        if (this.iDepartments == null) {
            this.iDepartments = new ArrayList<Reference>();
        }
        this.iDepartments.add(new Reference(id, ref, label, selectable));
    }

    public void addDepartment(Long id, String ref, String label) {
        this.addDepartment(id, ref, label, true);
    }

    public boolean hasDepartments() {
        return this.iDepartments != null && !this.iDepartments.isEmpty();
    }

    public List<Reference> getDepartments() {
        return this.iDepartments;
    }

    public Reference getDepartment(Long id) {
        if (this.iDepartments == null || id == null) {
            return null;
        }
        for (Reference ref : this.iDepartments) {
            if (!ref.getId().equals(id)) continue;
            return ref;
        }
        return null;
    }

    public void addInstructionalMethod(Long id, String ref, String label) {
        if (this.iInstructionalMethods == null) {
            this.iInstructionalMethods = new ArrayList<Reference>();
        }
        this.iInstructionalMethods.add(new Reference(id, ref, label, true));
    }

    public boolean hasInstructionalMethods() {
        return this.iInstructionalMethods != null && !this.iInstructionalMethods.isEmpty();
    }

    public List<Reference> getInstructionalMethods() {
        return this.iInstructionalMethods;
    }

    public Reference getInstructionalMethod(Long id) {
        if (this.iInstructionalMethods == null || id == null) {
            return null;
        }
        for (Reference ref : this.iInstructionalMethods) {
            if (!ref.getId().equals(id)) continue;
            return ref;
        }
        return null;
    }

    public void addDurationType(Long id, String ref, String label) {
        if (this.iDurationTypes == null) {
            this.iDurationTypes = new ArrayList<Reference>();
        }
        this.iDurationTypes.add(new Reference(id, ref, label, true));
    }

    public boolean hasDurationTypes() {
        return this.iDurationTypes != null && !this.iDurationTypes.isEmpty();
    }

    public List<Reference> getDurationTypes() {
        return this.iDurationTypes;
    }

    public Reference getDurationType(Long id) {
        if (this.iDurationTypes == null || id == null) {
            return null;
        }
        for (Reference ref : this.iDurationTypes) {
            if (!ref.getId().equals(id)) continue;
            return ref;
        }
        return null;
    }

    public void addConfig(Long id, String label) {
        if (this.iConfigs == null) {
            this.iConfigs = new ArrayList<Reference>();
        }
        this.iConfigs.add(new Reference(id, label, label, true));
    }

    public boolean hasConfigs() {
        return this.iConfigs != null && !this.iConfigs.isEmpty();
    }

    public List<Reference> getConfigs() {
        return this.iConfigs;
    }

    public List<SubpartLine> getParents(SubpartLine line) {
        ArrayList<SubpartLine> parents = new ArrayList<SubpartLine>();
        SubpartLine parent = this.getSubpartLine(line.getParentId());
        while (parent != null) {
            parents.add(parent);
            parent = this.getSubpartLine(parent.getParentId());
        }
        Collections.reverse(parents);
        return parents;
    }

    public List<SubpartLine> getParentsWithMe(SubpartLine line) {
        ArrayList<SubpartLine> parents = new ArrayList<SubpartLine>();
        SubpartLine parent = this.getSubpartLine(line.getParentId());
        while (parent != null) {
            parents.add(parent);
            parent = this.getSubpartLine(parent.getParentId());
        }
        Collections.reverse(parents);
        parents.add(line);
        return parents;
    }

    public List<SubpartLine> getSameParent(SubpartLine line) {
        ArrayList<SubpartLine> ret = new ArrayList<SubpartLine>();
        for (SubpartLine l : this.iSubpartLines) {
            if ((line.getParentId() != null || l.getParentId() != null) && (line.getParentId() == null || !line.getParentId().equals(l.getParentId()))) continue;
            ret.add(l);
        }
        return ret;
    }

    public void addInstructionalType(Long id, String ref, String label, boolean basic) {
        if (this.iInstructionalTypes == null) {
            this.iInstructionalTypes = new ArrayList<Reference>();
        }
        this.iInstructionalTypes.add(new Reference(id, ref, label, basic));
    }

    public boolean hasInstructionalTypes() {
        return this.iInstructionalTypes != null && !this.iInstructionalTypes.isEmpty();
    }

    public List<Reference> getInstructionalTypes() {
        return this.iInstructionalTypes;
    }

    public Reference getInstructionalType(Long id) {
        if (this.iInstructionalTypes == null || id == null) {
            return null;
        }
        for (Reference ref : this.iInstructionalTypes) {
            if (!ref.getId().equals(id)) continue;
            return ref;
        }
        return null;
    }

    public SubpartLine getSubpartLine(Long id) {
        if (id == null) {
            return null;
        }
        for (SubpartLine line : this.iSubpartLines) {
            if (!id.equals(line.getSubpartId())) continue;
            return line;
        }
        return null;
    }

    public List<SubpartLine> getLines(SubpartLine l) {
        if (l == null) {
            return null;
        }
        HashSet<Long> ids = new HashSet<Long>();
        ArrayList<SubpartLine> ret = new ArrayList<SubpartLine>();
        for (SubpartLine line : this.iSubpartLines) {
            if (l.getSubpartId().equals(line.getSubpartId())) {
                ids.add(line.getSubpartId());
                ret.add(line);
            }
            if (line.getParentId() == null || !ids.contains(line.getParentId())) continue;
            ids.add(line.getSubpartId());
            ret.add(line);
        }
        return ret;
    }

    public static enum Operation implements IsSerializable,
    Serializable
    {
        LOAD,
        SAVE,
        DELETE;

    }

    public static class SubpartLine
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 7969397309023277169L;
        private Long iSubpartId;
        private Integer iIType;
        private boolean iEditable = true;
        private boolean iCanDelete = true;
        private boolean iLocked = false;
        private Integer iMinClassLimit;
        private Integer iMaxClassLimit;
        private Integer iNumberOfClasses;
        private Integer iNumberOfRooms;
        private Integer iMinutesPerWeek;
        private Float iRoomRatio;
        private Long iParentId;
        private Long iDepartmentId;
        private Boolean iSplitAttendance;
        private Integer iIndent;
        private String iLabel;
        private String iError;

        public SubpartLine() {
            this.iEditable = true;
            this.iCanDelete = true;
            this.iLocked = false;
        }

        public SubpartLine(SubpartLine line) {
            this.iSubpartId = line.getSubpartId();
            this.iIType = line.getIType();
            this.iEditable = true;
            this.iCanDelete = true;
            this.iLocked = false;
            this.iMinClassLimit = line.getMinClassLimit();
            this.iMaxClassLimit = line.getMaxClassLimit();
            this.iNumberOfRooms = line.getNumberOfRooms();
            this.iMinutesPerWeek = line.getMinutesPerWeek();
            this.iRoomRatio = line.getRoomRatio();
            this.iParentId = line.getParentId();
            this.iDepartmentId = line.getDepartmentId();
            this.iSplitAttendance = line.getSplitAttendance();
            this.iIndent = line.getIndent();
            this.iNumberOfClasses = line.getNumberOfClasses();
        }

        public boolean hasSubpartId() {
            return this.iSubpartId != null;
        }

        public Long getSubpartId() {
            return this.iSubpartId;
        }

        public void setSubpartId(Long subpartId) {
            this.iSubpartId = subpartId;
        }

        public Integer getIType() {
            return this.iIType;
        }

        public void setIType(Integer itype) {
            this.iIType = itype;
        }

        public boolean isEditable() {
            return this.iEditable;
        }

        public void setEditable(boolean editable) {
            this.iEditable = editable;
        }

        public boolean isCanDelete() {
            return this.iCanDelete;
        }

        public void setCanDelete(boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public boolean isLocked() {
            return this.iLocked;
        }

        public void setLocked(boolean locked) {
            this.iLocked = locked;
        }

        public Integer getMinClassLimit() {
            return this.iMinClassLimit;
        }

        public void setMinClassLimit(Integer minClassLimit) {
            this.iMinClassLimit = minClassLimit;
        }

        public Integer getMaxClassLimit() {
            return this.iMaxClassLimit;
        }

        public void setMaxClassLimit(Integer maxClassLimit) {
            this.iMaxClassLimit = maxClassLimit;
        }

        public Integer getNumberOfRooms() {
            return this.iNumberOfRooms;
        }

        public void setNumberOfRooms(Integer numberOfRooms) {
            this.iNumberOfRooms = numberOfRooms;
        }

        public Float getRoomRatio() {
            return this.iRoomRatio;
        }

        public void setRoomRatio(Float roomRatio) {
            this.iRoomRatio = roomRatio;
        }

        public Long getParentId() {
            return this.iParentId;
        }

        public void setParentId(Long parentId) {
            this.iParentId = parentId;
        }

        public Long getDepartmentId() {
            return this.iDepartmentId;
        }

        public void setDepartmentId(Long departmentId) {
            this.iDepartmentId = departmentId;
        }

        public Boolean getSplitAttendance() {
            return this.iSplitAttendance;
        }

        public void setSplitAttendance(Boolean splitAttendance) {
            this.iSplitAttendance = splitAttendance;
        }

        public Integer getIndent() {
            return this.iIndent;
        }

        public void setIndent(Integer indent) {
            this.iIndent = indent;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public Integer getNumberOfClasses() {
            return this.iNumberOfClasses;
        }

        public void setNumberOfClasses(Integer numberOfClasses) {
            this.iNumberOfClasses = numberOfClasses;
        }

        public Integer getMinutesPerWeek() {
            return this.iMinutesPerWeek;
        }

        public void setMinutesPerWeek(Integer minutesPerWeek) {
            this.iMinutesPerWeek = minutesPerWeek;
        }

        public void setError(String error) {
            this.iError = error;
        }

        public void addError(String error) {
            this.iError = this.iError == null || this.iError.isEmpty() ? error : this.iError + "\n" + error;
        }

        public boolean hasError() {
            return this.iError != null && !this.iError.isEmpty();
        }

        public String getError() {
            return this.iError;
        }

        public int hashCode() {
            return this.getSubpartId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof SubpartLine)) {
                return false;
            }
            return this.getSubpartId().equals(((SubpartLine)o).getSubpartId());
        }
    }

    public static class Reference
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = -6683008505387009447L;
        private Long iId;
        private String iReference;
        private String iLabel;
        private boolean iSelectable = true;

        public Reference() {
        }

        public Reference(Long id, String ref, String label, boolean selectable) {
            this.iId = id;
            this.iReference = ref;
            this.iLabel = label;
            this.iSelectable = selectable;
        }

        public Long getId() {
            return this.iId;
        }

        public String getReference() {
            return this.iReference;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public boolean isSelectable() {
            return this.iSelectable;
        }

        public void setSelectable(boolean selectable) {
            this.iSelectable = selectable;
        }

        public String toString() {
            return this.getReference() + " - " + this.getLabel();
        }
    }

    public static enum InstrOfferingConfigColumn {
        ERROR,
        LABEL,
        BUTTONS,
        LIMIT,
        NBR_CLASSES,
        MINS_PER_WK,
        NBR_ROOMS,
        SPLIT_ATTENDANCE,
        ROOM_RATIO,
        DEPARTMENT;

    }
}

