/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.i18n.client.NumberFormat;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;

public class NumberBox
extends AriaTextBox {
    private boolean iDecimal = false;
    private boolean iNegative = false;

    public NumberBox() {
        this.setStyleName("gwt-SuggestBox");
        this.setWidth("100px");
        this.getElement().getStyle().setTextAlign(Style.TextAlign.RIGHT);
        final String decimalSeparator = LocaleInfo.getCurrentLocale().getNumberConstants().decimalSeparator();
        this.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                if (!NumberBox.this.isEnabled() || NumberBox.this.isReadOnly()) {
                    return;
                }
                int keyCode = event.getNativeEvent().getKeyCode();
                switch (keyCode) {
                    case 8: 
                    case 9: 
                    case 27: 
                    case 37: 
                    case 39: 
                    case 46: {
                        return;
                    }
                }
                if (NumberBox.this.isDecimal() && event.getCharCode() == '.' && !NumberBox.this.getValue().contains(".")) {
                    return;
                }
                if (NumberBox.this.isDecimal() && decimalSeparator != null && event.getCharCode() == decimalSeparator.charAt(0) && !NumberBox.this.getValue().contains(decimalSeparator)) {
                    return;
                }
                if (NumberBox.this.isNegative() && event.getCharCode() == '-' && !NumberBox.this.getValue().contains("-") && (NumberBox.this.getCursorPos() == 0 || NumberBox.this.getSelectionLength() == NumberBox.this.getValue().length())) {
                    return;
                }
                if (Character.isDigit(event.getCharCode())) {
                    return;
                }
                NumberBox.this.cancelKey();
            }
        });
    }

    public boolean isDecimal() {
        return this.iDecimal;
    }

    public void setDecimal(boolean decimal) {
        this.iDecimal = decimal;
    }

    public boolean isNegative() {
        return this.iNegative;
    }

    public void setNegative(boolean negative) {
        this.iNegative = negative;
    }

    public Double toDouble() {
        try {
            return NumberFormat.getDecimalFormat().parse(this.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(this.getValue());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public Float toFloat() {
        try {
            return Float.valueOf((float)NumberFormat.getDecimalFormat().parse(this.getValue()));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Float.valueOf(Float.parseFloat(this.getValue()));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public Integer toInteger() {
        try {
            return Integer.parseInt(this.getValue());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void setValue(Number number) {
        super.setValue((Object)(number == null ? "" : number.toString()));
    }
}

