/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.departments;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.admin.AdminCookie;
import org.unitime.timetable.gwt.client.departments.DepartmentsEdit;
import org.unitime.timetable.gwt.client.departments.DepartmentsTable;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.DepartmentInterface;

public class DepartmentsPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iPanel = new SimplePanel();
    private SimpleForm iListDepartmentsForm = new SimpleForm();
    private UniTimeHeaderPanel iListDepartmentsHeader;
    private UniTimeHeaderPanel iListDepartmentsFooter;
    private DepartmentsTable iDepartmentsTable;
    private DepartmentInterface.DepartmentsDataResponse departmentsDataFullList;
    private DepartmentsEdit iDepartmentsEdit;
    private CheckBox iShowAllDept;

    public DepartmentsPage() {
        this.iListDepartmentsForm.addStyleName("unitime-Dept");
        this.iListDepartmentsHeader = new UniTimeHeaderPanel(MESSAGES.sectDepartments());
        this.iListDepartmentsHeader.addButton("add", MESSAGES.buttonAddDepartment(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                DepartmentsPage.this.addDepartment();
            }
        });
        this.iListDepartmentsHeader.addButton("export", MESSAGES.buttonExportPDF(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?output=departments.pdf&sort=" + DepartmentsPage.this.iDepartmentsTable.getSortBy() + "&showAllDept=" + DepartmentsPage.this.iShowAllDept.getValue());
            }
        });
        this.iListDepartmentsForm.addHeaderRow((Widget)this.iListDepartmentsHeader);
        this.iDepartmentsTable = new DepartmentsTable();
        this.iListDepartmentsForm.addRow((Widget)this.iDepartmentsTable);
        this.iListDepartmentsFooter = this.iListDepartmentsHeader.clonePanel("");
        this.iShowAllDept = new CheckBox(MESSAGES.checkShowAllDepartments());
        this.iListDepartmentsFooter.insertLeft((Widget)this.iShowAllDept, true);
        this.iListDepartmentsForm.addBottomRow((Widget)this.iListDepartmentsFooter);
        this.iShowAllDept.setValue(Boolean.valueOf(AdminCookie.getInstance().getShowAllDepartments() == 1));
        this.iShowAllDept.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
                AdminCookie.getInstance().setShowAllDepartments(DepartmentsPage.this.iShowAllDept.getValue() != false ? 1 : 0);
                DepartmentsPage.this.listDepartments();
            }
        });
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        this.listDepartments();
        this.iDepartmentsEdit = new DepartmentsEdit(){

            @Override
            protected void onBack(boolean refresh, final Long DepartmentId) {
                DepartmentsPage.this.iPanel.setWidget((Widget)DepartmentsPage.this.iListDepartmentsForm);
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageDepartments());
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                if (refresh) {
                    LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
                    RPC.execute(new DepartmentInterface.GetDepartmentsRequest(), new AsyncCallback<DepartmentInterface.DepartmentsDataResponse>(){

                        public void onSuccess(DepartmentInterface.DepartmentsDataResponse result) {
                            DepartmentsPage.this.departmentsDataFullList = result;
                            DepartmentsPage.this.iListDepartmentsHeader.setEnabled("add", result.isCanAdd());
                            DepartmentsPage.this.iListDepartmentsHeader.setEnabled("export", result.isCanExportPdf());
                            DepartmentsPage.this.iDepartmentsTable.setHeaderData(result.isFundingDeptEnabled());
                            DepartmentsPage.this.iDepartmentsTable.setData(result.getDepartments(), DepartmentsPage.this.iShowAllDept.getValue(), result.isFundingDeptEnabled());
                            LoadingWidget.getInstance().hide();
                            if (DepartmentId != null) {
                                for (int i = 0; i < DepartmentsPage.this.iDepartmentsTable.getRowCount(); ++i) {
                                    DepartmentInterface b = (DepartmentInterface)DepartmentsPage.this.iDepartmentsTable.getData(i);
                                    if (b == null || !b.getId().equals(DepartmentId)) continue;
                                    DepartmentsPage.this.iDepartmentsTable.getRowFormatter().getElement(i).scrollIntoView();
                                    DepartmentsPage.this.iDepartmentsTable.setSelected(i, true);
                                    break;
                                }
                            }
                        }

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(DepartmentsEdit.MESSAGES.failedLoadData(caught.getMessage()), caught);
                            DepartmentsPage.this.iListDepartmentsHeader.setErrorMessage(DepartmentsEdit.MESSAGES.failedLoadData(caught.getMessage()));
                            ToolBox.checkAccess(caught);
                        }
                    });
                } else {
                    if (DepartmentsPage.this.iDepartmentsTable.getSelectedRow() >= 0) {
                        DepartmentsPage.this.iDepartmentsTable.setSelected(DepartmentsPage.this.iDepartmentsTable.getSelectedRow(), false);
                    }
                    if (DepartmentId != null) {
                        for (int i = 0; i < DepartmentsPage.this.iDepartmentsTable.getRowCount(); ++i) {
                            DepartmentInterface b = (DepartmentInterface)DepartmentsPage.this.iDepartmentsTable.getData(i);
                            if (b == null || !b.getId().equals(DepartmentId)) continue;
                            DepartmentsPage.this.iDepartmentsTable.getRowFormatter().getElement(i).scrollIntoView();
                            DepartmentsPage.this.iDepartmentsTable.setSelected(i, true);
                            break;
                        }
                    }
                }
            }

            @Override
            protected boolean isAbbreviationUnique(DepartmentInterface department) {
                if (!DepartmentsPage.this.departmentsDataFullList.hasDepartments()) {
                    return true;
                }
                List<DepartmentInterface> departmentFullList = DepartmentsPage.this.departmentsDataFullList.getDepartments();
                for (int i = 0; i < departmentFullList.size(); ++i) {
                    DepartmentInterface b = departmentFullList.get(i);
                    if (department.getAbbreviation() == null || b == null || b.getId().equals(department.getId()) || b.getAbbreviation() == null || !b.getAbbreviation().equalsIgnoreCase(department.getAbbreviation())) continue;
                    return false;
                }
                return true;
            }

            @Override
            protected boolean isDeptCodeUnique(DepartmentInterface department) {
                if (!DepartmentsPage.this.departmentsDataFullList.hasDepartments()) {
                    return true;
                }
                List<DepartmentInterface> departmentFullList = DepartmentsPage.this.departmentsDataFullList.getDepartments();
                for (int i = 0; i < departmentFullList.size(); ++i) {
                    DepartmentInterface b = departmentFullList.get(i);
                    if (department.getDeptCode() == null || b == null || b.getId().equals(department.getId()) || !b.getDeptCode().equalsIgnoreCase(department.getDeptCode())) continue;
                    return false;
                }
                return true;
            }
        };
        this.iPanel.setWidget((Widget)this.iListDepartmentsForm);
        this.initWidget((Widget)this.iPanel);
    }

    protected void addDepartment() {
        RPC.execute(new DepartmentInterface.DepartmentPropertiesRequest(null), new AsyncCallback<DepartmentInterface.DepartmentPropertiesInterface>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                DepartmentsPage.this.iListDepartmentsHeader.setErrorMessage(MESSAGES.failedCreate(MESSAGES.objectDepartment(), caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedCreate(MESSAGES.objectDepartment(), caught.getMessage()), caught);
            }

            public void onSuccess(DepartmentInterface.DepartmentPropertiesInterface result) {
                if (result.getCanEdit()) {
                    DepartmentsPage.this.iDepartmentsEdit.setProperties(result);
                    DepartmentsPage.this.iDepartmentsEdit.setValue(null);
                    DepartmentsPage.this.iPanel.setWidget((Widget)DepartmentsPage.this.iDepartmentsEdit);
                    DepartmentsPage.this.iDepartmentsEdit.show();
                    UniTimePageLabel.getInstance().setPageName(MESSAGES.pageAddDepartment());
                    DepartmentsPage.this.iDepartmentsTable.clearHover();
                    Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                }
            }
        });
    }

    protected void editDepartment(final DepartmentInterface department) {
        RPC.execute(new DepartmentInterface.DepartmentPropertiesRequest(department.getUniqueId()), new AsyncCallback<DepartmentInterface.DepartmentPropertiesInterface>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                DepartmentsPage.this.iListDepartmentsHeader.setErrorMessage(MESSAGES.failedCreate(MESSAGES.objectDepartment(), caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedUpdate(MESSAGES.objectDepartment(), caught.getMessage()), caught);
            }

            public void onSuccess(DepartmentInterface.DepartmentPropertiesInterface result) {
                if (result.getCanEdit()) {
                    DepartmentsPage.this.iDepartmentsEdit.setProperties(result);
                    DepartmentsPage.this.iDepartmentsEdit.setValue(department);
                    DepartmentsPage.this.iPanel.setWidget((Widget)DepartmentsPage.this.iDepartmentsEdit);
                    DepartmentsPage.this.iDepartmentsEdit.show();
                    UniTimePageLabel.getInstance().setPageName(MESSAGES.pageEditDepartment());
                    DepartmentsPage.this.iDepartmentsTable.clearHover();
                    Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                }
            }
        });
    }

    protected void listDepartments() {
        RPC.execute(new DepartmentInterface.GetDepartmentsRequest(), new AsyncCallback<DepartmentInterface.DepartmentsDataResponse>(){

            public void onSuccess(DepartmentInterface.DepartmentsDataResponse result) {
                DepartmentsPage.this.departmentsDataFullList = result;
                DepartmentsPage.this.iListDepartmentsHeader.setEnabled("add", result.isCanAdd());
                DepartmentsPage.this.iListDepartmentsHeader.setEnabled("export", result.isCanExportPdf());
                DepartmentsPage.this.iDepartmentsTable.removeAllRows();
                DepartmentsPage.this.iDepartmentsTable.setHeaderData(result.isFundingDeptEnabled());
                DepartmentsPage.this.iDepartmentsTable.setAllowSelection(true);
                DepartmentsPage.this.iDepartmentsTable.setAllowMultiSelect(false);
                DepartmentsPage.this.iDepartmentsTable.setData(result.getDepartments(), DepartmentsPage.this.iShowAllDept.getValue(), result.isFundingDeptEnabled());
                LoadingWidget.getInstance().hide();
                DepartmentsPage.this.iDepartmentsTable.addMouseClickListener(new UniTimeTable.MouseClickListener<DepartmentInterface>(){

                    @Override
                    public void onMouseClick(UniTimeTable.TableEvent<DepartmentInterface> event) {
                        if (event.getData() != null) {
                            DepartmentsPage.this.iDepartmentsTable.setSelected(event.getRow(), true);
                            DepartmentsPage.this.editDepartment(event.getData());
                        }
                    }
                });
            }

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                UniTimeNotifications.error(MESSAGES.failedLoadData(caught.getMessage()), caught);
                DepartmentsPage.this.iListDepartmentsHeader.setErrorMessage(MESSAGES.failedLoadData(caught.getMessage()));
                ToolBox.checkAccess(caught);
            }
        });
    }
}

