/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.instructors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.client.instructor.TeachingAssignmentsPage;
import org.unitime.timetable.gwt.client.instructor.TeachingRequestsTable;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.server.instructor.TeachingRequestsPageBackend;
import org.unitime.timetable.util.Formats;

@Service(value="org.unitime.timetable.export.Exporter:teaching-requests.csv")
public class TeachingRequestsExportCSV
implements Exporter {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static final StudentSectioningMessages SECTMSG = Localization.create(StudentSectioningMessages.class);
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    @Override
    public String reference() {
        return "teaching-requests.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        int sort;
        Long sessionId;
        InstructorInterface.TeachingRequestsPageRequest request = new InstructorInterface.TeachingRequestsPageRequest();
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String command = e.nextElement();
            if (command.equals("r:text")) {
                request.getFilter().setText(helper.getParameter("r:text"));
                continue;
            }
            if (!command.startsWith("r:")) continue;
            for (String value : helper.getParameterValues(command)) {
                request.getFilter().addOption(command.substring(2), value);
            }
        }
        if (helper.getParameter("subjectId") != null) {
            request.getFilter().addOption("subjectId", helper.getParameter("subjectId"));
        } else if (helper.getParameter("subject") != null) {
            sessionId = helper.getAcademicSessionId();
            if (sessionId == null) {
                throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
            }
            SubjectArea subject = SubjectArea.findByAbbv(sessionId, helper.getParameter("subject"));
            if (subject == null) {
                throw new IllegalArgumentException("Subject area " + helper.getParameter("subject") + " does not exist.");
            }
            request.getFilter().addOption("subjectId", subject.getUniqueId().toString());
        }
        if (helper.getParameter("offeringId") != null) {
            request.getFilter().addOption("offeringId", helper.getParameter("offeringId"));
        } else if (helper.getParameter("course") != null) {
            sessionId = helper.getAcademicSessionId();
            if (sessionId == null) {
                throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
            }
            CourseOffering course = CourseOffering.findByName(helper.getParameter("course"), sessionId);
            if (course == null) {
                throw new IllegalArgumentException("Course offering " + helper.getParameter("course") + " does not exist.");
            }
            request.getFilter().addOption("offeringId", course.getInstructionalOffering().getUniqueId().toString());
        }
        if (helper.getParameter("assigned") != null) {
            request.getFilter().addOption("assigned", "true".equalsIgnoreCase(helper.getParameter("assigned")) || "1".equals(helper.getParameter("assigned")) ? "true" : "false");
        }
        ArrayList<TeachingAssignmentsPage.SingleTeachingAssingment> list = new ArrayList<TeachingAssignmentsPage.SingleTeachingAssingment>();
        boolean hasInstructors = false;
        for (InstructorInterface.TeachingRequestInfo req : new TeachingRequestsPageBackend().execute(request, helper.getSessionContext())) {
            if (!request.getFilter().hasOption("assigned")) {
                if (req.hasInstructors()) {
                    for (InstructorInterface.InstructorInfo instructor : req.getInstructors()) {
                        list.add(new TeachingAssignmentsPage.SingleTeachingAssingment(instructor, req));
                        hasInstructors = true;
                    }
                    continue;
                }
                list.add(new TeachingAssignmentsPage.SingleTeachingAssingment(null, req));
                continue;
            }
            if ("true".equalsIgnoreCase(request.getFilter().getOption("assigned")) && req.hasInstructors()) {
                for (InstructorInterface.InstructorInfo instructor : req.getInstructors()) {
                    if (!instructor.isMatchingFilter()) continue;
                    list.add(new TeachingAssignmentsPage.SingleTeachingAssingment(instructor, req));
                    hasInstructors = true;
                }
                continue;
            }
            if ("true".equalsIgnoreCase(request.getFilter().getOption("assigned")) || req.getNrAssignedInstructors() >= req.getNrInstructors()) continue;
            list.add(new TeachingAssignmentsPage.SingleTeachingAssingment(null, req));
        }
        if (helper.getParameter("sort") != null && (sort = Integer.parseInt(helper.getParameter("sort"))) != 0) {
            TeachingRequestsTable.TableComparator cmp = new TeachingRequestsTable.TableComparator(TeachingRequestsTable.COLUMN.values()[Math.abs(sort) - 1]);
            Collections.sort(list, sort < 0 ? Collections.reverseOrder(cmp) : cmp);
        }
        int cookie = 65535;
        if (helper.getParameter("columns") != null) {
            cookie = Integer.parseInt(helper.getParameter("columns"));
        }
        this.export(request, list, helper, hasInstructors, cookie);
    }

    protected void export(InstructorInterface.TeachingRequestsPageRequest request, List<TeachingAssignmentsPage.SingleTeachingAssingment> list, ExportHelper helper, boolean hasInstructors, int cookie) throws IOException {
        CSVPrinter out = new CSVPrinter(helper, false);
        helper.setup(out.getContentType(), this.reference(), false);
        ArrayList<Column> columns = new ArrayList<Column>();
        for (TeachingRequestsTable.COLUMN column : TeachingRequestsTable.COLUMN.values()) {
            int nrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                Column c = new Column(column, idx);
                if (!this.isColumnVisible(c, hasInstructors, cookie)) continue;
                columns.add(c);
            }
        }
        String[] header = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            header[i] = this.getColumnName((Column)columns.get(i)).replace("<br>", "\n");
        }
        out.printHeader(header);
        out.flush();
        InstructorInterface.TeachingRequestInfo last = null;
        for (TeachingAssignmentsPage.SingleTeachingAssingment a : list) {
            String[] row = new String[columns.size()];
            if (last != null && last.equals(a.getRequest())) {
                for (i = 0; i < columns.size(); ++i) {
                    row[i] = ((Column)columns.get(i)).getColumn().isHasInstructor() ? this.getCell(a.getRequest(), a.getInstructor(), (Column)columns.get(i)) : null;
                }
            } else {
                for (i = 0; i < columns.size(); ++i) {
                    row[i] = this.getCell(a.getRequest(), a.getInstructor(), (Column)columns.get(i));
                }
            }
            out.printLine(row);
            out.flush();
            last = a.getRequest();
        }
        out.flush();
        out.close();
    }

    public int getNbrCells(TeachingRequestsTable.COLUMN column) {
        return 1;
    }

    public boolean isColumnVisible(Column column, boolean hasInstructors, int cookie) {
        boolean visible;
        boolean bl = visible = !column.getColumn().isCanHide() || (cookie & 1 << column.getColumn().ordinal()) != 0;
        if (!hasInstructors && column.getColumn().isCanHide() && column.getColumn().isHasInstructor()) {
            visible = false;
        }
        return visible;
    }

    public String getColumnName(Column column) {
        switch (column.getColumn()) {
            case COURSE: {
                return MESSAGES.colCourse();
            }
            case SECTION: {
                return MESSAGES.colSection();
            }
            case TIME: {
                return MESSAGES.colTime();
            }
            case DATE: {
                return MESSAGES.colDate();
            }
            case ROOM: {
                return MESSAGES.colRoom();
            }
            case LOAD: {
                return MESSAGES.colTeachingLoad();
            }
            case ATTRIBUTE_PREFS: {
                return MESSAGES.colAttributePreferences();
            }
            case INSTRUCTOR_PREFS: {
                return MESSAGES.colInstructorPreferences();
            }
            case EXTERNAL_ID: {
                return MESSAGES.colExternalId();
            }
            case NAME: {
                return MESSAGES.colNamePerson();
            }
            case ATTRIBUTES: {
                return MESSAGES.colAttributes();
            }
            case COURSE_PREF: {
                return MESSAGES.colCoursePreferences();
            }
            case DISTRIBUTION_PREF: {
                return MESSAGES.colDistributionPreferences();
            }
            case TIME_PREF: {
                return MESSAGES.colTimePreferences();
            }
            case ASSIGNED_LOAD: {
                return MESSAGES.colAssignedLoad();
            }
            case OBJECTIVES: {
                return MESSAGES.colObjectives();
            }
            case ASSIGNED_INSTRUCTORS: {
                return MESSAGES.colAssignedInstructors();
            }
        }
        return column.getColumn().name();
    }

    public String getCell(InstructorInterface.TeachingRequestInfo request, InstructorInterface.InstructorInfo instructor, Column column) {
        switch (column.getColumn()) {
            case COURSE: {
                return request.getCourse().getCourseName();
            }
            case SECTION: {
                Object sections = "";
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    sections = (String)sections + (((String)sections).isEmpty() ? "" : "\n") + s.getSectionType() + (String)(s.getExternalId() == null ? "" : " " + s.getExternalId());
                }
                return sections;
            }
            case TIME: {
                Object times = "";
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    times = (String)times + (((String)times).isEmpty() ? "" : "\n") + (s.getTime() == null ? SECTMSG.arrangeHours() : s.getTime());
                }
                return times;
            }
            case DATE: {
                Object dates = "";
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    dates = (String)dates + (((String)dates).isEmpty() ? "" : "\n") + (s.getDate() == null ? SECTMSG.noDate() : s.getDate());
                }
                return dates;
            }
            case ROOM: {
                Object rooms = "";
                for (InstructorInterface.SectionInfo s : request.getSections()) {
                    rooms = (String)rooms + (((String)rooms).isEmpty() ? "" : "\n") + (s.getRoom() == null ? SECTMSG.noRoom() : s.getRoom());
                }
                return rooms;
            }
            case LOAD: {
                return Formats.getNumberFormat(CONSTANTS.teachingLoadFormat()).format(Float.valueOf(request.getLoad()));
            }
            case EXTERNAL_ID: {
                return instructor == null ? null : instructor.getExternalId();
            }
            case NAME: {
                return instructor == null ? null : instructor.getInstructorName();
            }
            case ATTRIBUTE_PREFS: {
                return this.preferences(request.getAttributePreferences());
            }
            case INSTRUCTOR_PREFS: {
                return this.preferences(request.getInstructorPreferences());
            }
            case COURSE_PREF: {
                if (instructor == null) {
                    return null;
                }
                return this.preferences(instructor.getCoursePreferences());
            }
            case DISTRIBUTION_PREF: {
                if (instructor == null) {
                    return null;
                }
                return this.preferences(instructor.getDistributionPreferences());
            }
            case TIME_PREF: {
                if (instructor == null) {
                    return null;
                }
                return this.preferences(instructor.getTimePreferences());
            }
            case ATTRIBUTES: {
                if (instructor == null) {
                    return null;
                }
                Object attributes = "";
                for (InstructorInterface.AttributeInterface attribute : instructor.getAttributes()) {
                    attributes = (String)attributes + (((String)attributes).isEmpty() ? "" : "\n") + attribute.getName() + (String)(attribute.hasType() ? " (" + attribute.getType().getLabel() + ")" : "");
                }
                return attributes;
            }
            case ASSIGNED_LOAD: {
                if (instructor == null) {
                    return null;
                }
                return Formats.getNumberFormat(CONSTANTS.teachingLoadFormat()).format(Float.valueOf(instructor.getAssignedLoad())) + " / " + Formats.getNumberFormat(CONSTANTS.teachingLoadFormat()).format(Float.valueOf(instructor.getMaxLoad()));
            }
            case OBJECTIVES: {
                if (instructor == null) {
                    return null;
                }
                Object objectives = "";
                for (String key : new TreeSet<String>(instructor.getValues().keySet())) {
                    Double value = instructor.getValues().get(key);
                    if (value == null || Math.abs(value) < 0.001) continue;
                    objectives = (String)objectives + (((String)objectives).isEmpty() ? "" : "\n") + key + ": " + (value > 0.0 ? "+" : "") + Formats.getNumberFormat(CONSTANTS.teachingLoadFormat()).format(value);
                }
                return objectives;
            }
            case ASSIGNED_INSTRUCTORS: {
                return request.getNrAssignedInstructors() + " / " + request.getNrInstructors();
            }
        }
        return null;
    }

    public String preferences(List<InstructorInterface.PreferenceInfo> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Object ret = "";
        for (InstructorInterface.PreferenceInfo pref : list) {
            ret = (String)ret + (((String)ret).isEmpty() ? "" : "\n") + PreferenceLevel.prolog2abbv(pref.getPreference()) + " " + pref.getOwnerName();
        }
        return ret;
    }

    protected static class Column {
        private TeachingRequestsTable.COLUMN iColumn;
        private int iIndex;

        Column(TeachingRequestsTable.COLUMN column, int index) {
            this.iColumn = column;
            this.iIndex = index;
        }

        public int getIndex() {
            return this.iIndex;
        }

        public TeachingRequestsTable.COLUMN getColumn() {
            return this.iColumn;
        }
    }
}

