/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import jakarta.servlet.ServletRequest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ExamEditForm;
import org.unitime.timetable.form.InstructionalOfferingListForm;
import org.unitime.timetable.form.PreferencesForm;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.InstructorAttributeDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.PeriodPreferencesBackend;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.interactive.Hint;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.RequiredTimeTable;

public abstract class PreferencesAction2<T extends PreferencesForm>
extends UniTimeAction<T> {
    private static final long serialVersionUID = 1693039471914780672L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    public static final String TIME_PATTERN_GRID_ATTR = "timePatternGrid";
    public static final String HASH_ATTR = "hash";
    public final String HASH_TIME_PREF = "TimePref";
    public final String HASH_RM_GROUP = "RoomGroupPref";
    public final String HASH_RM_PREF = "RoomPref";
    public final String HASH_RM_FEAT_PREF = "RoomFeatPref";
    public final String HASH_BLDG_PREF = "BldgPref";
    public final String HASH_DIST_PREF = "DistPref";
    public final String HASH_PERIOD_PREF = "PeriodPref";
    public final String HASH_DATE_PATTERN_PREF = "DatePatternPref";
    public final String HASH_COURSE_PREF = "CoursePref";
    public final String HASH_INSTRUCTOR_PREF = "InstructorPref";
    public final String HASH_ATTRIBUTE_PREF = "AttributePref";

    public String execute() throws Exception {
        LookupTables.setupItypes(this.request, true);
        LookupTables.setupPrefLevels(this.request);
        this.request.setAttribute("prefLevelsSoftList", PreferenceLevel.getPreferenceLevelListSoftOnly());
        return null;
    }

    protected void processPrefAction() {
        if (this.op == null) {
            this.op = ((PreferencesForm)this.form).getOp();
        }
        if (this.op == null) {
            return;
        }
        if (MSG.actionAddRoomGroupPreference().equals(this.op)) {
            this.addRoomGroup();
        }
        if (MSG.actionAddRoomPreference().equals(this.op)) {
            this.addRoomPref();
        }
        if (MSG.actionAddBuildingPreference().equals(this.op)) {
            this.addBldgPref();
        }
        if (MSG.actionAddDistributionPreference().equals(this.op)) {
            this.addDistPref();
        }
        if (MSG.actionAddRoomFeaturePreference().equals(this.op)) {
            this.addRoomFeatPref();
        }
        if (MSG.actionAddTimePreference().equals(this.op)) {
            this.addTimePattern();
        }
        if (MSG.actionAddCoursePreference().equals(this.op)) {
            this.addCoursePref();
        }
        if (MSG.actionAddInstructorPreference().equals(this.op)) {
            this.addInstructorPref();
        }
        if (MSG.actionAddAttributePreference().equals(this.op)) {
            this.addAttributePref();
        }
        if (MSG.actionRemoveBuildingPreference().equals(this.op) || MSG.actionRemoveDistributionPreference().equals(this.op) || MSG.actionRemoveRoomFeaturePreference().equals(this.op) || MSG.actionRemoveRoomGroupPreference().equals(this.op) || MSG.actionRemoveRoomPreference().equals(this.op) || MSG.actionRemoveTimePattern().equals(this.op) || MSG.actionRemoveInstructor().equals(this.op) || MSG.actionRemoveCoursePreference().equals(this.op) || MSG.actionRemoveAttributePreference().equals(this.op) || MSG.actionRemoveInstructorPreference().equals(this.op)) {
            this.doDelete();
        }
    }

    private void addRoomGroup() {
        List<String> lst = ((PreferencesForm)this.form).getRoomGroups();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToRoomGroups("-", "-", null);
            }
            this.request.setAttribute(HASH_ATTR, (Object)"RoomGroupPref");
        } else {
            this.addFieldError("roomGroup", MSG.errorInvalidRoomGroup());
        }
    }

    protected void addBldgPref() {
        List<String> lst = ((PreferencesForm)this.form).getBldgPrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToBldgPrefs("-", "-", null);
            }
            this.request.setAttribute(HASH_ATTR, (Object)"BldgPref");
        } else {
            this.addFieldError("bldgPrefs", MSG.errorInvalidBuildingPreference());
        }
    }

    protected void addDistPref() {
        List<String> lst = ((PreferencesForm)this.form).getDistPrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToDistPrefs("-", "-");
            }
            this.request.setAttribute(HASH_ATTR, (Object)"DistPref");
        } else {
            this.addFieldError("distPrefs", MSG.errorInvalidDistributionPreference());
        }
    }

    protected void addCoursePref() {
        List<String> lst = ((PreferencesForm)this.form).getCoursePrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToCoursePrefs("-", "-");
            }
            this.request.setAttribute(HASH_ATTR, (Object)"CoursePref");
        } else {
            this.addFieldError("coursePrefs", MSG.errorInvalidCoursePreference());
        }
    }

    protected void addInstructorPref() {
        List<String> lst = ((PreferencesForm)this.form).getInstructorPrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToInstructorPrefs("-", "-");
            }
            this.request.setAttribute(HASH_ATTR, (Object)"InstructorPref");
        } else {
            this.addFieldError("instructorPrefs", MSG.errorInvalidAttributePreference());
        }
    }

    protected void addAttributePref() {
        List<String> lst = ((PreferencesForm)this.form).getAttributePrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToAttributePrefs("-", "-");
            }
            this.request.setAttribute(HASH_ATTR, (Object)"AttributePref");
        } else {
            this.addFieldError("attributePrefs", MSG.errorInvalidAttributePreference());
        }
    }

    protected void addRoomFeatPref() {
        List<String> lst = ((PreferencesForm)this.form).getRoomFeaturePrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToRoomFeatPrefs("-", "-", null);
            }
            this.request.setAttribute(HASH_ATTR, (Object)"RoomFeatPref");
        } else {
            this.addFieldError("roomFeaturePrefs", MSG.errorInvalidRoomFeaturePreference());
        }
    }

    protected void addTimePattern() {
        if ("-".equals(((PreferencesForm)this.form).getTimePattern())) {
            this.addFieldError("timePrefs", MSG.errorTimePatternNotSelected());
        } else {
            if (((PreferencesForm)this.form).getTimePatterns() == null) {
                ((PreferencesForm)this.form).setTimePatterns(new Vector<String>());
            }
            ((PreferencesForm)this.form).getTimePatterns().add(((PreferencesForm)this.form).getTimePattern());
            TimePattern tp = (TimePattern)TimePatternDAO.getInstance().get(Long.valueOf(((PreferencesForm)this.form).getTimePattern()));
            if (tp.getTimePatternModel().isExactTime()) {
                Iterator<String> i = ((PreferencesForm)this.form).getTimePatterns().iterator();
                while (i.hasNext()) {
                    String patternId = i.next();
                    TimePattern tpx = (TimePattern)TimePatternDAO.getInstance().get(Long.valueOf(patternId));
                    if (tpx.getTimePatternModel().isExactTime()) continue;
                    i.remove();
                }
            } else {
                Iterator<String> i = ((PreferencesForm)this.form).getTimePatterns().iterator();
                while (i.hasNext()) {
                    String patternId = i.next();
                    TimePattern tpx = (TimePattern)TimePatternDAO.getInstance().get(Long.valueOf(patternId));
                    if (!tpx.getTimePatternModel().isExactTime()) continue;
                    i.remove();
                }
            }
            this.request.setAttribute(HASH_ATTR, (Object)"TimePref");
        }
    }

    protected void addRoomPref() {
        List<String> lst = ((PreferencesForm)this.form).getRoomPrefs();
        if (((PreferencesForm)this.form).checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                ((PreferencesForm)this.form).addToRoomPrefs("-", "-", null);
            }
            this.request.setAttribute(HASH_ATTR, (Object)"RoomPref");
        } else {
            this.addFieldError("roomPrefs", MSG.errorInvalidRoomPreference());
        }
    }

    protected void doCancel(String subpartId) {
        SchedulingSubpartDAO sdao = SchedulingSubpartDAO.getInstance();
        SchedulingSubpart ss = (SchedulingSubpart)sdao.get(Long.valueOf(subpartId));
        InstructionalOffering io = ss.getInstrOfferingConfig().getInstructionalOffering();
        CourseOffering co = io.getControllingCourseOffering();
        InstructionalOfferingListForm frm2 = new InstructionalOfferingListForm();
        frm2.setSubjectAreaIds(new String[]{co.getSubjectArea().getUniqueId().toString()});
        frm2.setSubjectAreaAbbv(co.getSubjectAreaAbbv());
        frm2.setCourseNbr(co.getCourseNbr());
        frm2.setCtrlInstrOfferingId(co.getUniqueId().toString());
        frm2.setIsControl(co.isIsControl());
        this.request.setAttribute("subjectAreaId", (Object)co.getSubjectArea().getUniqueId().toString());
        this.request.setAttribute("instructionalOfferingListForm", (Object)frm2);
    }

    protected void doDelete() {
        String deleteType = this.request.getParameter("deleteType");
        int deleteId = -1;
        try {
            deleteId = Integer.parseInt(this.request.getParameter("deleteId"));
        }
        catch (Exception e) {
            deleteId = -1;
        }
        if (deleteType != null && deleteId >= 0) {
            List<String> lstI;
            List<String> lstL;
            List<String> lst;
            if (deleteType.equals("roomPref")) {
                lst = ((PreferencesForm)this.form).getRoomPrefs();
                lstL = ((PreferencesForm)this.form).getRoomPrefLevels();
                lstI = ((PreferencesForm)this.form).getRoomPrefIndexes();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                lstI.remove(deleteId);
                ((PreferencesForm)this.form).setRoomPrefs(lst);
                ((PreferencesForm)this.form).setRoomPrefLevels(lstL);
                ((PreferencesForm)this.form).setRoomPrefIndexes(lstI);
                this.request.setAttribute(HASH_ATTR, (Object)"RoomPref");
            }
            if (deleteType.equals("rgPref")) {
                lst = ((PreferencesForm)this.form).getRoomGroups();
                lstL = ((PreferencesForm)this.form).getRoomGroupLevels();
                lstI = ((PreferencesForm)this.form).getRoomGroupIndexes();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                lstI.remove(deleteId);
                ((PreferencesForm)this.form).setRoomGroups(lst);
                ((PreferencesForm)this.form).setRoomGroupLevels(lstL);
                ((PreferencesForm)this.form).setRoomGroupIndexes(lstI);
                this.request.setAttribute(HASH_ATTR, (Object)"RoomGroupPref");
            }
            if (deleteType.equals("bldgPref")) {
                lst = ((PreferencesForm)this.form).getBldgPrefs();
                lstL = ((PreferencesForm)this.form).getBldgPrefLevels();
                lstI = ((PreferencesForm)this.form).getBldgPrefIndexes();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                lstI.remove(deleteId);
                ((PreferencesForm)this.form).setBldgPrefs(lst);
                ((PreferencesForm)this.form).setBldgPrefLevels(lstL);
                ((PreferencesForm)this.form).setBldgPrefIndexes(lstI);
                this.request.setAttribute(HASH_ATTR, (Object)"BldgPref");
            }
            if (deleteType.equals("distPref")) {
                lst = ((PreferencesForm)this.form).getDistPrefs();
                lstL = ((PreferencesForm)this.form).getDistPrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setDistPrefs(lst);
                ((PreferencesForm)this.form).setDistPrefLevels(lstL);
                this.request.setAttribute(HASH_ATTR, (Object)"DistPref");
            }
            if (deleteType.equals("roomFeaturePref")) {
                lst = ((PreferencesForm)this.form).getRoomFeaturePrefs();
                lstL = ((PreferencesForm)this.form).getRoomFeaturePrefLevels();
                lstI = ((PreferencesForm)this.form).getRoomFeaturePrefIndexes();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                lstI.remove(deleteId);
                ((PreferencesForm)this.form).setRoomFeaturePrefs(lst);
                ((PreferencesForm)this.form).setRoomFeaturePrefLevels(lstL);
                ((PreferencesForm)this.form).setRoomFeaturePrefIndexes(lstI);
                this.request.setAttribute(HASH_ATTR, (Object)"RoomFeatPref");
            }
            if (deleteType.equals("timePattern")) {
                List<String> tps = ((PreferencesForm)this.form).getTimePatterns();
                tps.remove(deleteId);
                ((PreferencesForm)this.form).setTimePatterns(tps);
                this.request.setAttribute(HASH_ATTR, (Object)"TimePref");
            }
            if (deleteType.equals("dpPref")) {
                lst = ((PreferencesForm)this.form).getDatePatternPrefs();
                lstL = ((PreferencesForm)this.form).getDatePatternPrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setDatePatternPrefs(lst);
                ((PreferencesForm)this.form).setDatePatternPrefLevels(lstL);
                this.request.setAttribute(HASH_ATTR, (Object)"RoomGroupPref");
            }
            if (deleteType.equals("coursePref")) {
                lst = ((PreferencesForm)this.form).getCoursePrefs();
                lstL = ((PreferencesForm)this.form).getCoursePrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setCoursePrefs(lst);
                ((PreferencesForm)this.form).setCoursePrefLevels(lstL);
                this.request.setAttribute(HASH_ATTR, (Object)"CoursePref");
            }
            if (deleteType.equals("attributePref")) {
                lst = ((PreferencesForm)this.form).getAttributePrefs();
                lstL = ((PreferencesForm)this.form).getAttributePrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setAttributePrefs(lst);
                ((PreferencesForm)this.form).setAttributePrefLevels(lstL);
                this.request.setAttribute(HASH_ATTR, (Object)"AttributePref");
            }
            if (deleteType.equals("instructorPref")) {
                lst = ((PreferencesForm)this.form).getInstructorPrefs();
                lstL = ((PreferencesForm)this.form).getInstructorPrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                ((PreferencesForm)this.form).setInstructorPrefs(lst);
                this.request.setAttribute(HASH_ATTR, (Object)"InstructorPref");
            }
        }
    }

    protected void doClear(Set s, Preference.Type ... typesArray) {
        int types = Preference.Type.toInt(typesArray);
        Iterator i = s.iterator();
        while (i.hasNext()) {
            Preference p = (Preference)i.next();
            if (!p.getType().in(types)) continue;
            i.remove();
        }
    }

    protected void doUpdate(PreferenceGroup pg, Set s, boolean timeVertical, Preference.Type ... typesArray) throws Exception {
        Preference sameParentAp;
        Preference p;
        Iterator<Preference> j;
        String pref;
        Comparable dp2;
        Preference rp;
        Preference p2;
        Iterator<Preference> j2;
        String prefIdx;
        String pref2;
        String id;
        int i;
        List<String> lstL;
        List<String> lst;
        String id2;
        int i2;
        pg.setPreferences(s);
        int types = Preference.Type.toInt(typesArray);
        Iterator i3 = s.iterator();
        while (i3.hasNext()) {
            Preference p3 = (Preference)i3.next();
            if (!p3.getType().in(types)) continue;
            i3.remove();
        }
        if (Preference.Type.TIME.in(types)) {
            if (pg instanceof DepartmentalInstructor) {
                if (((PreferencesForm)this.form).getAvailability() != null && (((PreferencesForm)this.form).getAvailability().length() == 336 || ((PreferencesForm)this.form).getAvailability().length() == 2016)) {
                    TimePref tp = new TimePref();
                    tp.setOwner(pg);
                    tp.setPreference(((PreferencesForm)this.form).getAvailability());
                    tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                    tp.setTimePattern(null);
                    s.add(tp);
                }
            } else {
                Set<TimePref> parentTimePrefs = pg.effectivePreferences(TimePref.class, false);
                List<String> lst2 = ((PreferencesForm)this.form).getTimePatterns();
                for (i2 = 0; i2 < lst2.size(); ++i2) {
                    id2 = lst2.get(i2);
                    this.addToTimePref(pg, id2, s, i2, timeVertical, parentTimePrefs);
                }
                if (parentTimePrefs != null && !parentTimePrefs.isEmpty()) {
                    Iterator<TimePref> i4 = parentTimePrefs.iterator();
                    while (i4.hasNext()) {
                        TimePref tp = (TimePref)i4.next().clone();
                        tp.setOwner(pg);
                        tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                        s.add(tp);
                    }
                }
            }
        }
        if (Preference.Type.ROOM.in(types)) {
            lst = ((PreferencesForm)this.form).getRoomPrefs();
            lstL = ((PreferencesForm)this.form).getRoomPrefLevels();
            List<String> lstI = ((PreferencesForm)this.form).getRoomPrefIndexes();
            Set<RoomPref> parentRoomPrefs = pg.effectivePreferences(RoomPref.class);
            for (i = 0; i < lst.size(); ++i) {
                id = lst.get(i);
                if (id == null || id.equals("-")) continue;
                pref2 = lstL.get(i);
                prefIdx = lstI.get(i);
                Debug.debug("Room: " + id + ": " + pref2);
                LocationDAO rdao = LocationDAO.getInstance();
                Location room = (Location)rdao.get(Long.valueOf(id));
                RoomPref rp2 = new RoomPref();
                rp2.setOwner(pg);
                rp2.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref2)));
                rp2.setRoom(room);
                rp2.setRoomIndex(prefIdx == null || "-".equals(prefIdx) ? null : Integer.valueOf(prefIdx));
                RoomPref sameParentRp = null;
                j2 = parentRoomPrefs.iterator();
                while (j2.hasNext()) {
                    p2 = j2.next();
                    if (!((RoomPref)p2).isSame(rp2, pg)) continue;
                    if (p2.getPrefLevel().equals(rp2.getPrefLevel())) {
                        sameParentRp = rp2;
                    }
                    j2.remove();
                    break;
                }
                if (sameParentRp != null) continue;
                s.add(rp2);
            }
            if (parentRoomPrefs != null && !parentRoomPrefs.isEmpty()) {
                Iterator<RoomPref> i5 = parentRoomPrefs.iterator();
                while (i5.hasNext()) {
                    rp = (RoomPref)i5.next().clone();
                    rp.setOwner(pg);
                    rp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(rp);
                }
            }
        }
        if (Preference.Type.BUILDING.in(types)) {
            lst = ((PreferencesForm)this.form).getBldgPrefs();
            lstL = ((PreferencesForm)this.form).getBldgPrefLevels();
            List<String> lstI = ((PreferencesForm)this.form).getBldgPrefIndexes();
            Set<BuildingPref> parentBuildingPrefs = pg.effectivePreferences(BuildingPref.class);
            for (i = 0; i < lst.size(); ++i) {
                id = lst.get(i);
                if (id == null || id.equals("-")) continue;
                pref2 = lstL.get(i);
                prefIdx = lstI.get(i);
                Debug.debug("Bldg: " + id + ": " + pref2);
                BuildingDAO bdao = BuildingDAO.getInstance();
                Building bldg = (Building)bdao.get(Long.valueOf(id));
                BuildingPref bp = new BuildingPref();
                bp.setOwner(pg);
                bp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref2)));
                bp.setBuilding(bldg);
                bp.setRoomIndex(prefIdx == null || "-".equals(prefIdx) ? null : Integer.valueOf(prefIdx));
                BuildingPref sameParentBp = null;
                j2 = parentBuildingPrefs.iterator();
                while (j2.hasNext()) {
                    p2 = (BuildingPref)j2.next();
                    if (!((BuildingPref)p2).isSame(bp, pg)) continue;
                    if (p2.getPrefLevel().equals(bp.getPrefLevel())) {
                        sameParentBp = bp;
                    }
                    j2.remove();
                    break;
                }
                if (sameParentBp != null) continue;
                s.add(bp);
            }
            if (parentBuildingPrefs != null && !parentBuildingPrefs.isEmpty()) {
                Iterator<BuildingPref> i6 = parentBuildingPrefs.iterator();
                while (i6.hasNext()) {
                    BuildingPref bp = (BuildingPref)i6.next().clone();
                    bp.setOwner(pg);
                    bp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(bp);
                }
            }
        }
        if (Preference.Type.DISTRIBUTION.in(types)) {
            lst = ((PreferencesForm)this.form).getDistPrefs();
            lstL = ((PreferencesForm)this.form).getDistPrefLevels();
            for (i2 = 0; i2 < lst.size(); ++i2) {
                id2 = lst.get(i2);
                if (id2 == null || id2.equals("-")) continue;
                String pref3 = lstL.get(i2);
                Debug.debug("Dist: " + id2 + ": " + pref3);
                DistributionTypeDAO ddao = DistributionTypeDAO.getInstance();
                DistributionType dist = (DistributionType)ddao.get(Long.valueOf(id2));
                dp2 = new DistributionPref();
                dp2.setOwner(pg);
                dp2.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref3)));
                dp2.setDistributionType(dist);
                dp2.setStructure(DistributionPref.Structure.AllClasses);
                s.add(dp2);
            }
        }
        if (Preference.Type.PERIOD.in(types) && pg instanceof Exam) {
            Exam exam = (Exam)pg;
            if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
                ExamSolverProxy solver = WebSolver.getExamSolver(this.request.getSession());
                ExamAssignment assignment = null;
                if (solver != null && exam != null && exam.getUniqueId() != null) {
                    assignment = solver.getAssignment(exam.getUniqueId());
                } else if (exam.getAssignedPeriod() != null) {
                    assignment = new ExamAssignment(exam);
                }
                if (1 == exam.getExamType().getType()) {
                    MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(exam.getSession(), exam.getExamType(), assignment);
                    epx.load(exam);
                    epx.load(this.request);
                    epx.save(s, exam);
                } else {
                    PeriodPreferenceModel px = new PeriodPreferenceModel(exam.getSession(), assignment, exam.getExamType().getUniqueId());
                    px.load(exam);
                    RequiredTimeTable rtt = new RequiredTimeTable(px);
                    rtt.setName("PeriodPref");
                    rtt.update((ServletRequest)this.request);
                    px.save(s, exam);
                }
            } else {
                String pattern = this.request.getParameter("periodPrefs");
                if (pattern.indexOf(58) >= 0) {
                    pattern = pattern.substring(pattern.lastIndexOf(58) + 1);
                }
                int idx = 0;
                String defaultPref = exam.getExamType().getType() == 1 ? PreferenceLevel.sProhibited : PreferenceLevel.sNeutral;
                for (ExamPeriod period : ExamPeriod.findAll(exam.getSession().getUniqueId(), exam.getExamType().getUniqueId())) {
                    String pref4;
                    char ch = exam.getExamType().getType() == 1 ? (char)'P' : '2';
                    try {
                        ch = pattern.charAt(idx++);
                    }
                    catch (IndexOutOfBoundsException dp2) {
                        // empty catch block
                    }
                    if (defaultPref.equals(pref4 = PreferenceLevel.char2prolog(ch))) continue;
                    ExamPeriodPref p4 = new ExamPeriodPref();
                    p4.setOwner(pg);
                    p4.setExamPeriod(period);
                    p4.setPrefLevel(PreferenceLevel.getPreferenceLevel(pref4));
                    s.add(p4);
                }
            }
        }
        if (Preference.Type.ROOM_FEATURE.in(types)) {
            lst = ((PreferencesForm)this.form).getRoomFeaturePrefs();
            lstL = ((PreferencesForm)this.form).getRoomFeaturePrefLevels();
            List<String> lstI = ((PreferencesForm)this.form).getRoomFeaturePrefIndexes();
            Set<RoomFeaturePref> parentRoomFeaturePrefs = pg.effectivePreferences(RoomFeaturePref.class);
            for (int i7 = 0; i7 < lst.size(); ++i7) {
                id = lst.get(i7);
                if (id == null || id.equals("-")) continue;
                String pref5 = lstL.get(i7);
                prefIdx = lstI.get(i7);
                Debug.debug("Room Feat: " + id + ": " + pref5);
                RoomFeatureDAO rfdao = RoomFeatureDAO.getInstance();
                RoomFeature rf = (RoomFeature)rfdao.get(Long.valueOf(id));
                RoomFeaturePref rfp = new RoomFeaturePref();
                rfp.setOwner(pg);
                rfp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref5)));
                rfp.setRoomFeature(rf);
                rfp.setRoomIndex(prefIdx == null || "-".equals(prefIdx) ? null : Integer.valueOf(prefIdx));
                RoomFeaturePref sameParentRfp = null;
                j2 = parentRoomFeaturePrefs.iterator();
                while (j2.hasNext()) {
                    p2 = (RoomFeaturePref)j2.next();
                    if (!((RoomFeaturePref)p2).isSame(rfp, pg)) continue;
                    if (p2.getPrefLevel().equals(rfp.getPrefLevel())) {
                        sameParentRfp = rfp;
                    }
                    j2.remove();
                    break;
                }
                if (sameParentRfp != null) continue;
                s.add(rfp);
            }
            if (parentRoomFeaturePrefs != null && !parentRoomFeaturePrefs.isEmpty()) {
                Iterator<RoomFeaturePref> i8 = parentRoomFeaturePrefs.iterator();
                while (i8.hasNext()) {
                    rp = (RoomFeaturePref)i8.next().clone();
                    rp.setOwner(pg);
                    rp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(rp);
                }
            }
        }
        if (Preference.Type.ROOM_GROUP.in(types)) {
            lst = ((PreferencesForm)this.form).getRoomGroups();
            lstL = ((PreferencesForm)this.form).getRoomGroupLevels();
            List<String> lstI = ((PreferencesForm)this.form).getRoomGroupIndexes();
            Set<RoomGroupPref> parentRoomGroupPrefs = pg.effectivePreferences(RoomGroupPref.class);
            for (int i9 = 0; i9 < lst.size(); ++i9) {
                id = lst.get(i9);
                if (id == null || id.equals("-")) continue;
                String pref6 = lstL.get(i9);
                prefIdx = lstI.get(i9);
                Debug.debug("Roomgr: " + id + ": " + pref6);
                RoomGroupDAO gdao = RoomGroupDAO.getInstance();
                RoomGroup gr = (RoomGroup)gdao.get(Long.valueOf(id));
                RoomGroupPref gp = new RoomGroupPref();
                gp.setOwner(pg);
                gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref6)));
                gp.setRoomGroup(gr);
                gp.setRoomIndex(prefIdx == null || "-".equals(prefIdx) ? null : Integer.valueOf(prefIdx));
                RoomGroupPref sameParentGp = null;
                j2 = parentRoomGroupPrefs.iterator();
                while (j2.hasNext()) {
                    p2 = (RoomGroupPref)j2.next();
                    if (!((RoomGroupPref)p2).isSame(gp, pg)) continue;
                    if (p2.getPrefLevel().equals(gp.getPrefLevel())) {
                        sameParentGp = gp;
                    }
                    j2.remove();
                    break;
                }
                if (sameParentGp != null) continue;
                s.add(gp);
            }
            if (parentRoomGroupPrefs != null && !parentRoomGroupPrefs.isEmpty()) {
                Iterator<RoomGroupPref> i10 = parentRoomGroupPrefs.iterator();
                while (i10.hasNext()) {
                    RoomGroupPref gp = (RoomGroupPref)i10.next().clone();
                    gp.setOwner(pg);
                    gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(gp);
                }
            }
        }
        if (Preference.Type.DATE.in(types)) {
            lst = ((PreferencesForm)this.form).getDatePatternPrefs();
            lstL = ((PreferencesForm)this.form).getDatePatternPrefLevels();
            Set<DatePatternPref> parentDatePatternPrefs = pg.effectivePreferences(DatePatternPref.class);
            for (int i11 = 0; i11 < lst.size(); ++i11) {
                String id3 = lst.get(i11);
                if (id3 == null || id3.equals("-") || lstL.get(i11).equals(PreferenceLevel.PREF_LEVEL_NEUTRAL)) continue;
                pref = lstL.get(i11);
                Debug.debug("Datepattern: " + id3 + ": " + pref);
                DatePatternDAO dpdao = DatePatternDAO.getInstance();
                dp2 = (DatePattern)dpdao.get(Long.valueOf(id3));
                DatePatternPref dpp = new DatePatternPref();
                dpp.setOwner(pg);
                dpp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref)));
                dpp.setDatePattern((DatePattern)dp2);
                DatePatternPref sameParentDp = null;
                j = parentDatePatternPrefs.iterator();
                while (j.hasNext()) {
                    p = (DatePatternPref)j.next();
                    if (!p.isSame(dpp, pg)) continue;
                    if (p.getPrefLevel().equals(dpp.getPrefLevel())) {
                        sameParentDp = dpp;
                    }
                    j.remove();
                    break;
                }
                if (sameParentDp != null) continue;
                s.add(dpp);
            }
            if (parentDatePatternPrefs != null && !parentDatePatternPrefs.isEmpty()) {
                Iterator<DatePatternPref> i12 = parentDatePatternPrefs.iterator();
                while (i12.hasNext()) {
                    DatePatternPref gp = (DatePatternPref)i12.next().clone();
                    if (!pg.effectiveDatePattern().findChildren().contains(gp.getDatePattern())) continue;
                    gp.setOwner(pg);
                    gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(gp);
                }
            }
        }
        if (Preference.Type.COURSE.in(types)) {
            lst = ((PreferencesForm)this.form).getCoursePrefs();
            lstL = ((PreferencesForm)this.form).getCoursePrefLevels();
            for (int i13 = 0; i13 < lst.size(); ++i13) {
                String id4 = lst.get(i13);
                if (id4 == null || id4.equals("-")) continue;
                String pref7 = lstL.get(i13);
                Debug.debug("Course: " + id4 + ": " + pref7);
                CourseOfferingDAO cdao = CourseOfferingDAO.getInstance();
                CourseOffering course = (CourseOffering)cdao.get(Long.valueOf(id4));
                InstructorCoursePref cp = new InstructorCoursePref();
                cp.setOwner(pg);
                cp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref7)));
                cp.setCourse(course);
                s.add(cp);
            }
        }
        if (Preference.Type.ATTRIBUTE.in(types)) {
            lst = ((PreferencesForm)this.form).getAttributePrefs();
            lstL = ((PreferencesForm)this.form).getAttributePrefLevels();
            Set<InstructorAttributePref> parentAttributePrefs = pg.effectivePreferences(InstructorAttributePref.class);
            for (int i14 = 0; i14 < lst.size(); ++i14) {
                String id5 = lst.get(i14);
                if (id5 == null || id5.equals("-")) continue;
                pref = lstL.get(i14);
                Debug.debug("Attribute: " + id5 + ": " + pref);
                InstructorAttributeDAO adao = InstructorAttributeDAO.getInstance();
                InstructorAttribute attribute = (InstructorAttribute)adao.get(Long.valueOf(id5));
                InstructorAttributePref ap = new InstructorAttributePref();
                ap.setOwner(pg);
                ap.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref)));
                ap.setAttribute(attribute);
                sameParentAp = null;
                j = parentAttributePrefs.iterator();
                while (j.hasNext()) {
                    p = (InstructorAttributePref)j.next();
                    if (!p.isSame(ap, pg)) continue;
                    if (p.getPrefLevel().equals(ap.getPrefLevel())) {
                        sameParentAp = p;
                    }
                    j.remove();
                    break;
                }
                if (sameParentAp != null) continue;
                s.add(ap);
            }
            if (parentAttributePrefs != null && !parentAttributePrefs.isEmpty()) {
                Iterator<InstructorAttributePref> i15 = parentAttributePrefs.iterator();
                while (i15.hasNext()) {
                    InstructorAttributePref ap = (InstructorAttributePref)i15.next().clone();
                    ap.setOwner(pg);
                    ap.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(ap);
                }
            }
        }
        if (Preference.Type.INSTRUCTOR.in(types)) {
            lst = ((PreferencesForm)this.form).getInstructorPrefs();
            lstL = ((PreferencesForm)this.form).getInstructorPrefLevels();
            Set<InstructorPref> parentInstructorPrefs = pg.effectivePreferences(InstructorPref.class);
            for (int i16 = 0; i16 < lst.size(); ++i16) {
                String id6 = lst.get(i16);
                if (id6 == null || id6.equals("-")) continue;
                pref = lstL.get(i16);
                Debug.debug("Instructor: " + id6 + ": " + pref);
                DepartmentalInstructorDAO idao = DepartmentalInstructorDAO.getInstance();
                DepartmentalInstructor instructor = (DepartmentalInstructor)idao.get(Long.valueOf(id6));
                InstructorPref ip = new InstructorPref();
                ip.setOwner(pg);
                ip.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref)));
                ip.setInstructor(instructor);
                sameParentAp = null;
                j = parentInstructorPrefs.iterator();
                while (j.hasNext()) {
                    p = (InstructorPref)j.next();
                    if (!p.isSame(ip, pg)) continue;
                    if (p.getPrefLevel().equals(ip.getPrefLevel())) {
                        sameParentAp = p;
                    }
                    j.remove();
                    break;
                }
                if (sameParentAp != null) continue;
                s.add(ip);
            }
            if (parentInstructorPrefs != null && !parentInstructorPrefs.isEmpty()) {
                Iterator<InstructorPref> i17 = parentInstructorPrefs.iterator();
                while (i17.hasNext()) {
                    InstructorPref ap = (InstructorPref)i17.next().clone();
                    ap.setOwner(pg);
                    ap.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(ap);
                }
            }
        }
        pg.setPreferences(s);
    }

    protected void updateInstructorCoursePreferences(org.hibernate.Session hibSession, PreferenceGroup pg, CourseOffering course) {
        HashMap<Long, InstructorCoursePref> prefs = new HashMap<Long, InstructorCoursePref>();
        for (InstructorCoursePref pref : hibSession.createQuery("from InstructorCoursePref where course.uniqueId = :courseId", InstructorCoursePref.class).setParameter("courseId", (Object)course.getUniqueId()).setCacheable(true).list()) {
            prefs.put(pref.getOwner().getUniqueId(), pref);
        }
        List<String> lst = ((PreferencesForm)this.form).getCoursePrefs();
        List<String> lstL = ((PreferencesForm)this.form).getCoursePrefLevels();
        for (int i = 0; i < lst.size(); ++i) {
            String id = lst.get(i);
            if (id == null || id.equals("-")) continue;
            String pref = lstL.get(i);
            Debug.debug("Course: " + id + ": " + pref);
            InstructorCoursePref cp = (InstructorCoursePref)prefs.remove(Long.valueOf(id));
            if (cp == null) {
                DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(Long.valueOf(id), hibSession);
                cp = new InstructorCoursePref();
                cp.setOwner(instructor);
                cp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref)));
                cp.setCourse(course);
                instructor.getPreferences().add(cp);
                hibSession.merge((Object)instructor);
                continue;
            }
            if (cp.getPrefLevel().getPrefId().equals(Integer.valueOf(pref))) continue;
            cp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref)));
            hibSession.merge((Object)cp);
        }
        for (InstructorCoursePref cp : prefs.values()) {
            cp.getOwner().getPreferences().remove(cp);
            hibSession.merge((Object)cp.getOwner());
        }
    }

    protected void addToTimePref(PreferenceGroup owner, String tpat, Set prefs, int idx, boolean timeVertical, Set parentTimePrefs) throws Exception {
        TimePatternDAO timePatternDao = TimePatternDAO.getInstance();
        TimePattern timePattern = tpat.equals("-1") ? null : (TimePattern)timePatternDao.get(Long.valueOf(tpat));
        boolean canUseHardTimePrefs = this.sessionContext.hasPermission(owner, Right.CanUseHardTimePrefs);
        RequiredTimeTable rtt = timePattern == null ? TimePattern.getDefaultRequiredTimeTable() : timePattern.getRequiredTimeTable(canUseHardTimePrefs);
        rtt.getModel().setDefaultSelection(RequiredTimeTable.getTimeGridSize(this.sessionContext.getUser()));
        rtt.setName("p" + idx);
        rtt.update((ServletRequest)this.request);
        TimePref tp = new TimePref();
        tp.setOwner(owner);
        tp.setPreference(rtt.getModel().getPreferences());
        tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
        tp.setTimePattern(timePattern);
        TimePref sameParentTimePref = null;
        if (parentTimePrefs != null && !parentTimePrefs.isEmpty()) {
            Iterator i = parentTimePrefs.iterator();
            while (i.hasNext()) {
                TimePref parentTimePref = (TimePref)i.next();
                if (!parentTimePref.isSame(tp, owner)) continue;
                if (parentTimePref.getPreference().equals(tp.getPreference()) && parentTimePref.getPrefLevel().equals(tp.getPrefLevel())) {
                    sameParentTimePref = parentTimePref;
                }
                i.remove();
                break;
            }
        }
        if (sameParentTimePref == null) {
            prefs.add(tp);
        }
    }

    protected void generateExamPeriodGrid(Exam exam, String op, boolean timeVertical, boolean editable) throws Exception {
        if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
            ExamType type;
            ExamSolverProxy solver = WebSolver.getExamSolver(this.request.getSession());
            ExamAssignment assignment = null;
            if (solver != null && exam != null) {
                assignment = solver.getAssignment(exam.getUniqueId());
            } else if (exam != null && exam.getAssignedPeriod() != null) {
                assignment = new ExamAssignment(exam);
            }
            ExamType examType = type = exam == null ? (ExamType)ExamTypeDAO.getInstance().get(((ExamEditForm)this.form).getExamType()) : exam.getExamType();
            if (1 == type.getType()) {
                MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(exam == null ? (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()) : exam.getSession(), type, assignment);
                if (exam != null) {
                    epx.load(exam);
                }
                ((PreferencesForm)this.form).setHasNotAvailable(true);
                if (!"init".equals(op)) {
                    epx.load(this.request);
                }
                this.request.setAttribute("ExamPeriodGrid", (Object)epx.print(editable, editable ? 0 : exam.getLength()));
            } else {
                PeriodPreferenceModel px = new PeriodPreferenceModel(exam == null ? (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()) : exam.getSession(), assignment, type.getUniqueId());
                if (exam != null) {
                    px.load(exam);
                }
                px.setAllowHard(this.sessionContext.hasPermission(exam, Right.CanUseHardTimePrefs));
                ((PreferencesForm)this.form).setHasNotAvailable(px.hasNotAvailable());
                RequiredTimeTable rtt = new RequiredTimeTable(px);
                rtt.setName("PeriodPref");
                if (!"init".equals(op)) {
                    rtt.update((ServletRequest)this.request);
                }
                this.request.setAttribute("ExamPeriodGrid", (Object)rtt.print(editable, timeVertical, editable, false));
            }
        } else {
            RoomInterface.PeriodPreferenceModel model = new PeriodPreferencesBackend().loadExamPeriodPreferences(WebSolver.getExamSolver(this.request.getSession()), exam, exam == null ? (ExamType)ExamTypeDAO.getInstance().get(((ExamEditForm)this.form).getExamType()) : exam.getExamType(), this.sessionContext);
            if (!op.equals("init") && this.request.getParameter("periodPrefs") != null) {
                model.setPattern(this.request.getParameter("periodPrefs"));
            }
            ((PreferencesForm)this.form).setHasNotAvailable(model.hasNotAvailable());
            if (editable) {
                this.request.setAttribute("ExamPeriodGrid", (Object)("<div id='UniTimeGWT:PeriodPreferences'><input type=\"hidden\" name=\"periodPrefs\" value=\"" + model.getPattern() + "\"></div>"));
            } else {
                this.request.setAttribute("ExamPeriodGrid", (Object)("<div id='UniTimeGWT:PeriodPreferences' style='display: none;'>" + model.getPattern() + "</div>"));
            }
        }
    }

    protected void generateTimePatternGrids(PreferenceGroup pg, int minutes, DurationModel dmod, DatePattern dpat, Set tpat, String op, boolean timeVertical, boolean editable, Vector leadInstructors) throws Exception {
        Vector<TimePref> timePrefs = null;
        List<String> tps = null;
        if ("init".equals(op)) {
            Set<TimePref> tp = pg.effectivePreferences(TimePref.class, leadInstructors, !editable);
            if (tp.size() > 0) {
                timePrefs = new Vector<TimePref>(tp);
                Collections.sort(timePrefs);
                tps = new Vector<String>();
                Enumeration<TimePref> e = timePrefs.elements();
                while (e.hasMoreElements()) {
                    TimePref timePref = e.nextElement();
                    if (timePref.getTimePatternModel().hasNotAvailablePreference()) {
                        ((PreferencesForm)this.form).setHasNotAvailable(true);
                    }
                    tps.add(timePref.getTimePattern() == null ? "-1" : timePref.getTimePattern().getUniqueId().toString());
                }
            } else if (tpat.size() > 0 && editable) {
                Vector x = new Vector(tpat);
                Collections.sort(x);
                tps = new Vector<String>();
                Enumeration e = x.elements();
                while (e.hasMoreElements()) {
                    TimePattern pat = (TimePattern)e.nextElement();
                    tps.add(pat.getUniqueId().toString());
                }
            }
            ((PreferencesForm)this.form).setTimePatterns(tps);
        } else {
            tps = ((PreferencesForm)this.form).getTimePatterns();
        }
        ClassAssignmentProxy.AssignmentInfo assignment = null;
        if (pg instanceof Class_ && this.sessionContext.hasPermission(Right.ClassAssignments)) {
            ClassAssignmentDetails ca = ClassAssignmentDetails.createClassAssignmentDetails(this.sessionContext, this.getCourseTimetablingSolverService().getSolver(), pg.getUniqueId(), true);
            if (ca != null) {
                String assignmentTable = PreferencesAction2.getAssignmentTable(this.sessionContext, this.getCourseTimetablingSolverService().getSolver(), ca, false, null, true);
                if (assignmentTable != null) {
                    this.request.setAttribute("assignmentInfo", (Object)assignmentTable);
                }
            } else {
                String assignmentTable;
                ClassAssignmentProxy cap = this.getClassAssignmentService().getAssignment();
                if (cap != null && (assignment = cap.getAssignment((Class_)pg)) != null && assignment.getUniqueId() != null && (ca = ClassAssignmentDetails.createClassAssignmentDetailsFromAssignment(this.sessionContext, assignment.getUniqueId(), true)) != null && (assignmentTable = PreferencesAction2.getAssignmentTable(this.sessionContext, this.getCourseTimetablingSolverService().getSolver(), ca, false, null, true)) != null) {
                    this.request.setAttribute("assignmentInfo", (Object)assignmentTable);
                }
            }
        }
        if (tps == null || tps.isEmpty()) {
            this.request.setAttribute(TIME_PATTERN_GRID_ATTR, (Object)MSG.errorTimePatternNotSelected());
        } else {
            int idx = 0;
            int deletedTimePatternIdx = -1;
            if ("timePattern".equals(this.request.getParameter("deleteType"))) {
                try {
                    deletedTimePatternIdx = Integer.parseInt(this.request.getParameter("deleteId"));
                }
                catch (Exception assignmentTable) {
                    // empty catch block
                }
            }
            for (String tp : tps) {
                TimePattern timePattern;
                TimePatternDAO timePatternDao = TimePatternDAO.getInstance();
                TimePattern timePattern2 = timePattern = tp.equals("-1") ? null : (TimePattern)timePatternDao.get(Long.valueOf(tp));
                RequiredTimeTable rtt = timePattern == null ? TimePattern.getDefaultRequiredTimeTable() : timePattern.getRequiredTimeTable(assignment == null ? null : assignment.getTimeLocation(), this.sessionContext.hasPermission(pg, Right.CanUseHardTimePrefs));
                rtt.getModel().setDefaultSelection(this.sessionContext.getUser().getProperty(UserProperty.GridSize));
                rtt.setName("p" + idx);
                if (!"init".equals(op)) {
                    if (deletedTimePatternIdx >= 0 && idx >= deletedTimePatternIdx) {
                        rtt.setName("p" + (idx + 1));
                        rtt.update((ServletRequest)this.request);
                        rtt.setName("p" + idx);
                    } else {
                        rtt.update((ServletRequest)this.request);
                    }
                }
                if (timePrefs != null && timePrefs.size() > 0 && "init".equals(op)) {
                    rtt.getModel().setPreferences(timePrefs.elementAt(idx).getPreference());
                }
                String name = null;
                if (timePattern != null && !rtt.getModel().isExactTime()) {
                    if (dpat == null) {
                        name = timePattern.getName() + " <font color=\\'red\\'>" + MSG.warnNoMatchingDatePattern() + "</font>";
                    } else if (dpat.isPatternSet()) {
                        boolean allPatterns = true;
                        Object matching = "";
                        for (DatePattern dch : dpat.findChildren()) {
                            if (dmod.isValidCombination(minutes, dch, timePattern)) {
                                matching = (String)matching + (((String)matching).isEmpty() ? "" : ", ") + dch.getName();
                                continue;
                            }
                            allPatterns = false;
                        }
                        if (((String)matching).isEmpty()) {
                            name = timePattern.getName() + " <font color=\\'red\\'>" + MSG.warnNoMatchingDatePattern() + "</font>";
                        } else if (!allPatterns) {
                            name = timePattern.getName() + " (" + (String)matching + ")";
                        }
                    } else if (!dmod.isValidCombination(minutes, dpat, timePattern)) {
                        name = timePattern.getName() + " <font color=\\'red\\'>" + MSG.warnNoMatchingDatePattern() + "</font>";
                    }
                }
                this.request.setAttribute("timePatternGrid_" + idx, (Object)rtt.print(editable, timeVertical, editable, false, name));
                ++idx;
            }
        }
    }

    protected void initPrefs(PreferenceGroup pg, Vector leadInstructors, boolean addBlankRows) {
        if (pg == null) {
            if (addBlankRows) {
                ((PreferencesForm)this.form).addBlankPrefRows();
            }
            return;
        }
        ((PreferencesForm)this.form).getRoomPrefs().clear();
        ((PreferencesForm)this.form).getRoomPrefLevels().clear();
        ((PreferencesForm)this.form).getRoomPrefIndexes().clear();
        Set<RoomPref> roomPrefs = pg.effectivePreferences(RoomPref.class, leadInstructors);
        for (RoomPref rp : roomPrefs) {
            Debug.debug("Adding room pref ... " + rp.getRoom().getUniqueId().toString());
            ((PreferencesForm)this.form).addToRoomPrefs(rp.getRoom().getUniqueId().toString(), rp.getPrefLevel().getUniqueId().toString(), rp.getRoomIndex());
        }
        ((PreferencesForm)this.form).getRoomFeaturePrefs().clear();
        ((PreferencesForm)this.form).getRoomFeaturePrefLevels().clear();
        ((PreferencesForm)this.form).getRoomFeaturePrefIndexes().clear();
        Set<RoomFeaturePref> roomFeatPrefs = pg.effectivePreferences(RoomFeaturePref.class, leadInstructors);
        for (RoomFeaturePref rfp : roomFeatPrefs) {
            Debug.debug("Adding room feature pref ... " + rfp.getRoomFeature().getUniqueId().toString());
            ((PreferencesForm)this.form).addToRoomFeatPrefs(rfp.getRoomFeature().getUniqueId().toString(), rfp.getPrefLevel().getUniqueId().toString(), rfp.getRoomIndex());
        }
        ((PreferencesForm)this.form).getBldgPrefs().clear();
        ((PreferencesForm)this.form).getBldgPrefLevels().clear();
        ((PreferencesForm)this.form).getBldgPrefIndexes().clear();
        Set<BuildingPref> bldgPrefs = pg.effectivePreferences(BuildingPref.class, leadInstructors);
        for (BuildingPref bp : bldgPrefs) {
            Debug.debug("Adding building pref ... " + bp.getBuilding().getUniqueId().toString());
            ((PreferencesForm)this.form).addToBldgPrefs(bp.getBuilding().getUniqueId().toString(), bp.getPrefLevel().getUniqueId().toString(), bp.getRoomIndex());
        }
        ((PreferencesForm)this.form).getDistPrefs().clear();
        ((PreferencesForm)this.form).getDistPrefLevels().clear();
        Set<DistributionPref> distPrefs = pg.effectivePreferences(DistributionPref.class, leadInstructors);
        for (DistributionPref dp : distPrefs) {
            Debug.debug("Adding distribution pref ... " + dp.getDistributionType().getUniqueId().toString());
            ((PreferencesForm)this.form).addToDistPrefs(dp.getDistributionType().getUniqueId().toString(), dp.getPrefLevel().getUniqueId().toString());
        }
        ((PreferencesForm)this.form).getRoomGroups().clear();
        ((PreferencesForm)this.form).getRoomGroupLevels().clear();
        ((PreferencesForm)this.form).getRoomGroupIndexes().clear();
        Set<RoomGroupPref> rgPrefs = pg.effectivePreferences(RoomGroupPref.class, leadInstructors);
        for (RoomGroupPref bp : rgPrefs) {
            Debug.debug("Adding room group pref ... " + bp.getRoomGroup().getUniqueId().toString());
            ((PreferencesForm)this.form).addToRoomGroups(bp.getRoomGroup().getUniqueId().toString(), bp.getPrefLevel().getUniqueId().toString(), bp.getRoomIndex());
        }
        Set<DatePatternPref> datePatternPrefs = pg.effectivePreferences(DatePatternPref.class);
        ((PreferencesForm)this.form).getDatePatternPrefs().clear();
        ((PreferencesForm)this.form).getDatePatternPrefLevels().clear();
        for (DatePatternPref dp : datePatternPrefs) {
            if (!dp.appliesTo(pg)) continue;
            Debug.debug("Adding date pattern pref ... " + dp.getDatePattern().getUniqueId().toString());
            ((PreferencesForm)this.form).addToDatePatternPrefs(dp.getDatePattern().getUniqueId().toString(), dp.getPrefLevel().getUniqueId().toString());
        }
        ((PreferencesForm)this.form).getCoursePrefs().clear();
        ((PreferencesForm)this.form).getCoursePrefLevels().clear();
        Set<InstructorCoursePref> coursePrefs = pg.effectivePreferences(InstructorCoursePref.class, leadInstructors);
        for (InstructorCoursePref cp : coursePrefs) {
            Debug.debug("Adding course pref ... " + cp.getCourse().getCourseName());
            if (pg instanceof DepartmentalInstructor) {
                ((PreferencesForm)this.form).addToCoursePrefs(cp.getCourse().getUniqueId().toString(), cp.getPrefLevel().getUniqueId().toString());
                continue;
            }
            ((PreferencesForm)this.form).addToCoursePrefs(cp.getOwner().getUniqueId().toString(), cp.getPrefLevel().getUniqueId().toString());
        }
        ((PreferencesForm)this.form).getAttributePrefs().clear();
        ((PreferencesForm)this.form).getAttributePrefLevels().clear();
        Set<InstructorAttributePref> attributePrefs = pg.effectivePreferences(InstructorAttributePref.class, leadInstructors);
        for (InstructorAttributePref ap : attributePrefs) {
            Debug.debug("Adding attribute pref ... " + ap.getAttribute().getName());
            ((PreferencesForm)this.form).addToAttributePrefs(ap.getAttribute().getUniqueId().toString(), ap.getPrefLevel().getUniqueId().toString());
        }
        ((PreferencesForm)this.form).getInstructorPrefs().clear();
        ((PreferencesForm)this.form).getInstructorPrefLevels().clear();
        Set<InstructorPref> instructorPrefs = pg.effectivePreferences(InstructorPref.class, leadInstructors);
        for (InstructorPref ap : instructorPrefs) {
            Debug.debug("Adding instructor pref ... " + ap.getInstructor().getName(NameFormat.LAST_FIRST_MIDDLE.reference()));
            ((PreferencesForm)this.form).addToInstructorPrefs(ap.getInstructor().getUniqueId().toString(), ap.getPrefLevel().getUniqueId().toString());
        }
        if (addBlankRows) {
            ((PreferencesForm)this.form).addBlankPrefRows();
        }
    }

    protected void clearPrefs() {
        ((PreferencesForm)this.form).clearPrefs();
    }

    public static String getAssignmentTable(SessionContext context, SolverProxy solver, ClassAssignmentDetails ca, boolean dispLinks, Hint selection, boolean dispDate) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (ca.getTime() == null) {
            sb.append("<TR><TD colspan='2'><I>" + MSG.messageNotAssigned() + "</I></TD></TR>");
        } else {
            if (dispDate) {
                sb.append("<TR><TD>" + MSG.propertyDate() + "</TD><TD>" + ca.getAssignedTime().getDatePatternHtml() + "</TD></TR>");
            }
            sb.append("<TR><TD>" + MSG.propertyTime() + "</TD><TD>" + ca.getAssignedTime().toHtml(false, false, true, true) + "</TD></TR>");
            if (ca.getAssignedRoom() != null) {
                sb.append("<TR><TD>" + MSG.propertyRoom() + "</TD><TD>");
                for (i = 0; i < ca.getAssignedRoom().length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(ca.getAssignedRoom()[i].toHtml(false, false, true));
                }
                sb.append("</TD></TR>");
            }
        }
        if (ca.getInstructor() != null) {
            sb.append("<TR><TD>" + MSG.propertyInstructor() + "</TD><TD>" + ca.getInstructorHtml() + "</TD></TR>");
            if (!ca.getBtbInstructors().isEmpty()) {
                sb.append("<TR><TD></TD><TD>");
                Enumeration e = ca.getBtbInstructors().elements();
                while (e.hasMoreElements()) {
                    ClassAssignmentDetails.BtbInstructorInfo btb = (ClassAssignmentDetails.BtbInstructorInfo)e.nextElement();
                    sb.append(btb.toHtml(context, solver));
                    if (!e.hasMoreElements()) continue;
                    sb.append("<br>");
                }
                sb.append("</TD></TR>");
            }
        }
        if (ca.getInitialTime() != null) {
            sb.append("<TR><TD nowrap>" + MSG.propertyInitialAssignment() + "</TD><TD>");
            if (ca.isInitial()) {
                sb.append("<I>" + MSG.messageThisOne() + "</I>");
            } else {
                sb.append(ca.getInitialTime().toHtml(false, false, true, true) + " ");
                for (i = 0; i < ca.getInitialRoom().length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(ca.getInitialRoom()[i].toHtml(false, false, true));
                }
                sb.append("</TD></TR>");
            }
            sb.append("</TD></TR>");
        }
        if (!ca.getStudentConflicts().isEmpty()) {
            sb.append("<TR><TD nowrap>" + MSG.propertyStudentConflicts() + "</TD><TD>");
            Collections.sort(ca.getStudentConflicts(), new ClassAssignmentDetails.StudentConflictInfoComparator(context, solver));
            Enumeration e = ca.getStudentConflicts().elements();
            while (e.hasMoreElements()) {
                ClassAssignmentDetails.StudentConflictInfo std = (ClassAssignmentDetails.StudentConflictInfo)e.nextElement();
                sb.append(std.toHtml(context, solver, dispLinks));
                if (!e.hasMoreElements()) continue;
                sb.append("<BR>");
            }
            sb.append("</TD></TR>");
        }
        if (ca.hasViolatedGroupConstraint()) {
            sb.append("<TR><TD>" + MSG.propertyViolatedConstraints() + "</TD><TD>");
            Enumeration e = ca.getGroupConstraints().elements();
            while (e.hasMoreElements()) {
                ClassAssignmentDetails.DistributionInfo gc = (ClassAssignmentDetails.DistributionInfo)e.nextElement();
                if (gc.getInfo().isSatisfied()) continue;
                sb.append(gc.toHtml(context, solver, dispLinks));
                if (!e.hasMoreElements()) continue;
                sb.append("<BR>");
            }
            sb.append("</TD></TR>");
        }
        if (dispLinks) {
            if (!ca.getRooms().isEmpty()) {
                sb.append("<TR><TD nowrap>" + MSG.propertyRoomLocations() + "</TD><TD>" + ca.getRooms().toHtml(true, true, selection) + "</TD></TR>");
            } else {
                sb.append("<input type='hidden' name='nrRooms' value='0'/>");
                sb.append("<input type='hidden' name='roomState' value='0'/>");
            }
            if (!ca.getTimes().isEmpty()) {
                sb.append("<TR><TD nowrap>" + MSG.propertyTimeLocations() + "</TD><TD>" + ca.getTimes().toHtml(true, true, selection) + "</TD></TR>");
                sb.append("<TR" + (ca.getTimes().getNrDates() <= 1 ? " style='display:none;'" : "") + "><TD nowrap>" + MSG.propertyDatePatterns() + "</TD><TD>" + ca.getTimes().toDatesHtml(true, true, selection) + "</TD></TR>");
            }
        }
        if (dispLinks && ca.getClazz() != null && ca.getClazz().getRoomCapacity() >= 0 && ca.getClazz().getRoomCapacity() < Integer.MAX_VALUE && ca.getClazz().nrRooms() > 0) {
            sb.append("<TR><TD>" + MSG.propertyMinimumRoomSize() + "</TD><TD>" + ca.getClazz().getRoomCapacity() + "</TD></TR>");
        }
        if (dispLinks && ca.getClazz() != null && ca.getClazz().getNote() != null) {
            sb.append("<TR><TD>" + MSG.propertyNote() + "</TD><TD>" + ca.getClazz().getNote().replaceAll("\n", "<BR>") + "</TD></TR>");
        }
        return sb.toString();
    }
}

