/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.StudentSchedulingRule;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.match.CourseMatcher;
import org.unitime.timetable.onlinesectioning.match.StudentMatcher;
import org.unitime.timetable.onlinesectioning.model.XClassEnrollment;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XSchedulingRule;
import org.unitime.timetable.onlinesectioning.model.XSchedulingRules;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XTime;

public interface OnlineSectioningServer {
    public String getHost();

    public String getUser();

    public AcademicSessionInfo getAcademicSession();

    public DistanceMetric getDistanceMetric();

    public DistanceMetric getUnavailabilityDistanceMetric();

    public DataProperties getConfig();

    public OverExpectedCriterion getOverExpectedCriterion();

    public Collection<? extends XCourseId> findCourses(String var1, Integer var2, CourseMatcher var3, Comparator<XCourseId> var4);

    public Collection<? extends XCourseId> findCourses(String var1, Integer var2, CourseMatcher var3);

    public Collection<? extends XCourseId> findCourses(CourseMatcher var1);

    public Collection<? extends XStudentId> findStudents(StudentMatcher var1);

    public XCourse getCourse(Long var1);

    public XCourseId getCourse(String var1);

    public XCourseId getCourse(Long var1, String var2);

    public String getCourseDetails(Long var1, CourseDetailsProvider var2);

    public XStudent getStudent(Long var1);

    public XOffering getOffering(Long var1);

    public Collection<XCourseRequest> getRequests(Long var1);

    public XEnrollments getEnrollments(Long var1);

    public XExpectations getExpectations(Long var1);

    public Collection<Long> getInstructedOfferings(String var1);

    public Set<Long> getRequestedCourseIds(Long var1);

    public void update(XExpectations var1);

    public <X extends OnlineSectioningAction> X createAction(Class<X> var1) throws SectioningException;

    public <E> E execute(OnlineSectioningAction<E> var1, OnlineSectioningLog.Entity var2) throws SectioningException;

    public <E> void execute(OnlineSectioningAction<E> var1, OnlineSectioningLog.Entity var2, ServerCallback<E> var3) throws SectioningException;

    public void remove(XStudent var1);

    public void update(XStudent var1, boolean var2);

    public void remove(XOffering var1);

    public void update(XOffering var1);

    public void clearAll();

    public void clearAllStudents();

    public XCourseRequest assign(XCourseRequest var1, XEnrollment var2);

    public XCourseRequest waitlist(XCourseRequest var1, boolean var2);

    public Lock readLock();

    public Lock writeLock();

    public Lock lockAll();

    public Lock lockStudent(Long var1, Collection<Long> var2, String var3);

    public Lock lockOffering(Long var1, Collection<Long> var2, String var3);

    public Lock lockRequest(CourseRequestInterface var1, String var2);

    public boolean isOfferingLocked(Long var1);

    public void lockOffering(Long var1);

    public void unlockOffering(Long var1);

    public Collection<Long> getLockedOfferings();

    public void releaseAllOfferingLocks();

    public void persistExpectedSpaces(Long var1);

    public List<Long> getOfferingsToPersistExpectedSpaces(long var1);

    public boolean needPersistExpectedSpaces(Long var1);

    public boolean isReady();

    public boolean checkDeadline(Long var1, XTime var2, Deadline var3);

    public CourseDeadlines getCourseDeadlines(Long var1);

    public void unload();

    public void reload();

    public long getMemUsage();

    public <E> E getProperty(String var1, E var2);

    public <E> void setProperty(String var1, E var2);

    public void setSchedulingRules(XSchedulingRules var1);

    public XSchedulingRule getSchedulingRule(Long var1, StudentSchedulingRule.Mode var2, boolean var3, boolean var4);

    public XSchedulingRule getSchedulingRule(XStudent var1, StudentSchedulingRule.Mode var2, boolean var3, boolean var4);

    public XStudent getStudentForExternalId(String var1);

    public Collection<XClassEnrollment> getStudentSchedule(String var1);

    public float[] getCredits(String var1);

    public float[] getCredits(XStudent var1);

    public static interface CourseDeadlines
    extends Serializable {
        public boolean isEnabled();

        public boolean checkDeadline(XTime var1, Deadline var2);
    }

    public static interface ServerCallback<E> {
        public void onFailure(Throwable var1);

        public void onSuccess(E var1);
    }

    public static interface Lock {
        public void release();
    }

    public static enum Deadline {
        NEW,
        CHANGE,
        DROP;

    }
}

