/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.RefTableEntry;

@MappedSuperclass
public abstract class BaseRefTableEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iReference;
    private String iLabel;

    public BaseRefTableEntry() {
    }

    public BaseRefTableEntry(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="ref_table_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="reference", nullable=false, length=20)
    public String getReference() {
        return this.iReference;
    }

    public void setReference(String reference) {
        this.iReference = reference;
    }

    @Column(name="label", nullable=true, length=60)
    public String getLabel() {
        return this.iLabel;
    }

    public void setLabel(String label) {
        this.iLabel = label;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RefTableEntry)) {
            return false;
        }
        if (this.getUniqueId() == null || ((RefTableEntry)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((RefTableEntry)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "RefTableEntry[" + this.getUniqueId() + " " + this.getLabel() + "]";
    }

    public String toDebugString() {
        return "RefTableEntry[\n\tLabel: " + this.getLabel() + "\n\tReference: " + this.getReference() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

