/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.ArrangeCreditUnitConfig;
import org.unitime.timetable.model.CourseCreditFormat;
import org.unitime.timetable.model.CourseCreditType;
import org.unitime.timetable.model.CourseCreditUnitType;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.VariableFixedCreditUnitConfig;
import org.unitime.timetable.model.VariableRangeCreditUnitConfig;
import org.unitime.timetable.model.base.BaseCourseCreditUnitConfig;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="course_credit_unit_config")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="credit_format", discriminatorType=DiscriminatorType.STRING)
public abstract class CourseCreditUnitConfig
extends BaseCourseCreditUnitConfig {
    private static final long serialVersionUID = 1L;
    protected static DecimalFormat sCreditFormat = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));

    public CourseCreditUnitConfig() {
    }

    public CourseCreditUnitConfig(Long uniqueId) {
        super(uniqueId);
    }

    public static CourseCreditUnitConfig createCreditUnitConfigOfFormat(String creditFormat, String creditType, String creditUnitType, Float units, Float maxUnits, Boolean fractionalIncrementsAllowed, Boolean creditAtCourseLevel) {
        if (creditFormat == null || creditFormat.length() == 0 | creditType == null | creditUnitType == null || creditType.length() == 0 | creditUnitType.length() == 0) {
            return null;
        }
        CourseCreditType cct = CourseCreditType.getCourseCreditTypeForReference(creditType);
        CourseCreditUnitType ccut = CourseCreditUnitType.getCourseCreditUnitTypeForReference(creditUnitType);
        return CourseCreditUnitConfig.createCreditUnitConfigOfFormat(creditFormat, cct, ccut, units, maxUnits, fractionalIncrementsAllowed, creditAtCourseLevel);
    }

    public static CourseCreditUnitConfig createCreditUnitConfigOfFormat(String creditFormat, Long creditType, Long creditUnitType, Float units, Float maxUnits, Boolean fractionalIncrementsAllowed, Boolean creditAtCourseLevel) {
        if (creditFormat == null || creditFormat.length() == 0) {
            return null;
        }
        CourseCreditType cct = CourseCreditType.getCourseCreditTypeForUniqueId(creditType);
        CourseCreditUnitType ccut = CourseCreditUnitType.getCourseCreditUnitTypeForUniqueId(creditUnitType);
        return CourseCreditUnitConfig.createCreditUnitConfigOfFormat(creditFormat, cct, ccut, units, maxUnits, fractionalIncrementsAllowed, creditAtCourseLevel);
    }

    public static CourseCreditUnitConfig createCreditUnitConfigOfFormat(String creditFormat, CourseCreditType creditType, CourseCreditUnitType creditUnitType, Float units, Float maxUnits, Boolean fractionalIncrementsAllowed, Boolean creditAtCourseLevel) {
        if (creditFormat == null || creditFormat.length() == 0) {
            return null;
        }
        CourseCreditUnitConfig ccuc = null;
        if (creditFormat.equals(FixedCreditUnitConfig.CREDIT_FORMAT)) {
            FixedCreditUnitConfig fcuc = new FixedCreditUnitConfig();
            fcuc.setFixedUnits(units);
            ccuc = fcuc;
        } else if (creditFormat.equals(VariableFixedCreditUnitConfig.CREDIT_FORMAT)) {
            VariableFixedCreditUnitConfig vfcuc = new VariableFixedCreditUnitConfig();
            vfcuc.setMinUnits(units);
            vfcuc.setMaxUnits(maxUnits);
            ccuc = vfcuc;
        } else if (creditFormat.equals(VariableRangeCreditUnitConfig.CREDIT_FORMAT)) {
            VariableRangeCreditUnitConfig vrcuc = new VariableRangeCreditUnitConfig();
            vrcuc.setMinUnits(units);
            vrcuc.setMaxUnits(maxUnits);
            vrcuc.setFractionalIncrementsAllowed(fractionalIncrementsAllowed);
            ccuc = vrcuc;
        } else if (creditFormat.endsWith(ArrangeCreditUnitConfig.CREDIT_FORMAT)) {
            ccuc = new ArrangeCreditUnitConfig();
        } else {
            return null;
        }
        ccuc.setCourseCreditFormat(CourseCreditFormat.getCourseCreditForReference(creditFormat));
        ccuc.setDefinesCreditAtCourseLevel(creditAtCourseLevel);
        ccuc.setCreditType(creditType);
        ccuc.setCreditUnitType(creditUnitType);
        return ccuc;
    }

    public abstract String creditText();

    public abstract String creditAbbv();

    public void setOwner(SchedulingSubpart schedulingSubpart) {
        if (!this.isDefinesCreditAtCourseLevel().booleanValue()) {
            this.setSubpartOwner(schedulingSubpart);
        }
    }

    public void setOwner(CourseOffering courseOffering) {
        if (this.isDefinesCreditAtCourseLevel().booleanValue()) {
            this.setCourseOwner(courseOffering);
        }
    }

    @Transient
    public String getCreditFormat() {
        CourseCreditFormat ccf = this.getCourseCreditFormat();
        return ccf == null ? null : ccf.getReference();
    }

    @Transient
    public String getCreditFormatAbbv() {
        CourseCreditFormat ccf = this.getCourseCreditFormat();
        return ccf == null || ccf.getAbbreviation() == null ? "" : ccf.getAbbreviation();
    }

    protected void baseClone(CourseCreditUnitConfig newCreditConfig) {
        newCreditConfig.setCourseCreditFormat(this.getCourseCreditFormat());
        newCreditConfig.setCreditType(this.getCreditType());
        newCreditConfig.setCreditUnitType(this.getCreditUnitType());
        newCreditConfig.setDefinesCreditAtCourseLevel(this.isDefinesCreditAtCourseLevel());
    }

    @Transient
    public abstract float getMinCredit();

    @Transient
    public abstract float getMaxCredit();

    public abstract Object clone();

    @Override
    public String toString() {
        return this.creditText();
    }
}

