/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import org.unitime.timetable.gwt.client.sectioning.AdvisorCourseRequestsTable;
import org.unitime.timetable.gwt.client.sectioning.DegreePlanDialog;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

public class AdvisorCourseRequestsDialog
extends UniTimeDialogBox {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private SimpleForm iForm;
    private UniTimeHeaderPanel iFooter;
    private TakesValue<CourseRequestInterface> iRequests;
    private AdvisorCourseRequestsTable iTable;
    private DegreePlanDialog.AssignmentProvider iAssignments;

    public AdvisorCourseRequestsDialog(TakesValue<CourseRequestInterface> requests, DegreePlanDialog.AssignmentProvider assignments) {
        super(true, false);
        this.setEscapeToHide(true);
        this.addStyleName("unitime-AdvisorCourseRequestsDialog");
        this.setText(MESSAGES.dialogAdvisorCourseRequests());
        this.iRequests = requests;
        this.iAssignments = assignments;
        this.iForm = new SimpleForm();
        this.iTable = new AdvisorCourseRequestsTable();
        ScrollPanel scroll = new ScrollPanel((Widget)this.iTable);
        scroll.setStyleName("unitime-ScrollPanel");
        scroll.addStyleName("requests");
        this.iForm.addRow((Widget)scroll);
        this.iFooter = new UniTimeHeaderPanel();
        this.iFooter.addButton("apply", MESSAGES.buttonAdvisorRequestsApply(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AdvisorCourseRequestsDialog.this.doApply();
            }
        });
        this.iFooter.addButton("close", MESSAGES.buttonAdvisorRequestsClose(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AdvisorCourseRequestsDialog.this.hide();
            }
        });
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.setWidget((Widget)this.iForm);
    }

    protected void doApply() {
        this.hide();
        this.iRequests.setValue((Object)this.createRequests());
    }

    protected CourseRequestInterface createRequests() {
        CourseRequestInterface.Request request;
        CourseRequestInterface requests = (CourseRequestInterface)this.iRequests.getValue();
        Iterator<CourseRequestInterface.Request> i = requests.getCourses().iterator();
        while (i.hasNext()) {
            request = i.next();
            if (!request.isCanDelete() || this.isLast(request)) continue;
            i.remove();
        }
        i = requests.getAlternatives().iterator();
        while (i.hasNext()) {
            request = i.next();
            if (!request.isCanDelete()) continue;
            if (this.isLast(request)) {
                requests.getCourses().add(request);
            }
            i.remove();
        }
        requests.applyAdvisorRequests(this.iTable.getValue());
        return requests;
    }

    protected boolean isLast(CourseRequestInterface.Request request) {
        for (CourseRequestInterface.RequestedCourse course : request.getRequestedCourse()) {
            if (!this.isLast(course)) continue;
            return true;
        }
        return false;
    }

    protected boolean isLast(CourseRequestInterface.RequestedCourse course) {
        if (course == null || course.isEmpty()) {
            return false;
        }
        if (this.iAssignments != null && this.iAssignments.getLastAssignment() != null) {
            for (ClassAssignmentInterface.CourseAssignment c : this.iAssignments.getLastAssignment().getCourseAssignments()) {
                if (!course.equals(c) || !c.isAssigned()) continue;
                return true;
            }
        }
        return false;
    }

    public void open(CourseRequestInterface requests) {
        this.iTable.setMode(requests.getWaitListMode());
        this.iTable.setValue(requests);
        this.center();
    }
}

